/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The error that has occurred when attempting to retrieve a batch of Records.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetRecordError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetRecordError.Builder, BatchGetRecordError> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(BatchGetRecordError::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()).build();

    private static final SdkField<String> RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecordIdentifierValueAsString")
            .getter(getter(BatchGetRecordError::recordIdentifierValueAsString))
            .setter(setter(Builder::recordIdentifierValueAsString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIdentifierValueAsString")
                    .build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(BatchGetRecordError::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(BatchGetRecordError::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD,
            RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String featureGroupName;

    private final String recordIdentifierValueAsString;

    private final String errorCode;

    private final String errorMessage;

    private BatchGetRecordError(BuilderImpl builder) {
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifierValueAsString = builder.recordIdentifierValueAsString;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The name of the feature group that the record belongs to.
     * </p>
     * 
     * @return The name of the feature group that the record belongs to.
     */
    public final String featureGroupName() {
        return featureGroupName;
    }

    /**
     * <p>
     * The value for the <code>RecordIdentifier</code> in string format of a Record from a <code>FeatureGroup</code>
     * that is causing an error when attempting to be retrieved.
     * </p>
     * 
     * @return The value for the <code>RecordIdentifier</code> in string format of a Record from a
     *         <code>FeatureGroup</code> that is causing an error when attempting to be retrieved.
     */
    public final String recordIdentifierValueAsString() {
        return recordIdentifierValueAsString;
    }

    /**
     * <p>
     * The error code of an error that has occured when attempting to retrieve a batch of Records. For more information
     * on errors, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_GetRecord.html#API_feature_store_GetRecord_Errors"
     * > Errors</a>.
     * </p>
     * 
     * @return The error code of an error that has occured when attempting to retrieve a batch of Records. For more
     *         information on errors, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_GetRecord.html#API_feature_store_GetRecord_Errors"
     *         > Errors</a>.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message of an error that has occured when attempting to retrieve a record in the batch.
     * </p>
     * 
     * @return The error message of an error that has occured when attempting to retrieve a record in the batch.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(recordIdentifierValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRecordError)) {
            return false;
        }
        BatchGetRecordError other = (BatchGetRecordError) obj;
        return Objects.equals(featureGroupName(), other.featureGroupName())
                && Objects.equals(recordIdentifierValueAsString(), other.recordIdentifierValueAsString())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetRecordError").add("FeatureGroupName", featureGroupName())
                .add("RecordIdentifierValueAsString", recordIdentifierValueAsString()).add("ErrorCode", errorCode())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "RecordIdentifierValueAsString":
            return Optional.ofNullable(clazz.cast(recordIdentifierValueAsString()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRecordError, T> g) {
        return obj -> g.apply((BatchGetRecordError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetRecordError> {
        /**
         * <p>
         * The name of the feature group that the record belongs to.
         * </p>
         * 
         * @param featureGroupName
         *        The name of the feature group that the record belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * The value for the <code>RecordIdentifier</code> in string format of a Record from a <code>FeatureGroup</code>
         * that is causing an error when attempting to be retrieved.
         * </p>
         * 
         * @param recordIdentifierValueAsString
         *        The value for the <code>RecordIdentifier</code> in string format of a Record from a
         *        <code>FeatureGroup</code> that is causing an error when attempting to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordIdentifierValueAsString(String recordIdentifierValueAsString);

        /**
         * <p>
         * The error code of an error that has occured when attempting to retrieve a batch of Records. For more
         * information on errors, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_GetRecord.html#API_feature_store_GetRecord_Errors"
         * > Errors</a>.
         * </p>
         * 
         * @param errorCode
         *        The error code of an error that has occured when attempting to retrieve a batch of Records. For more
         *        information on errors, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_GetRecord.html#API_feature_store_GetRecord_Errors"
         *        > Errors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message of an error that has occured when attempting to retrieve a record in the batch.
         * </p>
         * 
         * @param errorMessage
         *        The error message of an error that has occured when attempting to retrieve a record in the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String featureGroupName;

        private String recordIdentifierValueAsString;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRecordError model) {
            featureGroupName(model.featureGroupName);
            recordIdentifierValueAsString(model.recordIdentifierValueAsString);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getRecordIdentifierValueAsString() {
            return recordIdentifierValueAsString;
        }

        public final void setRecordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
        }

        @Override
        public final Builder recordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public BatchGetRecordError build() {
            return new BatchGetRecordError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
