/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecordResponse extends SageMakerFeatureStoreRuntimeResponse implements
        ToCopyableBuilder<GetRecordResponse.Builder, GetRecordResponse> {
    private static final SdkField<List<FeatureValue>> RECORD_FIELD = SdkField
            .<List<FeatureValue>> builder(MarshallingType.LIST)
            .memberName("Record")
            .getter(getter(GetRecordResponse::record))
            .setter(setter(Builder::record))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Record").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeatureValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeatureValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_FIELD));

    private final List<FeatureValue> record;

    private GetRecordResponse(BuilderImpl builder) {
        super(builder);
        this.record = builder.record;
    }

    /**
     * For responses, this returns true if the service returned a value for the Record property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecord() {
        return record != null && !(record instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The record you requested. A list of <code>FeatureValues</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecord} method.
     * </p>
     * 
     * @return The record you requested. A list of <code>FeatureValues</code>.
     */
    public final List<FeatureValue> record() {
        return record;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRecord() ? record() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordResponse)) {
            return false;
        }
        GetRecordResponse other = (GetRecordResponse) obj;
        return hasRecord() == other.hasRecord() && Objects.equals(record(), other.record());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecordResponse").add("Record", hasRecord() ? record() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Record":
            return Optional.ofNullable(clazz.cast(record()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecordResponse, T> g) {
        return obj -> g.apply((GetRecordResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerFeatureStoreRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecordResponse> {
        /**
         * <p>
         * The record you requested. A list of <code>FeatureValues</code>.
         * </p>
         * 
         * @param record
         *        The record you requested. A list of <code>FeatureValues</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(Collection<FeatureValue> record);

        /**
         * <p>
         * The record you requested. A list of <code>FeatureValues</code>.
         * </p>
         * 
         * @param record
         *        The record you requested. A list of <code>FeatureValues</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(FeatureValue... record);

        /**
         * <p>
         * The record you requested. A list of <code>FeatureValues</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FeatureValue>.Builder} avoiding the need to
         * create one manually via {@link List<FeatureValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FeatureValue>.Builder#build()} is called immediately and its
         * result is passed to {@link #record(List<FeatureValue>)}.
         * 
         * @param record
         *        a consumer that will call methods on {@link List<FeatureValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #record(List<FeatureValue>)
         */
        Builder record(Consumer<FeatureValue.Builder>... record);
    }

    static final class BuilderImpl extends SageMakerFeatureStoreRuntimeResponse.BuilderImpl implements Builder {
        private List<FeatureValue> record = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordResponse model) {
            super(model);
            record(model.record);
        }

        public final List<FeatureValue.Builder> getRecord() {
            List<FeatureValue.Builder> result = RecordCopier.copyToBuilder(this.record);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecord(Collection<FeatureValue.BuilderImpl> record) {
            this.record = RecordCopier.copyFromBuilder(record);
        }

        @Override
        @Transient
        public final Builder record(Collection<FeatureValue> record) {
            this.record = RecordCopier.copy(record);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder record(FeatureValue... record) {
            record(Arrays.asList(record));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder record(Consumer<FeatureValue.Builder>... record) {
            record(Stream.of(record).map(c -> FeatureValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRecordResponse build() {
            return new GetRecordResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
