/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value associated with a feature.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FeatureValue implements SdkPojo, Serializable, ToCopyableBuilder<FeatureValue.Builder, FeatureValue> {
    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureName").getter(getter(FeatureValue::featureName)).setter(setter(Builder::featureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureName").build()).build();

    private static final SdkField<String> VALUE_AS_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueAsString").getter(getter(FeatureValue::valueAsString)).setter(setter(Builder::valueAsString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueAsString").build()).build();

    private static final SdkField<List<String>> VALUE_AS_STRING_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ValueAsStringList")
            .getter(getter(FeatureValue::valueAsStringList))
            .setter(setter(Builder::valueAsStringList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueAsStringList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_NAME_FIELD,
            VALUE_AS_STRING_FIELD, VALUE_AS_STRING_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("FeatureName", FEATURE_NAME_FIELD);
                    put("ValueAsString", VALUE_AS_STRING_FIELD);
                    put("ValueAsStringList", VALUE_AS_STRING_LIST_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String featureName;

    private final String valueAsString;

    private final List<String> valueAsStringList;

    private FeatureValue(BuilderImpl builder) {
        this.featureName = builder.featureName;
        this.valueAsString = builder.valueAsString;
        this.valueAsStringList = builder.valueAsStringList;
    }

    /**
     * <p>
     * The name of a feature that a feature value corresponds to.
     * </p>
     * 
     * @return The name of a feature that a feature value corresponds to.
     */
    public final String featureName() {
        return featureName;
    }

    /**
     * <p>
     * The value in string format associated with a feature. Used when your <code>CollectionType</code> is
     * <code>None</code>. Note that features types can be <code>String</code>, <code>Integral</code>, or
     * <code>Fractional</code>. This value represents all three types as a string.
     * </p>
     * 
     * @return The value in string format associated with a feature. Used when your <code>CollectionType</code> is
     *         <code>None</code>. Note that features types can be <code>String</code>, <code>Integral</code>, or
     *         <code>Fractional</code>. This value represents all three types as a string.
     */
    public final String valueAsString() {
        return valueAsString;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValueAsStringList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValueAsStringList() {
        return valueAsStringList != null && !(valueAsStringList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of values in string format associated with a feature. Used when your <code>CollectionType</code> is a
     * <code>List</code>, <code>Set</code>, or <code>Vector</code>. Note that features types can be <code>String</code>,
     * <code>Integral</code>, or <code>Fractional</code>. These values represents all three types as a string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValueAsStringList} method.
     * </p>
     * 
     * @return The list of values in string format associated with a feature. Used when your <code>CollectionType</code>
     *         is a <code>List</code>, <code>Set</code>, or <code>Vector</code>. Note that features types can be
     *         <code>String</code>, <code>Integral</code>, or <code>Fractional</code>. These values represents all three
     *         types as a string.
     */
    public final List<String> valueAsStringList() {
        return valueAsStringList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureName());
        hashCode = 31 * hashCode + Objects.hashCode(valueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValueAsStringList() ? valueAsStringList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureValue)) {
            return false;
        }
        FeatureValue other = (FeatureValue) obj;
        return Objects.equals(featureName(), other.featureName()) && Objects.equals(valueAsString(), other.valueAsString())
                && hasValueAsStringList() == other.hasValueAsStringList()
                && Objects.equals(valueAsStringList(), other.valueAsStringList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FeatureValue").add("FeatureName", featureName()).add("ValueAsString", valueAsString())
                .add("ValueAsStringList", hasValueAsStringList() ? valueAsStringList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureName":
            return Optional.ofNullable(clazz.cast(featureName()));
        case "ValueAsString":
            return Optional.ofNullable(clazz.cast(valueAsString()));
        case "ValueAsStringList":
            return Optional.ofNullable(clazz.cast(valueAsStringList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FeatureValue, T> g) {
        return obj -> g.apply((FeatureValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FeatureValue> {
        /**
         * <p>
         * The name of a feature that a feature value corresponds to.
         * </p>
         * 
         * @param featureName
         *        The name of a feature that a feature value corresponds to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureName(String featureName);

        /**
         * <p>
         * The value in string format associated with a feature. Used when your <code>CollectionType</code> is
         * <code>None</code>. Note that features types can be <code>String</code>, <code>Integral</code>, or
         * <code>Fractional</code>. This value represents all three types as a string.
         * </p>
         * 
         * @param valueAsString
         *        The value in string format associated with a feature. Used when your <code>CollectionType</code> is
         *        <code>None</code>. Note that features types can be <code>String</code>, <code>Integral</code>, or
         *        <code>Fractional</code>. This value represents all three types as a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueAsString(String valueAsString);

        /**
         * <p>
         * The list of values in string format associated with a feature. Used when your <code>CollectionType</code> is
         * a <code>List</code>, <code>Set</code>, or <code>Vector</code>. Note that features types can be
         * <code>String</code>, <code>Integral</code>, or <code>Fractional</code>. These values represents all three
         * types as a string.
         * </p>
         * 
         * @param valueAsStringList
         *        The list of values in string format associated with a feature. Used when your
         *        <code>CollectionType</code> is a <code>List</code>, <code>Set</code>, or <code>Vector</code>. Note
         *        that features types can be <code>String</code>, <code>Integral</code>, or <code>Fractional</code>.
         *        These values represents all three types as a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueAsStringList(Collection<String> valueAsStringList);

        /**
         * <p>
         * The list of values in string format associated with a feature. Used when your <code>CollectionType</code> is
         * a <code>List</code>, <code>Set</code>, or <code>Vector</code>. Note that features types can be
         * <code>String</code>, <code>Integral</code>, or <code>Fractional</code>. These values represents all three
         * types as a string.
         * </p>
         * 
         * @param valueAsStringList
         *        The list of values in string format associated with a feature. Used when your
         *        <code>CollectionType</code> is a <code>List</code>, <code>Set</code>, or <code>Vector</code>. Note
         *        that features types can be <code>String</code>, <code>Integral</code>, or <code>Fractional</code>.
         *        These values represents all three types as a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueAsStringList(String... valueAsStringList);
    }

    static final class BuilderImpl implements Builder {
        private String featureName;

        private String valueAsString;

        private List<String> valueAsStringList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FeatureValue model) {
            featureName(model.featureName);
            valueAsString(model.valueAsString);
            valueAsStringList(model.valueAsStringList);
        }

        public final String getFeatureName() {
            return featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final String getValueAsString() {
            return valueAsString;
        }

        public final void setValueAsString(String valueAsString) {
            this.valueAsString = valueAsString;
        }

        @Override
        public final Builder valueAsString(String valueAsString) {
            this.valueAsString = valueAsString;
            return this;
        }

        public final Collection<String> getValueAsStringList() {
            if (valueAsStringList instanceof SdkAutoConstructList) {
                return null;
            }
            return valueAsStringList;
        }

        public final void setValueAsStringList(Collection<String> valueAsStringList) {
            this.valueAsStringList = ValueAsStringListCopier.copy(valueAsStringList);
        }

        @Override
        public final Builder valueAsStringList(Collection<String> valueAsStringList) {
            this.valueAsStringList = ValueAsStringListCopier.copy(valueAsStringList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueAsStringList(String... valueAsStringList) {
            valueAsStringList(Arrays.asList(valueAsStringList));
            return this;
        }

        @Override
        public FeatureValue build() {
            return new FeatureValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
