/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetRecordRequest extends SageMakerFeatureStoreRuntimeRequest implements
        ToCopyableBuilder<BatchGetRecordRequest.Builder, BatchGetRecordRequest> {
    private static final SdkField<List<BatchGetRecordIdentifier>> IDENTIFIERS_FIELD = SdkField
            .<List<BatchGetRecordIdentifier>> builder(MarshallingType.LIST)
            .memberName("Identifiers")
            .getter(getter(BatchGetRecordRequest::identifiers))
            .setter(setter(Builder::identifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetRecordIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetRecordIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXPIRATION_TIME_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpirationTimeResponse").getter(getter(BatchGetRecordRequest::expirationTimeResponseAsString))
            .setter(setter(Builder::expirationTimeResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTimeResponse").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIERS_FIELD,
            EXPIRATION_TIME_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchGetRecordIdentifier> identifiers;

    private final String expirationTimeResponse;

    private BatchGetRecordRequest(BuilderImpl builder) {
        super(builder);
        this.identifiers = builder.identifiers;
        this.expirationTimeResponse = builder.expirationTimeResponse;
    }

    /**
     * For responses, this returns true if the service returned a value for the Identifiers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIdentifiers() {
        return identifiers != null && !(identifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing the name or Amazon Resource Name (ARN) of the <code>FeatureGroup</code>, the list of names of
     * <code>Feature</code>s to be retrieved, and the corresponding <code>RecordIdentifier</code> values as strings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentifiers} method.
     * </p>
     * 
     * @return A list containing the name or Amazon Resource Name (ARN) of the <code>FeatureGroup</code>, the list of
     *         names of <code>Feature</code>s to be retrieved, and the corresponding <code>RecordIdentifier</code>
     *         values as strings.
     */
    public final List<BatchGetRecordIdentifier> identifiers() {
        return identifiers;
    }

    /**
     * <p>
     * Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>, <code>BatchGetRecord</code>
     * will return the value of <code>ExpiresAt</code>, if it is not null. If <code>Disabled</code> and null,
     * <code>BatchGetRecord</code> will return null.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expirationTimeResponse} will return {@link ExpirationTimeResponse#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #expirationTimeResponseAsString}.
     * </p>
     * 
     * @return Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>,
     *         <code>BatchGetRecord</code> will return the value of <code>ExpiresAt</code>, if it is not null. If
     *         <code>Disabled</code> and null, <code>BatchGetRecord</code> will return null.
     * @see ExpirationTimeResponse
     */
    public final ExpirationTimeResponse expirationTimeResponse() {
        return ExpirationTimeResponse.fromValue(expirationTimeResponse);
    }

    /**
     * <p>
     * Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>, <code>BatchGetRecord</code>
     * will return the value of <code>ExpiresAt</code>, if it is not null. If <code>Disabled</code> and null,
     * <code>BatchGetRecord</code> will return null.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expirationTimeResponse} will return {@link ExpirationTimeResponse#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #expirationTimeResponseAsString}.
     * </p>
     * 
     * @return Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>,
     *         <code>BatchGetRecord</code> will return the value of <code>ExpiresAt</code>, if it is not null. If
     *         <code>Disabled</code> and null, <code>BatchGetRecord</code> will return null.
     * @see ExpirationTimeResponse
     */
    public final String expirationTimeResponseAsString() {
        return expirationTimeResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentifiers() ? identifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(expirationTimeResponseAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRecordRequest)) {
            return false;
        }
        BatchGetRecordRequest other = (BatchGetRecordRequest) obj;
        return hasIdentifiers() == other.hasIdentifiers() && Objects.equals(identifiers(), other.identifiers())
                && Objects.equals(expirationTimeResponseAsString(), other.expirationTimeResponseAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetRecordRequest").add("Identifiers", hasIdentifiers() ? identifiers() : null)
                .add("ExpirationTimeResponse", expirationTimeResponseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifiers":
            return Optional.ofNullable(clazz.cast(identifiers()));
        case "ExpirationTimeResponse":
            return Optional.ofNullable(clazz.cast(expirationTimeResponseAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifiers", IDENTIFIERS_FIELD);
        map.put("ExpirationTimeResponse", EXPIRATION_TIME_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRecordRequest, T> g) {
        return obj -> g.apply((BatchGetRecordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerFeatureStoreRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetRecordRequest> {
        /**
         * <p>
         * A list containing the name or Amazon Resource Name (ARN) of the <code>FeatureGroup</code>, the list of names
         * of <code>Feature</code>s to be retrieved, and the corresponding <code>RecordIdentifier</code> values as
         * strings.
         * </p>
         * 
         * @param identifiers
         *        A list containing the name or Amazon Resource Name (ARN) of the <code>FeatureGroup</code>, the list of
         *        names of <code>Feature</code>s to be retrieved, and the corresponding <code>RecordIdentifier</code>
         *        values as strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifiers(Collection<BatchGetRecordIdentifier> identifiers);

        /**
         * <p>
         * A list containing the name or Amazon Resource Name (ARN) of the <code>FeatureGroup</code>, the list of names
         * of <code>Feature</code>s to be retrieved, and the corresponding <code>RecordIdentifier</code> values as
         * strings.
         * </p>
         * 
         * @param identifiers
         *        A list containing the name or Amazon Resource Name (ARN) of the <code>FeatureGroup</code>, the list of
         *        names of <code>Feature</code>s to be retrieved, and the corresponding <code>RecordIdentifier</code>
         *        values as strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifiers(BatchGetRecordIdentifier... identifiers);

        /**
         * <p>
         * A list containing the name or Amazon Resource Name (ARN) of the <code>FeatureGroup</code>, the list of names
         * of <code>Feature</code>s to be retrieved, and the corresponding <code>RecordIdentifier</code> values as
         * strings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.Builder#build()}
         * is called immediately and its result is passed to {@link #identifiers(List<BatchGetRecordIdentifier>)}.
         * 
         * @param identifiers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identifiers(java.util.Collection<BatchGetRecordIdentifier>)
         */
        Builder identifiers(Consumer<BatchGetRecordIdentifier.Builder>... identifiers);

        /**
         * <p>
         * Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>, <code>BatchGetRecord</code>
         * will return the value of <code>ExpiresAt</code>, if it is not null. If <code>Disabled</code> and null,
         * <code>BatchGetRecord</code> will return null.
         * </p>
         * 
         * @param expirationTimeResponse
         *        Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>,
         *        <code>BatchGetRecord</code> will return the value of <code>ExpiresAt</code>, if it is not null. If
         *        <code>Disabled</code> and null, <code>BatchGetRecord</code> will return null.
         * @see ExpirationTimeResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationTimeResponse
         */
        Builder expirationTimeResponse(String expirationTimeResponse);

        /**
         * <p>
         * Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>, <code>BatchGetRecord</code>
         * will return the value of <code>ExpiresAt</code>, if it is not null. If <code>Disabled</code> and null,
         * <code>BatchGetRecord</code> will return null.
         * </p>
         * 
         * @param expirationTimeResponse
         *        Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>,
         *        <code>BatchGetRecord</code> will return the value of <code>ExpiresAt</code>, if it is not null. If
         *        <code>Disabled</code> and null, <code>BatchGetRecord</code> will return null.
         * @see ExpirationTimeResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationTimeResponse
         */
        Builder expirationTimeResponse(ExpirationTimeResponse expirationTimeResponse);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerFeatureStoreRuntimeRequest.BuilderImpl implements Builder {
        private List<BatchGetRecordIdentifier> identifiers = DefaultSdkAutoConstructList.getInstance();

        private String expirationTimeResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRecordRequest model) {
            super(model);
            identifiers(model.identifiers);
            expirationTimeResponse(model.expirationTimeResponse);
        }

        public final List<BatchGetRecordIdentifier.Builder> getIdentifiers() {
            List<BatchGetRecordIdentifier.Builder> result = BatchGetRecordIdentifiersCopier.copyToBuilder(this.identifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentifiers(Collection<BatchGetRecordIdentifier.BuilderImpl> identifiers) {
            this.identifiers = BatchGetRecordIdentifiersCopier.copyFromBuilder(identifiers);
        }

        @Override
        public final Builder identifiers(Collection<BatchGetRecordIdentifier> identifiers) {
            this.identifiers = BatchGetRecordIdentifiersCopier.copy(identifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(BatchGetRecordIdentifier... identifiers) {
            identifiers(Arrays.asList(identifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(Consumer<BatchGetRecordIdentifier.Builder>... identifiers) {
            identifiers(Stream.of(identifiers).map(c -> BatchGetRecordIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getExpirationTimeResponse() {
            return expirationTimeResponse;
        }

        public final void setExpirationTimeResponse(String expirationTimeResponse) {
            this.expirationTimeResponse = expirationTimeResponse;
        }

        @Override
        public final Builder expirationTimeResponse(String expirationTimeResponse) {
            this.expirationTimeResponse = expirationTimeResponse;
            return this;
        }

        @Override
        public final Builder expirationTimeResponse(ExpirationTimeResponse expirationTimeResponse) {
            this.expirationTimeResponse(expirationTimeResponse == null ? null : expirationTimeResponse.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetRecordRequest build() {
            return new BatchGetRecordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
