/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordResponse;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordResponse;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordResponse;

/**
 * Service client for accessing Amazon SageMaker Feature Store Runtime asynchronously. This can be created using the
 * static {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Contains all data plane API operations and data types for the Amazon SageMaker Feature Store. Use this API to put,
 * delete, and retrieve (get) features from a feature store.
 * </p>
 * <p>
 * Use the following operations to configure your <code>OnlineStore</code> and <code>OfflineStore</code> features, and
 * to create and manage feature groups:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateFeatureGroup.html">CreateFeatureGroup</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteFeatureGroup.html">DeleteFeatureGroup</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeFeatureGroup.html">DescribeFeatureGroup
 * </a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListFeatureGroups.html">ListFeatureGroups</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SageMakerFeatureStoreRuntimeAsyncClient extends AwsClient {
    String SERVICE_NAME = "sagemaker";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "featurestore-runtime.sagemaker";

    /**
     * <p>
     * Retrieves a batch of <code>Records</code> from a <code>FeatureGroup</code>.
     * </p>
     *
     * @param batchGetRecordRequest
     * @return A Java Future containing the result of the BatchGetRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact Amazon Web Services customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.BatchGetRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/BatchGetRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetRecordResponse> batchGetRecord(BatchGetRecordRequest batchGetRecordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a batch of <code>Records</code> from a <code>FeatureGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetRecordRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetRecordRequest#builder()}
     * </p>
     *
     * @param batchGetRecordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchGetRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact Amazon Web Services customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.BatchGetRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/BatchGetRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetRecordResponse> batchGetRecord(Consumer<BatchGetRecordRequest.Builder> batchGetRecordRequest) {
        return batchGetRecord(BatchGetRecordRequest.builder().applyMutation(batchGetRecordRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>Record</code> from a <code>FeatureGroup</code> in the <code>OnlineStore</code>. Feature Store
     * supports both <code>SoftDelete</code> and <code>HardDelete</code>. For <code>SoftDelete</code> (default), feature
     * columns are set to <code>null</code> and the record is no longer retrievable by <code>GetRecord</code> or
     * <code>BatchGetRecord</code>. For <code>HardDelete</code>, the complete <code>Record</code> is removed from the
     * <code>OnlineStore</code>. In both cases, Feature Store appends the deleted record marker to the
     * <code>OfflineStore</code>. The deleted record marker is a record with the same <code>RecordIdentifer</code> as
     * the original, but with <code>is_deleted</code> value set to <code>True</code>, <code>EventTime</code> set to the
     * delete input <code>EventTime</code>, and other feature values set to <code>null</code>.
     * </p>
     * <p>
     * Note that the <code>EventTime</code> specified in <code>DeleteRecord</code> should be set later than the
     * <code>EventTime</code> of the existing record in the <code>OnlineStore</code> for that
     * <code>RecordIdentifer</code>. If it is not, the deletion does not occur:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>SoftDelete</code>, the existing (not deleted) record remains in the <code>OnlineStore</code>, though
     * the delete record marker is still written to the <code>OfflineStore</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HardDelete</code> returns <code>EventTime</code>: <code>400 ValidationException</code> to indicate that the
     * delete operation failed. No delete record marker is written to the <code>OfflineStore</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When a record is deleted from the <code>OnlineStore</code>, the deleted record marker is appended to the
     * <code>OfflineStore</code>. If you have the Iceberg table format enabled for your <code>OfflineStore</code>, you
     * can remove all history of a record from the <code>OfflineStore</code> using Amazon Athena or Apache Spark. For
     * information on how to hard delete a record from the <code>OfflineStore</code> with the Iceberg table format
     * enabled, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-delete-records-offline-store.html#feature-store-delete-records-offline-store"
     * >Delete records from the offline store</a>.
     * </p>
     *
     * @param deleteRecordRequest
     * @return A Java Future containing the result of the DeleteRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact Amazon Web Services customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.DeleteRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/DeleteRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRecordResponse> deleteRecord(DeleteRecordRequest deleteRecordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>Record</code> from a <code>FeatureGroup</code> in the <code>OnlineStore</code>. Feature Store
     * supports both <code>SoftDelete</code> and <code>HardDelete</code>. For <code>SoftDelete</code> (default), feature
     * columns are set to <code>null</code> and the record is no longer retrievable by <code>GetRecord</code> or
     * <code>BatchGetRecord</code>. For <code>HardDelete</code>, the complete <code>Record</code> is removed from the
     * <code>OnlineStore</code>. In both cases, Feature Store appends the deleted record marker to the
     * <code>OfflineStore</code>. The deleted record marker is a record with the same <code>RecordIdentifer</code> as
     * the original, but with <code>is_deleted</code> value set to <code>True</code>, <code>EventTime</code> set to the
     * delete input <code>EventTime</code>, and other feature values set to <code>null</code>.
     * </p>
     * <p>
     * Note that the <code>EventTime</code> specified in <code>DeleteRecord</code> should be set later than the
     * <code>EventTime</code> of the existing record in the <code>OnlineStore</code> for that
     * <code>RecordIdentifer</code>. If it is not, the deletion does not occur:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>SoftDelete</code>, the existing (not deleted) record remains in the <code>OnlineStore</code>, though
     * the delete record marker is still written to the <code>OfflineStore</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HardDelete</code> returns <code>EventTime</code>: <code>400 ValidationException</code> to indicate that the
     * delete operation failed. No delete record marker is written to the <code>OfflineStore</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When a record is deleted from the <code>OnlineStore</code>, the deleted record marker is appended to the
     * <code>OfflineStore</code>. If you have the Iceberg table format enabled for your <code>OfflineStore</code>, you
     * can remove all history of a record from the <code>OfflineStore</code> using Amazon Athena or Apache Spark. For
     * information on how to hard delete a record from the <code>OfflineStore</code> with the Iceberg table format
     * enabled, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-delete-records-offline-store.html#feature-store-delete-records-offline-store"
     * >Delete records from the offline store</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecordRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRecordRequest#builder()}
     * </p>
     *
     * @param deleteRecordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact Amazon Web Services customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.DeleteRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/DeleteRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRecordResponse> deleteRecord(Consumer<DeleteRecordRequest.Builder> deleteRecordRequest) {
        return deleteRecord(DeleteRecordRequest.builder().applyMutation(deleteRecordRequest).build());
    }

    /**
     * <p>
     * Use for <code>OnlineStore</code> serving from a <code>FeatureStore</code>. Only the latest records stored in the
     * <code>OnlineStore</code> can be retrieved. If no Record with <code>RecordIdentifierValue</code> is found, then an
     * empty result is returned.
     * </p>
     *
     * @param getRecordRequest
     * @return A Java Future containing the result of the GetRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>ResourceNotFoundException A resource that is required to perform an action was not found.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact Amazon Web Services customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.GetRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/GetRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecordResponse> getRecord(GetRecordRequest getRecordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use for <code>OnlineStore</code> serving from a <code>FeatureStore</code>. Only the latest records stored in the
     * <code>OnlineStore</code> can be retrieved. If no Record with <code>RecordIdentifierValue</code> is found, then an
     * empty result is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecordRequest.Builder} avoiding the need to
     * create one manually via {@link GetRecordRequest#builder()}
     * </p>
     *
     * @param getRecordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>ResourceNotFoundException A resource that is required to perform an action was not found.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact Amazon Web Services customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.GetRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/GetRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecordResponse> getRecord(Consumer<GetRecordRequest.Builder> getRecordRequest) {
        return getRecord(GetRecordRequest.builder().applyMutation(getRecordRequest).build());
    }

    /**
     * <p>
     * The <code>PutRecord</code> API is used to ingest a list of <code>Records</code> into your feature group.
     * </p>
     * <p>
     * If a new record’s <code>EventTime</code> is greater, the new record is written to both the
     * <code>OnlineStore</code> and <code>OfflineStore</code>. Otherwise, the record is a historic record and it is
     * written only to the <code>OfflineStore</code>.
     * </p>
     * <p>
     * You can specify the ingestion to be applied to the <code>OnlineStore</code>, <code>OfflineStore</code>, or both
     * by using the <code>TargetStores</code> request parameter.
     * </p>
     * <p>
     * You can set the ingested record to expire at a given time to live (TTL) duration after the record’s event time,
     * <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code>, by specifying the
     * <code>TtlDuration</code> parameter. A record level <code>TtlDuration</code> is set when specifying the
     * <code>TtlDuration</code> parameter using the <code>PutRecord</code> API call. If the input
     * <code>TtlDuration</code> is <code>null</code> or unspecified, <code>TtlDuration</code> is set to the default
     * feature group level <code>TtlDuration</code>. A record level <code>TtlDuration</code> supersedes the group level
     * <code>TtlDuration</code>.
     * </p>
     *
     * @param putRecordRequest
     * @return A Java Future containing the result of the PutRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact Amazon Web Services customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.PutRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/PutRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRecordResponse> putRecord(PutRecordRequest putRecordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>PutRecord</code> API is used to ingest a list of <code>Records</code> into your feature group.
     * </p>
     * <p>
     * If a new record’s <code>EventTime</code> is greater, the new record is written to both the
     * <code>OnlineStore</code> and <code>OfflineStore</code>. Otherwise, the record is a historic record and it is
     * written only to the <code>OfflineStore</code>.
     * </p>
     * <p>
     * You can specify the ingestion to be applied to the <code>OnlineStore</code>, <code>OfflineStore</code>, or both
     * by using the <code>TargetStores</code> request parameter.
     * </p>
     * <p>
     * You can set the ingested record to expire at a given time to live (TTL) duration after the record’s event time,
     * <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code>, by specifying the
     * <code>TtlDuration</code> parameter. A record level <code>TtlDuration</code> is set when specifying the
     * <code>TtlDuration</code> parameter using the <code>PutRecord</code> API call. If the input
     * <code>TtlDuration</code> is <code>null</code> or unspecified, <code>TtlDuration</code> is set to the default
     * feature group level <code>TtlDuration</code>. A record level <code>TtlDuration</code> supersedes the group level
     * <code>TtlDuration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRecordRequest.Builder} avoiding the need to
     * create one manually via {@link PutRecordRequest#builder()}
     * </p>
     *
     * @param putRecordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact Amazon Web Services customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.PutRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/PutRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRecordResponse> putRecord(Consumer<PutRecordRequest.Builder> putRecordRequest) {
        return putRecord(PutRecordRequest.builder().applyMutation(putRecordRequest).build());
    }

    @Override
    default SageMakerFeatureStoreRuntimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SageMakerFeatureStoreRuntimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SageMakerFeatureStoreRuntimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SageMakerFeatureStoreRuntimeAsyncClient}.
     */
    static SageMakerFeatureStoreRuntimeAsyncClientBuilder builder() {
        return new DefaultSageMakerFeatureStoreRuntimeAsyncClientBuilder();
    }
}
