/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of records that have been retrieved in a batch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetRecordResultDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetRecordResultDetail.Builder, BatchGetRecordResultDetail> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(BatchGetRecordResultDetail::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()).build();

    private static final SdkField<String> RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecordIdentifierValueAsString")
            .getter(getter(BatchGetRecordResultDetail::recordIdentifierValueAsString))
            .setter(setter(Builder::recordIdentifierValueAsString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIdentifierValueAsString")
                    .build()).build();

    private static final SdkField<List<FeatureValue>> RECORD_FIELD = SdkField
            .<List<FeatureValue>> builder(MarshallingType.LIST)
            .memberName("Record")
            .getter(getter(BatchGetRecordResultDetail::record))
            .setter(setter(Builder::record))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Record").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeatureValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeatureValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXPIRES_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpiresAt").getter(getter(BatchGetRecordResultDetail::expiresAt)).setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD,
            RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD, RECORD_FIELD, EXPIRES_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String featureGroupName;

    private final String recordIdentifierValueAsString;

    private final List<FeatureValue> record;

    private final String expiresAt;

    private BatchGetRecordResultDetail(BuilderImpl builder) {
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifierValueAsString = builder.recordIdentifierValueAsString;
        this.record = builder.record;
        this.expiresAt = builder.expiresAt;
    }

    /**
     * <p>
     * The <code>FeatureGroupName</code> containing Records you retrieved in a batch.
     * </p>
     * 
     * @return The <code>FeatureGroupName</code> containing Records you retrieved in a batch.
     */
    public final String featureGroupName() {
        return featureGroupName;
    }

    /**
     * <p>
     * The value of the record identifier in string format.
     * </p>
     * 
     * @return The value of the record identifier in string format.
     */
    public final String recordIdentifierValueAsString() {
        return recordIdentifierValueAsString;
    }

    /**
     * For responses, this returns true if the service returned a value for the Record property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecord() {
        return record != null && !(record instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>Record</code> retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecord} method.
     * </p>
     * 
     * @return The <code>Record</code> retrieved.
     */
    public final List<FeatureValue> record() {
        return record;
    }

    /**
     * <p>
     * The <code>ExpiresAt</code> ISO string of the requested record.
     * </p>
     * 
     * @return The <code>ExpiresAt</code> ISO string of the requested record.
     */
    public final String expiresAt() {
        return expiresAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(recordIdentifierValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecord() ? record() : null);
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRecordResultDetail)) {
            return false;
        }
        BatchGetRecordResultDetail other = (BatchGetRecordResultDetail) obj;
        return Objects.equals(featureGroupName(), other.featureGroupName())
                && Objects.equals(recordIdentifierValueAsString(), other.recordIdentifierValueAsString())
                && hasRecord() == other.hasRecord() && Objects.equals(record(), other.record())
                && Objects.equals(expiresAt(), other.expiresAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetRecordResultDetail").add("FeatureGroupName", featureGroupName())
                .add("RecordIdentifierValueAsString", recordIdentifierValueAsString())
                .add("Record", hasRecord() ? record() : null).add("ExpiresAt", expiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "RecordIdentifierValueAsString":
            return Optional.ofNullable(clazz.cast(recordIdentifierValueAsString()));
        case "Record":
            return Optional.ofNullable(clazz.cast(record()));
        case "ExpiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FeatureGroupName", FEATURE_GROUP_NAME_FIELD);
        map.put("RecordIdentifierValueAsString", RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD);
        map.put("Record", RECORD_FIELD);
        map.put("ExpiresAt", EXPIRES_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRecordResultDetail, T> g) {
        return obj -> g.apply((BatchGetRecordResultDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetRecordResultDetail> {
        /**
         * <p>
         * The <code>FeatureGroupName</code> containing Records you retrieved in a batch.
         * </p>
         * 
         * @param featureGroupName
         *        The <code>FeatureGroupName</code> containing Records you retrieved in a batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * The value of the record identifier in string format.
         * </p>
         * 
         * @param recordIdentifierValueAsString
         *        The value of the record identifier in string format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordIdentifierValueAsString(String recordIdentifierValueAsString);

        /**
         * <p>
         * The <code>Record</code> retrieved.
         * </p>
         * 
         * @param record
         *        The <code>Record</code> retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(Collection<FeatureValue> record);

        /**
         * <p>
         * The <code>Record</code> retrieved.
         * </p>
         * 
         * @param record
         *        The <code>Record</code> retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(FeatureValue... record);

        /**
         * <p>
         * The <code>Record</code> retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue.Builder#build()} is
         * called immediately and its result is passed to {@link #record(List<FeatureValue>)}.
         * 
         * @param record
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #record(java.util.Collection<FeatureValue>)
         */
        Builder record(Consumer<FeatureValue.Builder>... record);

        /**
         * <p>
         * The <code>ExpiresAt</code> ISO string of the requested record.
         * </p>
         * 
         * @param expiresAt
         *        The <code>ExpiresAt</code> ISO string of the requested record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(String expiresAt);
    }

    static final class BuilderImpl implements Builder {
        private String featureGroupName;

        private String recordIdentifierValueAsString;

        private List<FeatureValue> record = DefaultSdkAutoConstructList.getInstance();

        private String expiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRecordResultDetail model) {
            featureGroupName(model.featureGroupName);
            recordIdentifierValueAsString(model.recordIdentifierValueAsString);
            record(model.record);
            expiresAt(model.expiresAt);
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getRecordIdentifierValueAsString() {
            return recordIdentifierValueAsString;
        }

        public final void setRecordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
        }

        @Override
        public final Builder recordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
            return this;
        }

        public final List<FeatureValue.Builder> getRecord() {
            List<FeatureValue.Builder> result = RecordCopier.copyToBuilder(this.record);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecord(Collection<FeatureValue.BuilderImpl> record) {
            this.record = RecordCopier.copyFromBuilder(record);
        }

        @Override
        public final Builder record(Collection<FeatureValue> record) {
            this.record = RecordCopier.copy(record);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder record(FeatureValue... record) {
            record(Arrays.asList(record));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder record(Consumer<FeatureValue.Builder>... record) {
            record(Stream.of(record).map(c -> FeatureValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(String expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(String expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public BatchGetRecordResultDetail build() {
            return new BatchGetRecordResultDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
