/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.sagemakergeospatial.model.DeleteEarthObservationJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.DeleteEarthObservationJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetTileRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetTileResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.StopEarthObservationJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.StopEarthObservationJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.StopVectorEnrichmentJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.StopVectorEnrichmentJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.TagResourceRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.TagResourceResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.UntagResourceRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.UntagResourceResponse;
import software.amazon.awssdk.services.sagemakergeospatial.paginators.ListEarthObservationJobsPublisher;
import software.amazon.awssdk.services.sagemakergeospatial.paginators.ListRasterDataCollectionsPublisher;
import software.amazon.awssdk.services.sagemakergeospatial.paginators.ListVectorEnrichmentJobsPublisher;
import software.amazon.awssdk.services.sagemakergeospatial.paginators.SearchRasterDataCollectionPublisher;

/**
 * Service client for accessing Amazon SageMaker geospatial capabilities asynchronously. This can be created using the
 * static {@link #builder()} method.
 *
 * <p>
 * Provides APIs for creating and managing SageMaker geospatial resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SageMakerGeospatialAsyncClient extends AwsClient {
    String SERVICE_NAME = "sagemaker-geospatial";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "sagemaker-geospatial";

    /**
     * <p>
     * Use this operation to delete an Earth Observation job.
     * </p>
     *
     * @param deleteEarthObservationJobRequest
     * @return A Java Future containing the result of the DeleteEarthObservationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.DeleteEarthObservationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/DeleteEarthObservationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEarthObservationJobResponse> deleteEarthObservationJob(
            DeleteEarthObservationJobRequest deleteEarthObservationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to delete an Earth Observation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEarthObservationJobRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEarthObservationJobRequest#builder()}
     * </p>
     *
     * @param deleteEarthObservationJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEarthObservationJobInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEarthObservationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.DeleteEarthObservationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/DeleteEarthObservationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEarthObservationJobResponse> deleteEarthObservationJob(
            Consumer<DeleteEarthObservationJobRequest.Builder> deleteEarthObservationJobRequest) {
        return deleteEarthObservationJob(DeleteEarthObservationJobRequest.builder()
                .applyMutation(deleteEarthObservationJobRequest).build());
    }

    /**
     * <p>
     * Use this operation to delete a Vector Enrichment job.
     * </p>
     *
     * @param deleteVectorEnrichmentJobRequest
     * @return A Java Future containing the result of the DeleteVectorEnrichmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.DeleteVectorEnrichmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/DeleteVectorEnrichmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVectorEnrichmentJobResponse> deleteVectorEnrichmentJob(
            DeleteVectorEnrichmentJobRequest deleteVectorEnrichmentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to delete a Vector Enrichment job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVectorEnrichmentJobRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVectorEnrichmentJobRequest#builder()}
     * </p>
     *
     * @param deleteVectorEnrichmentJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVectorEnrichmentJobInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVectorEnrichmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.DeleteVectorEnrichmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/DeleteVectorEnrichmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVectorEnrichmentJobResponse> deleteVectorEnrichmentJob(
            Consumer<DeleteVectorEnrichmentJobRequest.Builder> deleteVectorEnrichmentJobRequest) {
        return deleteVectorEnrichmentJob(DeleteVectorEnrichmentJobRequest.builder()
                .applyMutation(deleteVectorEnrichmentJobRequest).build());
    }

    /**
     * <p>
     * Use this operation to export results of an Earth Observation job and optionally source images used as input to
     * the EOJ to an S3 location.
     * </p>
     *
     * @param exportEarthObservationJobRequest
     * @return A Java Future containing the result of the ExportEarthObservationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ExportEarthObservationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ExportEarthObservationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportEarthObservationJobResponse> exportEarthObservationJob(
            ExportEarthObservationJobRequest exportEarthObservationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to export results of an Earth Observation job and optionally source images used as input to
     * the EOJ to an S3 location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportEarthObservationJobRequest.Builder} avoiding
     * the need to create one manually via {@link ExportEarthObservationJobRequest#builder()}
     * </p>
     *
     * @param exportEarthObservationJobRequest
     *        A {@link Consumer} that will call methods on {@link ExportEarthObservationJobInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExportEarthObservationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ExportEarthObservationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ExportEarthObservationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportEarthObservationJobResponse> exportEarthObservationJob(
            Consumer<ExportEarthObservationJobRequest.Builder> exportEarthObservationJobRequest) {
        return exportEarthObservationJob(ExportEarthObservationJobRequest.builder()
                .applyMutation(exportEarthObservationJobRequest).build());
    }

    /**
     * <p>
     * Use this operation to copy results of a Vector Enrichment job to an S3 location.
     * </p>
     *
     * @param exportVectorEnrichmentJobRequest
     * @return A Java Future containing the result of the ExportVectorEnrichmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ExportVectorEnrichmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ExportVectorEnrichmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportVectorEnrichmentJobResponse> exportVectorEnrichmentJob(
            ExportVectorEnrichmentJobRequest exportVectorEnrichmentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to copy results of a Vector Enrichment job to an S3 location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportVectorEnrichmentJobRequest.Builder} avoiding
     * the need to create one manually via {@link ExportVectorEnrichmentJobRequest#builder()}
     * </p>
     *
     * @param exportVectorEnrichmentJobRequest
     *        A {@link Consumer} that will call methods on {@link ExportVectorEnrichmentJobInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExportVectorEnrichmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ExportVectorEnrichmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ExportVectorEnrichmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportVectorEnrichmentJobResponse> exportVectorEnrichmentJob(
            Consumer<ExportVectorEnrichmentJobRequest.Builder> exportVectorEnrichmentJobRequest) {
        return exportVectorEnrichmentJob(ExportVectorEnrichmentJobRequest.builder()
                .applyMutation(exportVectorEnrichmentJobRequest).build());
    }

    /**
     * <p>
     * Get the details for a previously initiated Earth Observation job.
     * </p>
     *
     * @param getEarthObservationJobRequest
     * @return A Java Future containing the result of the GetEarthObservationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.GetEarthObservationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetEarthObservationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEarthObservationJobResponse> getEarthObservationJob(
            GetEarthObservationJobRequest getEarthObservationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the details for a previously initiated Earth Observation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEarthObservationJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetEarthObservationJobRequest#builder()}
     * </p>
     *
     * @param getEarthObservationJobRequest
     *        A {@link Consumer} that will call methods on {@link GetEarthObservationJobInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEarthObservationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.GetEarthObservationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetEarthObservationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEarthObservationJobResponse> getEarthObservationJob(
            Consumer<GetEarthObservationJobRequest.Builder> getEarthObservationJobRequest) {
        return getEarthObservationJob(GetEarthObservationJobRequest.builder().applyMutation(getEarthObservationJobRequest)
                .build());
    }

    /**
     * <p>
     * Use this operation to get details of a specific raster data collection.
     * </p>
     *
     * @param getRasterDataCollectionRequest
     * @return A Java Future containing the result of the GetRasterDataCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.GetRasterDataCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetRasterDataCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRasterDataCollectionResponse> getRasterDataCollection(
            GetRasterDataCollectionRequest getRasterDataCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to get details of a specific raster data collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRasterDataCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link GetRasterDataCollectionRequest#builder()}
     * </p>
     *
     * @param getRasterDataCollectionRequest
     *        A {@link Consumer} that will call methods on {@link GetRasterDataCollectionInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRasterDataCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.GetRasterDataCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetRasterDataCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRasterDataCollectionResponse> getRasterDataCollection(
            Consumer<GetRasterDataCollectionRequest.Builder> getRasterDataCollectionRequest) {
        return getRasterDataCollection(GetRasterDataCollectionRequest.builder().applyMutation(getRasterDataCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Gets a web mercator tile for the given Earth Observation job.
     * </p>
     *
     * @param getTileRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The output binary file.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.GetTile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetTile" target="_top">AWS
     *      API Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> getTile(GetTileRequest getTileRequest,
            AsyncResponseTransformer<GetTileResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a web mercator tile for the given Earth Observation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTileRequest.Builder} avoiding the need to create
     * one manually via {@link GetTileRequest#builder()}
     * </p>
     *
     * @param getTileRequest
     *        A {@link Consumer} that will call methods on {@link GetTileInput.Builder} to create a request.
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The output binary file.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.GetTile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetTile" target="_top">AWS
     *      API Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> getTile(Consumer<GetTileRequest.Builder> getTileRequest,
            AsyncResponseTransformer<GetTileResponse, ReturnT> asyncResponseTransformer) {
        return getTile(GetTileRequest.builder().applyMutation(getTileRequest).build(), asyncResponseTransformer);
    }

    /**
     * <p>
     * Gets a web mercator tile for the given Earth Observation job.
     * </p>
     *
     * @param getTileRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The output binary file.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.GetTile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetTile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTileResponse> getTile(GetTileRequest getTileRequest, Path destinationPath) {
        return getTile(getTileRequest, AsyncResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * Gets a web mercator tile for the given Earth Observation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTileRequest.Builder} avoiding the need to create
     * one manually via {@link GetTileRequest#builder()}
     * </p>
     *
     * @param getTileRequest
     *        A {@link Consumer} that will call methods on {@link GetTileInput.Builder} to create a request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The output binary file.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.GetTile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetTile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTileResponse> getTile(Consumer<GetTileRequest.Builder> getTileRequest, Path destinationPath) {
        return getTile(GetTileRequest.builder().applyMutation(getTileRequest).build(), destinationPath);
    }

    /**
     * <p>
     * Retrieves details of a Vector Enrichment Job for a given job Amazon Resource Name (ARN).
     * </p>
     *
     * @param getVectorEnrichmentJobRequest
     * @return A Java Future containing the result of the GetVectorEnrichmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.GetVectorEnrichmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetVectorEnrichmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVectorEnrichmentJobResponse> getVectorEnrichmentJob(
            GetVectorEnrichmentJobRequest getVectorEnrichmentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of a Vector Enrichment Job for a given job Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVectorEnrichmentJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetVectorEnrichmentJobRequest#builder()}
     * </p>
     *
     * @param getVectorEnrichmentJobRequest
     *        A {@link Consumer} that will call methods on {@link GetVectorEnrichmentJobInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVectorEnrichmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.GetVectorEnrichmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetVectorEnrichmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVectorEnrichmentJobResponse> getVectorEnrichmentJob(
            Consumer<GetVectorEnrichmentJobRequest.Builder> getVectorEnrichmentJobRequest) {
        return getVectorEnrichmentJob(GetVectorEnrichmentJobRequest.builder().applyMutation(getVectorEnrichmentJobRequest)
                .build());
    }

    /**
     * <p>
     * Use this operation to get a list of the Earth Observation jobs associated with the calling Amazon Web Services
     * account.
     * </p>
     *
     * @param listEarthObservationJobsRequest
     * @return A Java Future containing the result of the ListEarthObservationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListEarthObservationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListEarthObservationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEarthObservationJobsResponse> listEarthObservationJobs(
            ListEarthObservationJobsRequest listEarthObservationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to get a list of the Earth Observation jobs associated with the calling Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEarthObservationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEarthObservationJobsRequest#builder()}
     * </p>
     *
     * @param listEarthObservationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListEarthObservationJobInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEarthObservationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListEarthObservationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListEarthObservationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEarthObservationJobsResponse> listEarthObservationJobs(
            Consumer<ListEarthObservationJobsRequest.Builder> listEarthObservationJobsRequest) {
        return listEarthObservationJobs(ListEarthObservationJobsRequest.builder().applyMutation(listEarthObservationJobsRequest)
                .build());
    }

    /**
     * <p>
     * Use this operation to get a list of the Earth Observation jobs associated with the calling Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEarthObservationJobs(software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.ListEarthObservationJobsPublisher publisher = client.listEarthObservationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.ListEarthObservationJobsPublisher publisher = client.listEarthObservationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEarthObservationJobs(software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEarthObservationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListEarthObservationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListEarthObservationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEarthObservationJobsPublisher listEarthObservationJobsPaginator(
            ListEarthObservationJobsRequest listEarthObservationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to get a list of the Earth Observation jobs associated with the calling Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEarthObservationJobs(software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.ListEarthObservationJobsPublisher publisher = client.listEarthObservationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.ListEarthObservationJobsPublisher publisher = client.listEarthObservationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEarthObservationJobs(software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEarthObservationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEarthObservationJobsRequest#builder()}
     * </p>
     *
     * @param listEarthObservationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListEarthObservationJobInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListEarthObservationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListEarthObservationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEarthObservationJobsPublisher listEarthObservationJobsPaginator(
            Consumer<ListEarthObservationJobsRequest.Builder> listEarthObservationJobsRequest) {
        return listEarthObservationJobsPaginator(ListEarthObservationJobsRequest.builder()
                .applyMutation(listEarthObservationJobsRequest).build());
    }

    /**
     * <p>
     * Use this operation to get raster data collections.
     * </p>
     *
     * @param listRasterDataCollectionsRequest
     * @return A Java Future containing the result of the ListRasterDataCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListRasterDataCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListRasterDataCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRasterDataCollectionsResponse> listRasterDataCollections(
            ListRasterDataCollectionsRequest listRasterDataCollectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to get raster data collections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRasterDataCollectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListRasterDataCollectionsRequest#builder()}
     * </p>
     *
     * @param listRasterDataCollectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListRasterDataCollectionsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRasterDataCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListRasterDataCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListRasterDataCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRasterDataCollectionsResponse> listRasterDataCollections(
            Consumer<ListRasterDataCollectionsRequest.Builder> listRasterDataCollectionsRequest) {
        return listRasterDataCollections(ListRasterDataCollectionsRequest.builder()
                .applyMutation(listRasterDataCollectionsRequest).build());
    }

    /**
     * <p>
     * Use this operation to get raster data collections.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRasterDataCollections(software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.ListRasterDataCollectionsPublisher publisher = client.listRasterDataCollectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.ListRasterDataCollectionsPublisher publisher = client.listRasterDataCollectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRasterDataCollections(software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRasterDataCollectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListRasterDataCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListRasterDataCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRasterDataCollectionsPublisher listRasterDataCollectionsPaginator(
            ListRasterDataCollectionsRequest listRasterDataCollectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to get raster data collections.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRasterDataCollections(software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.ListRasterDataCollectionsPublisher publisher = client.listRasterDataCollectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.ListRasterDataCollectionsPublisher publisher = client.listRasterDataCollectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRasterDataCollections(software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRasterDataCollectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListRasterDataCollectionsRequest#builder()}
     * </p>
     *
     * @param listRasterDataCollectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListRasterDataCollectionsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListRasterDataCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListRasterDataCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRasterDataCollectionsPublisher listRasterDataCollectionsPaginator(
            Consumer<ListRasterDataCollectionsRequest.Builder> listRasterDataCollectionsRequest) {
        return listRasterDataCollectionsPaginator(ListRasterDataCollectionsRequest.builder()
                .applyMutation(listRasterDataCollectionsRequest).build());
    }

    /**
     * <p>
     * Lists the tags attached to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags attached to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of vector enrichment jobs.
     * </p>
     *
     * @param listVectorEnrichmentJobsRequest
     * @return A Java Future containing the result of the ListVectorEnrichmentJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListVectorEnrichmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListVectorEnrichmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVectorEnrichmentJobsResponse> listVectorEnrichmentJobs(
            ListVectorEnrichmentJobsRequest listVectorEnrichmentJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of vector enrichment jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVectorEnrichmentJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListVectorEnrichmentJobsRequest#builder()}
     * </p>
     *
     * @param listVectorEnrichmentJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListVectorEnrichmentJobInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVectorEnrichmentJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListVectorEnrichmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListVectorEnrichmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVectorEnrichmentJobsResponse> listVectorEnrichmentJobs(
            Consumer<ListVectorEnrichmentJobsRequest.Builder> listVectorEnrichmentJobsRequest) {
        return listVectorEnrichmentJobs(ListVectorEnrichmentJobsRequest.builder().applyMutation(listVectorEnrichmentJobsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of vector enrichment jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVectorEnrichmentJobs(software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.ListVectorEnrichmentJobsPublisher publisher = client.listVectorEnrichmentJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.ListVectorEnrichmentJobsPublisher publisher = client.listVectorEnrichmentJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVectorEnrichmentJobs(software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVectorEnrichmentJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListVectorEnrichmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListVectorEnrichmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVectorEnrichmentJobsPublisher listVectorEnrichmentJobsPaginator(
            ListVectorEnrichmentJobsRequest listVectorEnrichmentJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of vector enrichment jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVectorEnrichmentJobs(software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.ListVectorEnrichmentJobsPublisher publisher = client.listVectorEnrichmentJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.ListVectorEnrichmentJobsPublisher publisher = client.listVectorEnrichmentJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVectorEnrichmentJobs(software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVectorEnrichmentJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListVectorEnrichmentJobsRequest#builder()}
     * </p>
     *
     * @param listVectorEnrichmentJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListVectorEnrichmentJobInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.ListVectorEnrichmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListVectorEnrichmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVectorEnrichmentJobsPublisher listVectorEnrichmentJobsPaginator(
            Consumer<ListVectorEnrichmentJobsRequest.Builder> listVectorEnrichmentJobsRequest) {
        return listVectorEnrichmentJobsPaginator(ListVectorEnrichmentJobsRequest.builder()
                .applyMutation(listVectorEnrichmentJobsRequest).build());
    }

    /**
     * <p>
     * Allows you run image query on a specific raster data collection to get a list of the satellite imagery matching
     * the selected filters.
     * </p>
     *
     * @param searchRasterDataCollectionRequest
     * @return A Java Future containing the result of the SearchRasterDataCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.SearchRasterDataCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/SearchRasterDataCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchRasterDataCollectionResponse> searchRasterDataCollection(
            SearchRasterDataCollectionRequest searchRasterDataCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you run image query on a specific raster data collection to get a list of the satellite imagery matching
     * the selected filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRasterDataCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link SearchRasterDataCollectionRequest#builder()}
     * </p>
     *
     * @param searchRasterDataCollectionRequest
     *        A {@link Consumer} that will call methods on {@link SearchRasterDataCollectionInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchRasterDataCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.SearchRasterDataCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/SearchRasterDataCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchRasterDataCollectionResponse> searchRasterDataCollection(
            Consumer<SearchRasterDataCollectionRequest.Builder> searchRasterDataCollectionRequest) {
        return searchRasterDataCollection(SearchRasterDataCollectionRequest.builder()
                .applyMutation(searchRasterDataCollectionRequest).build());
    }

    /**
     * <p>
     * Allows you run image query on a specific raster data collection to get a list of the satellite imagery matching
     * the selected filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchRasterDataCollection(software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.SearchRasterDataCollectionPublisher publisher = client.searchRasterDataCollectionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.SearchRasterDataCollectionPublisher publisher = client.searchRasterDataCollectionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRasterDataCollection(software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchRasterDataCollectionRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.SearchRasterDataCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/SearchRasterDataCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchRasterDataCollectionPublisher searchRasterDataCollectionPaginator(
            SearchRasterDataCollectionRequest searchRasterDataCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you run image query on a specific raster data collection to get a list of the satellite imagery matching
     * the selected filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchRasterDataCollection(software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.SearchRasterDataCollectionPublisher publisher = client.searchRasterDataCollectionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakergeospatial.paginators.SearchRasterDataCollectionPublisher publisher = client.searchRasterDataCollectionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRasterDataCollection(software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRasterDataCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link SearchRasterDataCollectionRequest#builder()}
     * </p>
     *
     * @param searchRasterDataCollectionRequest
     *        A {@link Consumer} that will call methods on {@link SearchRasterDataCollectionInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.SearchRasterDataCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/SearchRasterDataCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchRasterDataCollectionPublisher searchRasterDataCollectionPaginator(
            Consumer<SearchRasterDataCollectionRequest.Builder> searchRasterDataCollectionRequest) {
        return searchRasterDataCollectionPaginator(SearchRasterDataCollectionRequest.builder()
                .applyMutation(searchRasterDataCollectionRequest).build());
    }

    /**
     * <p>
     * Use this operation to create an Earth observation job.
     * </p>
     *
     * @param startEarthObservationJobRequest
     * @return A Java Future containing the result of the StartEarthObservationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.StartEarthObservationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StartEarthObservationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartEarthObservationJobResponse> startEarthObservationJob(
            StartEarthObservationJobRequest startEarthObservationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to create an Earth observation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartEarthObservationJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartEarthObservationJobRequest#builder()}
     * </p>
     *
     * @param startEarthObservationJobRequest
     *        A {@link Consumer} that will call methods on {@link StartEarthObservationJobInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartEarthObservationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.StartEarthObservationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StartEarthObservationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartEarthObservationJobResponse> startEarthObservationJob(
            Consumer<StartEarthObservationJobRequest.Builder> startEarthObservationJobRequest) {
        return startEarthObservationJob(StartEarthObservationJobRequest.builder().applyMutation(startEarthObservationJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Vector Enrichment job for the supplied job type. Currently, there are two supported job types: reverse
     * geocoding and map matching.
     * </p>
     *
     * @param startVectorEnrichmentJobRequest
     * @return A Java Future containing the result of the StartVectorEnrichmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.StartVectorEnrichmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StartVectorEnrichmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartVectorEnrichmentJobResponse> startVectorEnrichmentJob(
            StartVectorEnrichmentJobRequest startVectorEnrichmentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Vector Enrichment job for the supplied job type. Currently, there are two supported job types: reverse
     * geocoding and map matching.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartVectorEnrichmentJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartVectorEnrichmentJobRequest#builder()}
     * </p>
     *
     * @param startVectorEnrichmentJobRequest
     *        A {@link Consumer} that will call methods on {@link StartVectorEnrichmentJobInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartVectorEnrichmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.StartVectorEnrichmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StartVectorEnrichmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartVectorEnrichmentJobResponse> startVectorEnrichmentJob(
            Consumer<StartVectorEnrichmentJobRequest.Builder> startVectorEnrichmentJobRequest) {
        return startVectorEnrichmentJob(StartVectorEnrichmentJobRequest.builder().applyMutation(startVectorEnrichmentJobRequest)
                .build());
    }

    /**
     * <p>
     * Use this operation to stop an existing earth observation job.
     * </p>
     *
     * @param stopEarthObservationJobRequest
     * @return A Java Future containing the result of the StopEarthObservationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.StopEarthObservationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StopEarthObservationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopEarthObservationJobResponse> stopEarthObservationJob(
            StopEarthObservationJobRequest stopEarthObservationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to stop an existing earth observation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopEarthObservationJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopEarthObservationJobRequest#builder()}
     * </p>
     *
     * @param stopEarthObservationJobRequest
     *        A {@link Consumer} that will call methods on {@link StopEarthObservationJobInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopEarthObservationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.StopEarthObservationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StopEarthObservationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopEarthObservationJobResponse> stopEarthObservationJob(
            Consumer<StopEarthObservationJobRequest.Builder> stopEarthObservationJobRequest) {
        return stopEarthObservationJob(StopEarthObservationJobRequest.builder().applyMutation(stopEarthObservationJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops the Vector Enrichment job for a given job ARN.
     * </p>
     *
     * @param stopVectorEnrichmentJobRequest
     * @return A Java Future containing the result of the StopVectorEnrichmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.StopVectorEnrichmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StopVectorEnrichmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopVectorEnrichmentJobResponse> stopVectorEnrichmentJob(
            StopVectorEnrichmentJobRequest stopVectorEnrichmentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the Vector Enrichment job for a given job ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopVectorEnrichmentJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopVectorEnrichmentJobRequest#builder()}
     * </p>
     *
     * @param stopVectorEnrichmentJobRequest
     *        A {@link Consumer} that will call methods on {@link StopVectorEnrichmentJobInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopVectorEnrichmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.StopVectorEnrichmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StopVectorEnrichmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopVectorEnrichmentJobResponse> stopVectorEnrichmentJob(
            Consumer<StopVectorEnrichmentJobRequest.Builder> stopVectorEnrichmentJobRequest) {
        return stopVectorEnrichmentJob(StopVectorEnrichmentJobRequest.builder().applyMutation(stopVectorEnrichmentJobRequest)
                .build());
    }

    /**
     * <p>
     * The resource you want to tag.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The resource you want to tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * The resource you want to untag.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The resource you want to untag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerGeospatialException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerGeospatialAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    @Override
    SageMakerGeospatialServiceClientConfiguration serviceClientConfiguration();

    /**
     * Create a {@link SageMakerGeospatialAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SageMakerGeospatialAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SageMakerGeospatialAsyncClient}.
     */
    static SageMakerGeospatialAsyncClientBuilder builder() {
        return new DefaultSageMakerGeospatialAsyncClientBuilder();
    }
}
