/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EojDataSourceConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<EojDataSourceConfigInput.Builder, EojDataSourceConfigInput> {
    private static final SdkField<S3DataInput> S3_DATA_FIELD = SdkField.<S3DataInput> builder(MarshallingType.SDK_POJO)
            .memberName("S3Data").getter(getter(EojDataSourceConfigInput::s3Data)).setter(setter(Builder::s3Data))
            .constructor(S3DataInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3DataInput s3Data;

    private final Type type;

    private EojDataSourceConfigInput(BuilderImpl builder) {
        this.s3Data = builder.s3Data;
        this.type = builder.type;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final S3DataInput s3Data() {
        return s3Data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EojDataSourceConfigInput)) {
            return false;
        }
        EojDataSourceConfigInput other = (EojDataSourceConfigInput) obj;
        return Objects.equals(s3Data(), other.s3Data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EojDataSourceConfigInput").add("S3Data", s3Data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Data":
            return Optional.ofNullable(clazz.cast(s3Data()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3Data()} initialized to the given value.
     *
     * <p/>
     * 
     * @param s3Data
     */
    public static EojDataSourceConfigInput fromS3Data(S3DataInput s3Data) {
        return builder().s3Data(s3Data).build();
    }

    /**
     * Create an instance of this class with {@link #s3Data()} initialized to the given value.
     *
     * <p/>
     * 
     * @param s3Data
     */
    public static EojDataSourceConfigInput fromS3Data(Consumer<S3DataInput.Builder> s3Data) {
        S3DataInput.Builder builder = S3DataInput.builder();
        s3Data.accept(builder);
        return fromS3Data(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EojDataSourceConfigInput, T> g) {
        return obj -> g.apply((EojDataSourceConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EojDataSourceConfigInput> {
        /**
         * <p/>
         * 
         * @param s3Data
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Data(S3DataInput s3Data);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link S3DataInput.Builder} avoiding the need to
         * create one manually via {@link S3DataInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DataInput.Builder#build()} is called immediately and its result
         * is passed to {@link #s3Data(S3DataInput)}.
         * 
         * @param s3Data
         *        a consumer that will call methods on {@link S3DataInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Data(S3DataInput)
         */
        default Builder s3Data(Consumer<S3DataInput.Builder> s3Data) {
            return s3Data(S3DataInput.builder().applyMutation(s3Data).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3DataInput s3Data;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EojDataSourceConfigInput model) {
            s3Data(model.s3Data);
        }

        public final S3DataInput.Builder getS3Data() {
            return s3Data != null ? s3Data.toBuilder() : null;
        }

        public final void setS3Data(S3DataInput.BuilderImpl s3Data) {
            Object oldValue = this.s3Data;
            this.s3Data = s3Data != null ? s3Data.build() : null;
            handleUnionValueChange(Type.S3_DATA, oldValue, this.s3Data);
        }

        @Override
        public final Builder s3Data(S3DataInput s3Data) {
            Object oldValue = this.s3Data;
            this.s3Data = s3Data;
            handleUnionValueChange(Type.S3_DATA, oldValue, this.s3Data);
            return this;
        }

        @Override
        public EojDataSourceConfigInput build() {
            return new EojDataSourceConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EojDataSourceConfigInput#type()
     */
    public enum Type {
        S3_DATA,

        UNKNOWN_TO_SDK_VERSION
    }
}
