/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure for returning the export error details in a GetEarthObservationJob.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportErrorDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportErrorDetails.Builder, ExportErrorDetails> {
    private static final SdkField<ExportErrorDetailsOutput> EXPORT_RESULTS_FIELD = SdkField
            .<ExportErrorDetailsOutput> builder(MarshallingType.SDK_POJO).memberName("ExportResults")
            .getter(getter(ExportErrorDetails::exportResults)).setter(setter(Builder::exportResults))
            .constructor(ExportErrorDetailsOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportResults").build()).build();

    private static final SdkField<ExportErrorDetailsOutput> EXPORT_SOURCE_IMAGES_FIELD = SdkField
            .<ExportErrorDetailsOutput> builder(MarshallingType.SDK_POJO).memberName("ExportSourceImages")
            .getter(getter(ExportErrorDetails::exportSourceImages)).setter(setter(Builder::exportSourceImages))
            .constructor(ExportErrorDetailsOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSourceImages").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_RESULTS_FIELD,
            EXPORT_SOURCE_IMAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ExportErrorDetailsOutput exportResults;

    private final ExportErrorDetailsOutput exportSourceImages;

    private ExportErrorDetails(BuilderImpl builder) {
        this.exportResults = builder.exportResults;
        this.exportSourceImages = builder.exportSourceImages;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final ExportErrorDetailsOutput exportResults() {
        return exportResults;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final ExportErrorDetailsOutput exportSourceImages() {
        return exportSourceImages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportResults());
        hashCode = 31 * hashCode + Objects.hashCode(exportSourceImages());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportErrorDetails)) {
            return false;
        }
        ExportErrorDetails other = (ExportErrorDetails) obj;
        return Objects.equals(exportResults(), other.exportResults())
                && Objects.equals(exportSourceImages(), other.exportSourceImages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportErrorDetails").add("ExportResults", exportResults())
                .add("ExportSourceImages", exportSourceImages()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportResults":
            return Optional.ofNullable(clazz.cast(exportResults()));
        case "ExportSourceImages":
            return Optional.ofNullable(clazz.cast(exportSourceImages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportErrorDetails, T> g) {
        return obj -> g.apply((ExportErrorDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportErrorDetails> {
        /**
         * <p/>
         * 
         * @param exportResults
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportResults(ExportErrorDetailsOutput exportResults);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link ExportErrorDetailsOutput.Builder}
         * avoiding the need to create one manually via {@link ExportErrorDetailsOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportErrorDetailsOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #exportResults(ExportErrorDetailsOutput)}.
         * 
         * @param exportResults
         *        a consumer that will call methods on {@link ExportErrorDetailsOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportResults(ExportErrorDetailsOutput)
         */
        default Builder exportResults(Consumer<ExportErrorDetailsOutput.Builder> exportResults) {
            return exportResults(ExportErrorDetailsOutput.builder().applyMutation(exportResults).build());
        }

        /**
         * <p/>
         * 
         * @param exportSourceImages
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportSourceImages(ExportErrorDetailsOutput exportSourceImages);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link ExportErrorDetailsOutput.Builder}
         * avoiding the need to create one manually via {@link ExportErrorDetailsOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportErrorDetailsOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #exportSourceImages(ExportErrorDetailsOutput)}.
         * 
         * @param exportSourceImages
         *        a consumer that will call methods on {@link ExportErrorDetailsOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportSourceImages(ExportErrorDetailsOutput)
         */
        default Builder exportSourceImages(Consumer<ExportErrorDetailsOutput.Builder> exportSourceImages) {
            return exportSourceImages(ExportErrorDetailsOutput.builder().applyMutation(exportSourceImages).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ExportErrorDetailsOutput exportResults;

        private ExportErrorDetailsOutput exportSourceImages;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportErrorDetails model) {
            exportResults(model.exportResults);
            exportSourceImages(model.exportSourceImages);
        }

        public final ExportErrorDetailsOutput.Builder getExportResults() {
            return exportResults != null ? exportResults.toBuilder() : null;
        }

        public final void setExportResults(ExportErrorDetailsOutput.BuilderImpl exportResults) {
            this.exportResults = exportResults != null ? exportResults.build() : null;
        }

        @Override
        public final Builder exportResults(ExportErrorDetailsOutput exportResults) {
            this.exportResults = exportResults;
            return this;
        }

        public final ExportErrorDetailsOutput.Builder getExportSourceImages() {
            return exportSourceImages != null ? exportSourceImages.toBuilder() : null;
        }

        public final void setExportSourceImages(ExportErrorDetailsOutput.BuilderImpl exportSourceImages) {
            this.exportSourceImages = exportSourceImages != null ? exportSourceImages.build() : null;
        }

        @Override
        public final Builder exportSourceImages(ExportErrorDetailsOutput exportSourceImages) {
            this.exportSourceImages = exportSourceImages;
            return this;
        }

        @Override
        public ExportErrorDetails build() {
            return new ExportErrorDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
