/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input configuration information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<InputConfigInput.Builder, InputConfigInput> {
    private static final SdkField<EojDataSourceConfigInput> DATA_SOURCE_CONFIG_FIELD = SdkField
            .<EojDataSourceConfigInput> builder(MarshallingType.SDK_POJO).memberName("DataSourceConfig")
            .getter(getter(InputConfigInput::dataSourceConfig)).setter(setter(Builder::dataSourceConfig))
            .constructor(EojDataSourceConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceConfig").build()).build();

    private static final SdkField<String> PREVIOUS_EARTH_OBSERVATION_JOB_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreviousEarthObservationJobArn")
            .getter(getter(InputConfigInput::previousEarthObservationJobArn))
            .setter(setter(Builder::previousEarthObservationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousEarthObservationJobArn")
                    .build()).build();

    private static final SdkField<RasterDataCollectionQueryInput> RASTER_DATA_COLLECTION_QUERY_FIELD = SdkField
            .<RasterDataCollectionQueryInput> builder(MarshallingType.SDK_POJO).memberName("RasterDataCollectionQuery")
            .getter(getter(InputConfigInput::rasterDataCollectionQuery)).setter(setter(Builder::rasterDataCollectionQuery))
            .constructor(RasterDataCollectionQueryInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RasterDataCollectionQuery").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_CONFIG_FIELD,
            PREVIOUS_EARTH_OBSERVATION_JOB_ARN_FIELD, RASTER_DATA_COLLECTION_QUERY_FIELD));

    private static final long serialVersionUID = 1L;

    private final EojDataSourceConfigInput dataSourceConfig;

    private final String previousEarthObservationJobArn;

    private final RasterDataCollectionQueryInput rasterDataCollectionQuery;

    private InputConfigInput(BuilderImpl builder) {
        this.dataSourceConfig = builder.dataSourceConfig;
        this.previousEarthObservationJobArn = builder.previousEarthObservationJobArn;
        this.rasterDataCollectionQuery = builder.rasterDataCollectionQuery;
    }

    /**
     * <p>
     * The location of the input data.&gt;
     * </p>
     * 
     * @return The location of the input data.&gt;
     */
    public final EojDataSourceConfigInput dataSourceConfig() {
        return dataSourceConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the previous Earth Observation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the previous Earth Observation job.
     */
    public final String previousEarthObservationJobArn() {
        return previousEarthObservationJobArn;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final RasterDataCollectionQueryInput rasterDataCollectionQuery() {
        return rasterDataCollectionQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(previousEarthObservationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(rasterDataCollectionQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConfigInput)) {
            return false;
        }
        InputConfigInput other = (InputConfigInput) obj;
        return Objects.equals(dataSourceConfig(), other.dataSourceConfig())
                && Objects.equals(previousEarthObservationJobArn(), other.previousEarthObservationJobArn())
                && Objects.equals(rasterDataCollectionQuery(), other.rasterDataCollectionQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputConfigInput").add("DataSourceConfig", dataSourceConfig())
                .add("PreviousEarthObservationJobArn", previousEarthObservationJobArn())
                .add("RasterDataCollectionQuery", rasterDataCollectionQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceConfig":
            return Optional.ofNullable(clazz.cast(dataSourceConfig()));
        case "PreviousEarthObservationJobArn":
            return Optional.ofNullable(clazz.cast(previousEarthObservationJobArn()));
        case "RasterDataCollectionQuery":
            return Optional.ofNullable(clazz.cast(rasterDataCollectionQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputConfigInput, T> g) {
        return obj -> g.apply((InputConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputConfigInput> {
        /**
         * <p>
         * The location of the input data.&gt;
         * </p>
         * 
         * @param dataSourceConfig
         *        The location of the input data.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceConfig(EojDataSourceConfigInput dataSourceConfig);

        /**
         * <p>
         * The location of the input data.&gt;
         * </p>
         * This is a convenience method that creates an instance of the {@link EojDataSourceConfigInput.Builder}
         * avoiding the need to create one manually via {@link EojDataSourceConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EojDataSourceConfigInput.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSourceConfig(EojDataSourceConfigInput)}.
         * 
         * @param dataSourceConfig
         *        a consumer that will call methods on {@link EojDataSourceConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceConfig(EojDataSourceConfigInput)
         */
        default Builder dataSourceConfig(Consumer<EojDataSourceConfigInput.Builder> dataSourceConfig) {
            return dataSourceConfig(EojDataSourceConfigInput.builder().applyMutation(dataSourceConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the previous Earth Observation job.
         * </p>
         * 
         * @param previousEarthObservationJobArn
         *        The Amazon Resource Name (ARN) of the previous Earth Observation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousEarthObservationJobArn(String previousEarthObservationJobArn);

        /**
         * <p/>
         * 
         * @param rasterDataCollectionQuery
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rasterDataCollectionQuery(RasterDataCollectionQueryInput rasterDataCollectionQuery);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link RasterDataCollectionQueryInput.Builder}
         * avoiding the need to create one manually via {@link RasterDataCollectionQueryInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RasterDataCollectionQueryInput.Builder#build()} is called
         * immediately and its result is passed to {@link #rasterDataCollectionQuery(RasterDataCollectionQueryInput)}.
         * 
         * @param rasterDataCollectionQuery
         *        a consumer that will call methods on {@link RasterDataCollectionQueryInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rasterDataCollectionQuery(RasterDataCollectionQueryInput)
         */
        default Builder rasterDataCollectionQuery(Consumer<RasterDataCollectionQueryInput.Builder> rasterDataCollectionQuery) {
            return rasterDataCollectionQuery(RasterDataCollectionQueryInput.builder().applyMutation(rasterDataCollectionQuery)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EojDataSourceConfigInput dataSourceConfig;

        private String previousEarthObservationJobArn;

        private RasterDataCollectionQueryInput rasterDataCollectionQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConfigInput model) {
            dataSourceConfig(model.dataSourceConfig);
            previousEarthObservationJobArn(model.previousEarthObservationJobArn);
            rasterDataCollectionQuery(model.rasterDataCollectionQuery);
        }

        public final EojDataSourceConfigInput.Builder getDataSourceConfig() {
            return dataSourceConfig != null ? dataSourceConfig.toBuilder() : null;
        }

        public final void setDataSourceConfig(EojDataSourceConfigInput.BuilderImpl dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig != null ? dataSourceConfig.build() : null;
        }

        @Override
        public final Builder dataSourceConfig(EojDataSourceConfigInput dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig;
            return this;
        }

        public final String getPreviousEarthObservationJobArn() {
            return previousEarthObservationJobArn;
        }

        public final void setPreviousEarthObservationJobArn(String previousEarthObservationJobArn) {
            this.previousEarthObservationJobArn = previousEarthObservationJobArn;
        }

        @Override
        public final Builder previousEarthObservationJobArn(String previousEarthObservationJobArn) {
            this.previousEarthObservationJobArn = previousEarthObservationJobArn;
            return this;
        }

        public final RasterDataCollectionQueryInput.Builder getRasterDataCollectionQuery() {
            return rasterDataCollectionQuery != null ? rasterDataCollectionQuery.toBuilder() : null;
        }

        public final void setRasterDataCollectionQuery(RasterDataCollectionQueryInput.BuilderImpl rasterDataCollectionQuery) {
            this.rasterDataCollectionQuery = rasterDataCollectionQuery != null ? rasterDataCollectionQuery.build() : null;
        }

        @Override
        public final Builder rasterDataCollectionQuery(RasterDataCollectionQueryInput rasterDataCollectionQuery) {
            this.rasterDataCollectionQuery = rasterDataCollectionQuery;
            return this;
        }

        @Override
        public InputConfigInput build() {
            return new InputConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
