/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input structure for the JobConfig in an EarthObservationJob.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobConfigInput implements SdkPojo, Serializable, ToCopyableBuilder<JobConfigInput.Builder, JobConfigInput> {
    private static final SdkField<BandMathConfigInput> BAND_MATH_CONFIG_FIELD = SdkField
            .<BandMathConfigInput> builder(MarshallingType.SDK_POJO).memberName("BandMathConfig")
            .getter(getter(JobConfigInput::bandMathConfig)).setter(setter(Builder::bandMathConfig))
            .constructor(BandMathConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandMathConfig").build()).build();

    private static final SdkField<CloudMaskingConfigInput> CLOUD_MASKING_CONFIG_FIELD = SdkField
            .<CloudMaskingConfigInput> builder(MarshallingType.SDK_POJO).memberName("CloudMaskingConfig")
            .getter(getter(JobConfigInput::cloudMaskingConfig)).setter(setter(Builder::cloudMaskingConfig))
            .constructor(CloudMaskingConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudMaskingConfig").build())
            .build();

    private static final SdkField<CloudRemovalConfigInput> CLOUD_REMOVAL_CONFIG_FIELD = SdkField
            .<CloudRemovalConfigInput> builder(MarshallingType.SDK_POJO).memberName("CloudRemovalConfig")
            .getter(getter(JobConfigInput::cloudRemovalConfig)).setter(setter(Builder::cloudRemovalConfig))
            .constructor(CloudRemovalConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudRemovalConfig").build())
            .build();

    private static final SdkField<GeoMosaicConfigInput> GEO_MOSAIC_CONFIG_FIELD = SdkField
            .<GeoMosaicConfigInput> builder(MarshallingType.SDK_POJO).memberName("GeoMosaicConfig")
            .getter(getter(JobConfigInput::geoMosaicConfig)).setter(setter(Builder::geoMosaicConfig))
            .constructor(GeoMosaicConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMosaicConfig").build()).build();

    private static final SdkField<LandCoverSegmentationConfigInput> LAND_COVER_SEGMENTATION_CONFIG_FIELD = SdkField
            .<LandCoverSegmentationConfigInput> builder(MarshallingType.SDK_POJO)
            .memberName("LandCoverSegmentationConfig")
            .getter(getter(JobConfigInput::landCoverSegmentationConfig))
            .setter(setter(Builder::landCoverSegmentationConfig))
            .constructor(LandCoverSegmentationConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LandCoverSegmentationConfig")
                    .build()).build();

    private static final SdkField<ResamplingConfigInput> RESAMPLING_CONFIG_FIELD = SdkField
            .<ResamplingConfigInput> builder(MarshallingType.SDK_POJO).memberName("ResamplingConfig")
            .getter(getter(JobConfigInput::resamplingConfig)).setter(setter(Builder::resamplingConfig))
            .constructor(ResamplingConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResamplingConfig").build()).build();

    private static final SdkField<StackConfigInput> STACK_CONFIG_FIELD = SdkField
            .<StackConfigInput> builder(MarshallingType.SDK_POJO).memberName("StackConfig")
            .getter(getter(JobConfigInput::stackConfig)).setter(setter(Builder::stackConfig))
            .constructor(StackConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackConfig").build()).build();

    private static final SdkField<TemporalStatisticsConfigInput> TEMPORAL_STATISTICS_CONFIG_FIELD = SdkField
            .<TemporalStatisticsConfigInput> builder(MarshallingType.SDK_POJO).memberName("TemporalStatisticsConfig")
            .getter(getter(JobConfigInput::temporalStatisticsConfig)).setter(setter(Builder::temporalStatisticsConfig))
            .constructor(TemporalStatisticsConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemporalStatisticsConfig").build())
            .build();

    private static final SdkField<ZonalStatisticsConfigInput> ZONAL_STATISTICS_CONFIG_FIELD = SdkField
            .<ZonalStatisticsConfigInput> builder(MarshallingType.SDK_POJO).memberName("ZonalStatisticsConfig")
            .getter(getter(JobConfigInput::zonalStatisticsConfig)).setter(setter(Builder::zonalStatisticsConfig))
            .constructor(ZonalStatisticsConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZonalStatisticsConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BAND_MATH_CONFIG_FIELD,
            CLOUD_MASKING_CONFIG_FIELD, CLOUD_REMOVAL_CONFIG_FIELD, GEO_MOSAIC_CONFIG_FIELD,
            LAND_COVER_SEGMENTATION_CONFIG_FIELD, RESAMPLING_CONFIG_FIELD, STACK_CONFIG_FIELD, TEMPORAL_STATISTICS_CONFIG_FIELD,
            ZONAL_STATISTICS_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final BandMathConfigInput bandMathConfig;

    private final CloudMaskingConfigInput cloudMaskingConfig;

    private final CloudRemovalConfigInput cloudRemovalConfig;

    private final GeoMosaicConfigInput geoMosaicConfig;

    private final LandCoverSegmentationConfigInput landCoverSegmentationConfig;

    private final ResamplingConfigInput resamplingConfig;

    private final StackConfigInput stackConfig;

    private final TemporalStatisticsConfigInput temporalStatisticsConfig;

    private final ZonalStatisticsConfigInput zonalStatisticsConfig;

    private final Type type;

    private JobConfigInput(BuilderImpl builder) {
        this.bandMathConfig = builder.bandMathConfig;
        this.cloudMaskingConfig = builder.cloudMaskingConfig;
        this.cloudRemovalConfig = builder.cloudRemovalConfig;
        this.geoMosaicConfig = builder.geoMosaicConfig;
        this.landCoverSegmentationConfig = builder.landCoverSegmentationConfig;
        this.resamplingConfig = builder.resamplingConfig;
        this.stackConfig = builder.stackConfig;
        this.temporalStatisticsConfig = builder.temporalStatisticsConfig;
        this.zonalStatisticsConfig = builder.zonalStatisticsConfig;
        this.type = builder.type;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final BandMathConfigInput bandMathConfig() {
        return bandMathConfig;
    }

    /**
     * <p>
     * An object containing information about the job configuration for cloud masking.
     * </p>
     * 
     * @return An object containing information about the job configuration for cloud masking.
     */
    public final CloudMaskingConfigInput cloudMaskingConfig() {
        return cloudMaskingConfig;
    }

    /**
     * <p>
     * An object containing information about the job configuration for cloud removal.
     * </p>
     * 
     * @return An object containing information about the job configuration for cloud removal.
     */
    public final CloudRemovalConfigInput cloudRemovalConfig() {
        return cloudRemovalConfig;
    }

    /**
     * <p>
     * An object containing information about the job configuration for geomosaic.
     * </p>
     * 
     * @return An object containing information about the job configuration for geomosaic.
     */
    public final GeoMosaicConfigInput geoMosaicConfig() {
        return geoMosaicConfig;
    }

    /**
     * <p>
     * An object containing information about the job configuration for land cover segmentation.
     * </p>
     * 
     * @return An object containing information about the job configuration for land cover segmentation.
     */
    public final LandCoverSegmentationConfigInput landCoverSegmentationConfig() {
        return landCoverSegmentationConfig;
    }

    /**
     * <p>
     * An object containing information about the job configuration for resampling.
     * </p>
     * 
     * @return An object containing information about the job configuration for resampling.
     */
    public final ResamplingConfigInput resamplingConfig() {
        return resamplingConfig;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final StackConfigInput stackConfig() {
        return stackConfig;
    }

    /**
     * <p>
     * An object containing information about the job configuration for temporal statistics.
     * </p>
     * 
     * @return An object containing information about the job configuration for temporal statistics.
     */
    public final TemporalStatisticsConfigInput temporalStatisticsConfig() {
        return temporalStatisticsConfig;
    }

    /**
     * <p>
     * An object containing information about the job configuration for zonal statistics.
     * </p>
     * 
     * @return An object containing information about the job configuration for zonal statistics.
     */
    public final ZonalStatisticsConfigInput zonalStatisticsConfig() {
        return zonalStatisticsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bandMathConfig());
        hashCode = 31 * hashCode + Objects.hashCode(cloudMaskingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(cloudRemovalConfig());
        hashCode = 31 * hashCode + Objects.hashCode(geoMosaicConfig());
        hashCode = 31 * hashCode + Objects.hashCode(landCoverSegmentationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(resamplingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(stackConfig());
        hashCode = 31 * hashCode + Objects.hashCode(temporalStatisticsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(zonalStatisticsConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobConfigInput)) {
            return false;
        }
        JobConfigInput other = (JobConfigInput) obj;
        return Objects.equals(bandMathConfig(), other.bandMathConfig())
                && Objects.equals(cloudMaskingConfig(), other.cloudMaskingConfig())
                && Objects.equals(cloudRemovalConfig(), other.cloudRemovalConfig())
                && Objects.equals(geoMosaicConfig(), other.geoMosaicConfig())
                && Objects.equals(landCoverSegmentationConfig(), other.landCoverSegmentationConfig())
                && Objects.equals(resamplingConfig(), other.resamplingConfig())
                && Objects.equals(stackConfig(), other.stackConfig())
                && Objects.equals(temporalStatisticsConfig(), other.temporalStatisticsConfig())
                && Objects.equals(zonalStatisticsConfig(), other.zonalStatisticsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobConfigInput").add("BandMathConfig", bandMathConfig())
                .add("CloudMaskingConfig", cloudMaskingConfig()).add("CloudRemovalConfig", cloudRemovalConfig())
                .add("GeoMosaicConfig", geoMosaicConfig()).add("LandCoverSegmentationConfig", landCoverSegmentationConfig())
                .add("ResamplingConfig", resamplingConfig()).add("StackConfig", stackConfig())
                .add("TemporalStatisticsConfig", temporalStatisticsConfig())
                .add("ZonalStatisticsConfig", zonalStatisticsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BandMathConfig":
            return Optional.ofNullable(clazz.cast(bandMathConfig()));
        case "CloudMaskingConfig":
            return Optional.ofNullable(clazz.cast(cloudMaskingConfig()));
        case "CloudRemovalConfig":
            return Optional.ofNullable(clazz.cast(cloudRemovalConfig()));
        case "GeoMosaicConfig":
            return Optional.ofNullable(clazz.cast(geoMosaicConfig()));
        case "LandCoverSegmentationConfig":
            return Optional.ofNullable(clazz.cast(landCoverSegmentationConfig()));
        case "ResamplingConfig":
            return Optional.ofNullable(clazz.cast(resamplingConfig()));
        case "StackConfig":
            return Optional.ofNullable(clazz.cast(stackConfig()));
        case "TemporalStatisticsConfig":
            return Optional.ofNullable(clazz.cast(temporalStatisticsConfig()));
        case "ZonalStatisticsConfig":
            return Optional.ofNullable(clazz.cast(zonalStatisticsConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #bandMathConfig()} initialized to the given value.
     *
     * <p/>
     * 
     * @param bandMathConfig
     */
    public static JobConfigInput fromBandMathConfig(BandMathConfigInput bandMathConfig) {
        return builder().bandMathConfig(bandMathConfig).build();
    }

    /**
     * Create an instance of this class with {@link #bandMathConfig()} initialized to the given value.
     *
     * <p/>
     * 
     * @param bandMathConfig
     */
    public static JobConfigInput fromBandMathConfig(Consumer<BandMathConfigInput.Builder> bandMathConfig) {
        BandMathConfigInput.Builder builder = BandMathConfigInput.builder();
        bandMathConfig.accept(builder);
        return fromBandMathConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #cloudMaskingConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for cloud masking.
     * </p>
     * 
     * @param cloudMaskingConfig
     *        An object containing information about the job configuration for cloud masking.
     */
    public static JobConfigInput fromCloudMaskingConfig(CloudMaskingConfigInput cloudMaskingConfig) {
        return builder().cloudMaskingConfig(cloudMaskingConfig).build();
    }

    /**
     * Create an instance of this class with {@link #cloudMaskingConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for cloud masking.
     * </p>
     * 
     * @param cloudMaskingConfig
     *        An object containing information about the job configuration for cloud masking.
     */
    public static JobConfigInput fromCloudMaskingConfig(Consumer<CloudMaskingConfigInput.Builder> cloudMaskingConfig) {
        CloudMaskingConfigInput.Builder builder = CloudMaskingConfigInput.builder();
        cloudMaskingConfig.accept(builder);
        return fromCloudMaskingConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #cloudRemovalConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for cloud removal.
     * </p>
     * 
     * @param cloudRemovalConfig
     *        An object containing information about the job configuration for cloud removal.
     */
    public static JobConfigInput fromCloudRemovalConfig(CloudRemovalConfigInput cloudRemovalConfig) {
        return builder().cloudRemovalConfig(cloudRemovalConfig).build();
    }

    /**
     * Create an instance of this class with {@link #cloudRemovalConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for cloud removal.
     * </p>
     * 
     * @param cloudRemovalConfig
     *        An object containing information about the job configuration for cloud removal.
     */
    public static JobConfigInput fromCloudRemovalConfig(Consumer<CloudRemovalConfigInput.Builder> cloudRemovalConfig) {
        CloudRemovalConfigInput.Builder builder = CloudRemovalConfigInput.builder();
        cloudRemovalConfig.accept(builder);
        return fromCloudRemovalConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #geoMosaicConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for geomosaic.
     * </p>
     * 
     * @param geoMosaicConfig
     *        An object containing information about the job configuration for geomosaic.
     */
    public static JobConfigInput fromGeoMosaicConfig(GeoMosaicConfigInput geoMosaicConfig) {
        return builder().geoMosaicConfig(geoMosaicConfig).build();
    }

    /**
     * Create an instance of this class with {@link #geoMosaicConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for geomosaic.
     * </p>
     * 
     * @param geoMosaicConfig
     *        An object containing information about the job configuration for geomosaic.
     */
    public static JobConfigInput fromGeoMosaicConfig(Consumer<GeoMosaicConfigInput.Builder> geoMosaicConfig) {
        GeoMosaicConfigInput.Builder builder = GeoMosaicConfigInput.builder();
        geoMosaicConfig.accept(builder);
        return fromGeoMosaicConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #landCoverSegmentationConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for land cover segmentation.
     * </p>
     * 
     * @param landCoverSegmentationConfig
     *        An object containing information about the job configuration for land cover segmentation.
     */
    public static JobConfigInput fromLandCoverSegmentationConfig(LandCoverSegmentationConfigInput landCoverSegmentationConfig) {
        return builder().landCoverSegmentationConfig(landCoverSegmentationConfig).build();
    }

    /**
     * Create an instance of this class with {@link #landCoverSegmentationConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for land cover segmentation.
     * </p>
     * 
     * @param landCoverSegmentationConfig
     *        An object containing information about the job configuration for land cover segmentation.
     */
    public static JobConfigInput fromLandCoverSegmentationConfig(
            Consumer<LandCoverSegmentationConfigInput.Builder> landCoverSegmentationConfig) {
        LandCoverSegmentationConfigInput.Builder builder = LandCoverSegmentationConfigInput.builder();
        landCoverSegmentationConfig.accept(builder);
        return fromLandCoverSegmentationConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #resamplingConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for resampling.
     * </p>
     * 
     * @param resamplingConfig
     *        An object containing information about the job configuration for resampling.
     */
    public static JobConfigInput fromResamplingConfig(ResamplingConfigInput resamplingConfig) {
        return builder().resamplingConfig(resamplingConfig).build();
    }

    /**
     * Create an instance of this class with {@link #resamplingConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for resampling.
     * </p>
     * 
     * @param resamplingConfig
     *        An object containing information about the job configuration for resampling.
     */
    public static JobConfigInput fromResamplingConfig(Consumer<ResamplingConfigInput.Builder> resamplingConfig) {
        ResamplingConfigInput.Builder builder = ResamplingConfigInput.builder();
        resamplingConfig.accept(builder);
        return fromResamplingConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stackConfig()} initialized to the given value.
     *
     * <p/>
     * 
     * @param stackConfig
     */
    public static JobConfigInput fromStackConfig(StackConfigInput stackConfig) {
        return builder().stackConfig(stackConfig).build();
    }

    /**
     * Create an instance of this class with {@link #stackConfig()} initialized to the given value.
     *
     * <p/>
     * 
     * @param stackConfig
     */
    public static JobConfigInput fromStackConfig(Consumer<StackConfigInput.Builder> stackConfig) {
        StackConfigInput.Builder builder = StackConfigInput.builder();
        stackConfig.accept(builder);
        return fromStackConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #temporalStatisticsConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for temporal statistics.
     * </p>
     * 
     * @param temporalStatisticsConfig
     *        An object containing information about the job configuration for temporal statistics.
     */
    public static JobConfigInput fromTemporalStatisticsConfig(TemporalStatisticsConfigInput temporalStatisticsConfig) {
        return builder().temporalStatisticsConfig(temporalStatisticsConfig).build();
    }

    /**
     * Create an instance of this class with {@link #temporalStatisticsConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for temporal statistics.
     * </p>
     * 
     * @param temporalStatisticsConfig
     *        An object containing information about the job configuration for temporal statistics.
     */
    public static JobConfigInput fromTemporalStatisticsConfig(
            Consumer<TemporalStatisticsConfigInput.Builder> temporalStatisticsConfig) {
        TemporalStatisticsConfigInput.Builder builder = TemporalStatisticsConfigInput.builder();
        temporalStatisticsConfig.accept(builder);
        return fromTemporalStatisticsConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #zonalStatisticsConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for zonal statistics.
     * </p>
     * 
     * @param zonalStatisticsConfig
     *        An object containing information about the job configuration for zonal statistics.
     */
    public static JobConfigInput fromZonalStatisticsConfig(ZonalStatisticsConfigInput zonalStatisticsConfig) {
        return builder().zonalStatisticsConfig(zonalStatisticsConfig).build();
    }

    /**
     * Create an instance of this class with {@link #zonalStatisticsConfig()} initialized to the given value.
     *
     * <p>
     * An object containing information about the job configuration for zonal statistics.
     * </p>
     * 
     * @param zonalStatisticsConfig
     *        An object containing information about the job configuration for zonal statistics.
     */
    public static JobConfigInput fromZonalStatisticsConfig(Consumer<ZonalStatisticsConfigInput.Builder> zonalStatisticsConfig) {
        ZonalStatisticsConfigInput.Builder builder = ZonalStatisticsConfigInput.builder();
        zonalStatisticsConfig.accept(builder);
        return fromZonalStatisticsConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobConfigInput, T> g) {
        return obj -> g.apply((JobConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobConfigInput> {
        /**
         * <p/>
         * 
         * @param bandMathConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandMathConfig(BandMathConfigInput bandMathConfig);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link BandMathConfigInput.Builder} avoiding the
         * need to create one manually via {@link BandMathConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BandMathConfigInput.Builder#build()} is called immediately and
         * its result is passed to {@link #bandMathConfig(BandMathConfigInput)}.
         * 
         * @param bandMathConfig
         *        a consumer that will call methods on {@link BandMathConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bandMathConfig(BandMathConfigInput)
         */
        default Builder bandMathConfig(Consumer<BandMathConfigInput.Builder> bandMathConfig) {
            return bandMathConfig(BandMathConfigInput.builder().applyMutation(bandMathConfig).build());
        }

        /**
         * <p>
         * An object containing information about the job configuration for cloud masking.
         * </p>
         * 
         * @param cloudMaskingConfig
         *        An object containing information about the job configuration for cloud masking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudMaskingConfig(CloudMaskingConfigInput cloudMaskingConfig);

        /**
         * <p>
         * An object containing information about the job configuration for cloud masking.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudMaskingConfigInput.Builder} avoiding
         * the need to create one manually via {@link CloudMaskingConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudMaskingConfigInput.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudMaskingConfig(CloudMaskingConfigInput)}.
         * 
         * @param cloudMaskingConfig
         *        a consumer that will call methods on {@link CloudMaskingConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudMaskingConfig(CloudMaskingConfigInput)
         */
        default Builder cloudMaskingConfig(Consumer<CloudMaskingConfigInput.Builder> cloudMaskingConfig) {
            return cloudMaskingConfig(CloudMaskingConfigInput.builder().applyMutation(cloudMaskingConfig).build());
        }

        /**
         * <p>
         * An object containing information about the job configuration for cloud removal.
         * </p>
         * 
         * @param cloudRemovalConfig
         *        An object containing information about the job configuration for cloud removal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudRemovalConfig(CloudRemovalConfigInput cloudRemovalConfig);

        /**
         * <p>
         * An object containing information about the job configuration for cloud removal.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudRemovalConfigInput.Builder} avoiding
         * the need to create one manually via {@link CloudRemovalConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudRemovalConfigInput.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudRemovalConfig(CloudRemovalConfigInput)}.
         * 
         * @param cloudRemovalConfig
         *        a consumer that will call methods on {@link CloudRemovalConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudRemovalConfig(CloudRemovalConfigInput)
         */
        default Builder cloudRemovalConfig(Consumer<CloudRemovalConfigInput.Builder> cloudRemovalConfig) {
            return cloudRemovalConfig(CloudRemovalConfigInput.builder().applyMutation(cloudRemovalConfig).build());
        }

        /**
         * <p>
         * An object containing information about the job configuration for geomosaic.
         * </p>
         * 
         * @param geoMosaicConfig
         *        An object containing information about the job configuration for geomosaic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoMosaicConfig(GeoMosaicConfigInput geoMosaicConfig);

        /**
         * <p>
         * An object containing information about the job configuration for geomosaic.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeoMosaicConfigInput.Builder} avoiding
         * the need to create one manually via {@link GeoMosaicConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeoMosaicConfigInput.Builder#build()} is called immediately and
         * its result is passed to {@link #geoMosaicConfig(GeoMosaicConfigInput)}.
         * 
         * @param geoMosaicConfig
         *        a consumer that will call methods on {@link GeoMosaicConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoMosaicConfig(GeoMosaicConfigInput)
         */
        default Builder geoMosaicConfig(Consumer<GeoMosaicConfigInput.Builder> geoMosaicConfig) {
            return geoMosaicConfig(GeoMosaicConfigInput.builder().applyMutation(geoMosaicConfig).build());
        }

        /**
         * <p>
         * An object containing information about the job configuration for land cover segmentation.
         * </p>
         * 
         * @param landCoverSegmentationConfig
         *        An object containing information about the job configuration for land cover segmentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landCoverSegmentationConfig(LandCoverSegmentationConfigInput landCoverSegmentationConfig);

        /**
         * <p>
         * An object containing information about the job configuration for land cover segmentation.
         * </p>
         * This is a convenience method that creates an instance of the {@link LandCoverSegmentationConfigInput.Builder}
         * avoiding the need to create one manually via {@link LandCoverSegmentationConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LandCoverSegmentationConfigInput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #landCoverSegmentationConfig(LandCoverSegmentationConfigInput)}.
         * 
         * @param landCoverSegmentationConfig
         *        a consumer that will call methods on {@link LandCoverSegmentationConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #landCoverSegmentationConfig(LandCoverSegmentationConfigInput)
         */
        default Builder landCoverSegmentationConfig(Consumer<LandCoverSegmentationConfigInput.Builder> landCoverSegmentationConfig) {
            return landCoverSegmentationConfig(LandCoverSegmentationConfigInput.builder()
                    .applyMutation(landCoverSegmentationConfig).build());
        }

        /**
         * <p>
         * An object containing information about the job configuration for resampling.
         * </p>
         * 
         * @param resamplingConfig
         *        An object containing information about the job configuration for resampling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resamplingConfig(ResamplingConfigInput resamplingConfig);

        /**
         * <p>
         * An object containing information about the job configuration for resampling.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResamplingConfigInput.Builder} avoiding
         * the need to create one manually via {@link ResamplingConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResamplingConfigInput.Builder#build()} is called immediately and
         * its result is passed to {@link #resamplingConfig(ResamplingConfigInput)}.
         * 
         * @param resamplingConfig
         *        a consumer that will call methods on {@link ResamplingConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resamplingConfig(ResamplingConfigInput)
         */
        default Builder resamplingConfig(Consumer<ResamplingConfigInput.Builder> resamplingConfig) {
            return resamplingConfig(ResamplingConfigInput.builder().applyMutation(resamplingConfig).build());
        }

        /**
         * <p/>
         * 
         * @param stackConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackConfig(StackConfigInput stackConfig);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link StackConfigInput.Builder} avoiding the
         * need to create one manually via {@link StackConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StackConfigInput.Builder#build()} is called immediately and its
         * result is passed to {@link #stackConfig(StackConfigInput)}.
         * 
         * @param stackConfig
         *        a consumer that will call methods on {@link StackConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackConfig(StackConfigInput)
         */
        default Builder stackConfig(Consumer<StackConfigInput.Builder> stackConfig) {
            return stackConfig(StackConfigInput.builder().applyMutation(stackConfig).build());
        }

        /**
         * <p>
         * An object containing information about the job configuration for temporal statistics.
         * </p>
         * 
         * @param temporalStatisticsConfig
         *        An object containing information about the job configuration for temporal statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temporalStatisticsConfig(TemporalStatisticsConfigInput temporalStatisticsConfig);

        /**
         * <p>
         * An object containing information about the job configuration for temporal statistics.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemporalStatisticsConfigInput.Builder}
         * avoiding the need to create one manually via {@link TemporalStatisticsConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemporalStatisticsConfigInput.Builder#build()} is called
         * immediately and its result is passed to {@link #temporalStatisticsConfig(TemporalStatisticsConfigInput)}.
         * 
         * @param temporalStatisticsConfig
         *        a consumer that will call methods on {@link TemporalStatisticsConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #temporalStatisticsConfig(TemporalStatisticsConfigInput)
         */
        default Builder temporalStatisticsConfig(Consumer<TemporalStatisticsConfigInput.Builder> temporalStatisticsConfig) {
            return temporalStatisticsConfig(TemporalStatisticsConfigInput.builder().applyMutation(temporalStatisticsConfig)
                    .build());
        }

        /**
         * <p>
         * An object containing information about the job configuration for zonal statistics.
         * </p>
         * 
         * @param zonalStatisticsConfig
         *        An object containing information about the job configuration for zonal statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zonalStatisticsConfig(ZonalStatisticsConfigInput zonalStatisticsConfig);

        /**
         * <p>
         * An object containing information about the job configuration for zonal statistics.
         * </p>
         * This is a convenience method that creates an instance of the {@link ZonalStatisticsConfigInput.Builder}
         * avoiding the need to create one manually via {@link ZonalStatisticsConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ZonalStatisticsConfigInput.Builder#build()} is called immediately
         * and its result is passed to {@link #zonalStatisticsConfig(ZonalStatisticsConfigInput)}.
         * 
         * @param zonalStatisticsConfig
         *        a consumer that will call methods on {@link ZonalStatisticsConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zonalStatisticsConfig(ZonalStatisticsConfigInput)
         */
        default Builder zonalStatisticsConfig(Consumer<ZonalStatisticsConfigInput.Builder> zonalStatisticsConfig) {
            return zonalStatisticsConfig(ZonalStatisticsConfigInput.builder().applyMutation(zonalStatisticsConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BandMathConfigInput bandMathConfig;

        private CloudMaskingConfigInput cloudMaskingConfig;

        private CloudRemovalConfigInput cloudRemovalConfig;

        private GeoMosaicConfigInput geoMosaicConfig;

        private LandCoverSegmentationConfigInput landCoverSegmentationConfig;

        private ResamplingConfigInput resamplingConfig;

        private StackConfigInput stackConfig;

        private TemporalStatisticsConfigInput temporalStatisticsConfig;

        private ZonalStatisticsConfigInput zonalStatisticsConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobConfigInput model) {
            bandMathConfig(model.bandMathConfig);
            cloudMaskingConfig(model.cloudMaskingConfig);
            cloudRemovalConfig(model.cloudRemovalConfig);
            geoMosaicConfig(model.geoMosaicConfig);
            landCoverSegmentationConfig(model.landCoverSegmentationConfig);
            resamplingConfig(model.resamplingConfig);
            stackConfig(model.stackConfig);
            temporalStatisticsConfig(model.temporalStatisticsConfig);
            zonalStatisticsConfig(model.zonalStatisticsConfig);
        }

        public final BandMathConfigInput.Builder getBandMathConfig() {
            return bandMathConfig != null ? bandMathConfig.toBuilder() : null;
        }

        public final void setBandMathConfig(BandMathConfigInput.BuilderImpl bandMathConfig) {
            Object oldValue = this.bandMathConfig;
            this.bandMathConfig = bandMathConfig != null ? bandMathConfig.build() : null;
            handleUnionValueChange(Type.BAND_MATH_CONFIG, oldValue, this.bandMathConfig);
        }

        @Override
        public final Builder bandMathConfig(BandMathConfigInput bandMathConfig) {
            Object oldValue = this.bandMathConfig;
            this.bandMathConfig = bandMathConfig;
            handleUnionValueChange(Type.BAND_MATH_CONFIG, oldValue, this.bandMathConfig);
            return this;
        }

        public final CloudMaskingConfigInput.Builder getCloudMaskingConfig() {
            return cloudMaskingConfig != null ? cloudMaskingConfig.toBuilder() : null;
        }

        public final void setCloudMaskingConfig(CloudMaskingConfigInput.BuilderImpl cloudMaskingConfig) {
            Object oldValue = this.cloudMaskingConfig;
            this.cloudMaskingConfig = cloudMaskingConfig != null ? cloudMaskingConfig.build() : null;
            handleUnionValueChange(Type.CLOUD_MASKING_CONFIG, oldValue, this.cloudMaskingConfig);
        }

        @Override
        public final Builder cloudMaskingConfig(CloudMaskingConfigInput cloudMaskingConfig) {
            Object oldValue = this.cloudMaskingConfig;
            this.cloudMaskingConfig = cloudMaskingConfig;
            handleUnionValueChange(Type.CLOUD_MASKING_CONFIG, oldValue, this.cloudMaskingConfig);
            return this;
        }

        public final CloudRemovalConfigInput.Builder getCloudRemovalConfig() {
            return cloudRemovalConfig != null ? cloudRemovalConfig.toBuilder() : null;
        }

        public final void setCloudRemovalConfig(CloudRemovalConfigInput.BuilderImpl cloudRemovalConfig) {
            Object oldValue = this.cloudRemovalConfig;
            this.cloudRemovalConfig = cloudRemovalConfig != null ? cloudRemovalConfig.build() : null;
            handleUnionValueChange(Type.CLOUD_REMOVAL_CONFIG, oldValue, this.cloudRemovalConfig);
        }

        @Override
        public final Builder cloudRemovalConfig(CloudRemovalConfigInput cloudRemovalConfig) {
            Object oldValue = this.cloudRemovalConfig;
            this.cloudRemovalConfig = cloudRemovalConfig;
            handleUnionValueChange(Type.CLOUD_REMOVAL_CONFIG, oldValue, this.cloudRemovalConfig);
            return this;
        }

        public final GeoMosaicConfigInput.Builder getGeoMosaicConfig() {
            return geoMosaicConfig != null ? geoMosaicConfig.toBuilder() : null;
        }

        public final void setGeoMosaicConfig(GeoMosaicConfigInput.BuilderImpl geoMosaicConfig) {
            Object oldValue = this.geoMosaicConfig;
            this.geoMosaicConfig = geoMosaicConfig != null ? geoMosaicConfig.build() : null;
            handleUnionValueChange(Type.GEO_MOSAIC_CONFIG, oldValue, this.geoMosaicConfig);
        }

        @Override
        public final Builder geoMosaicConfig(GeoMosaicConfigInput geoMosaicConfig) {
            Object oldValue = this.geoMosaicConfig;
            this.geoMosaicConfig = geoMosaicConfig;
            handleUnionValueChange(Type.GEO_MOSAIC_CONFIG, oldValue, this.geoMosaicConfig);
            return this;
        }

        public final LandCoverSegmentationConfigInput.Builder getLandCoverSegmentationConfig() {
            return landCoverSegmentationConfig != null ? landCoverSegmentationConfig.toBuilder() : null;
        }

        public final void setLandCoverSegmentationConfig(LandCoverSegmentationConfigInput.BuilderImpl landCoverSegmentationConfig) {
            Object oldValue = this.landCoverSegmentationConfig;
            this.landCoverSegmentationConfig = landCoverSegmentationConfig != null ? landCoverSegmentationConfig.build() : null;
            handleUnionValueChange(Type.LAND_COVER_SEGMENTATION_CONFIG, oldValue, this.landCoverSegmentationConfig);
        }

        @Override
        public final Builder landCoverSegmentationConfig(LandCoverSegmentationConfigInput landCoverSegmentationConfig) {
            Object oldValue = this.landCoverSegmentationConfig;
            this.landCoverSegmentationConfig = landCoverSegmentationConfig;
            handleUnionValueChange(Type.LAND_COVER_SEGMENTATION_CONFIG, oldValue, this.landCoverSegmentationConfig);
            return this;
        }

        public final ResamplingConfigInput.Builder getResamplingConfig() {
            return resamplingConfig != null ? resamplingConfig.toBuilder() : null;
        }

        public final void setResamplingConfig(ResamplingConfigInput.BuilderImpl resamplingConfig) {
            Object oldValue = this.resamplingConfig;
            this.resamplingConfig = resamplingConfig != null ? resamplingConfig.build() : null;
            handleUnionValueChange(Type.RESAMPLING_CONFIG, oldValue, this.resamplingConfig);
        }

        @Override
        public final Builder resamplingConfig(ResamplingConfigInput resamplingConfig) {
            Object oldValue = this.resamplingConfig;
            this.resamplingConfig = resamplingConfig;
            handleUnionValueChange(Type.RESAMPLING_CONFIG, oldValue, this.resamplingConfig);
            return this;
        }

        public final StackConfigInput.Builder getStackConfig() {
            return stackConfig != null ? stackConfig.toBuilder() : null;
        }

        public final void setStackConfig(StackConfigInput.BuilderImpl stackConfig) {
            Object oldValue = this.stackConfig;
            this.stackConfig = stackConfig != null ? stackConfig.build() : null;
            handleUnionValueChange(Type.STACK_CONFIG, oldValue, this.stackConfig);
        }

        @Override
        public final Builder stackConfig(StackConfigInput stackConfig) {
            Object oldValue = this.stackConfig;
            this.stackConfig = stackConfig;
            handleUnionValueChange(Type.STACK_CONFIG, oldValue, this.stackConfig);
            return this;
        }

        public final TemporalStatisticsConfigInput.Builder getTemporalStatisticsConfig() {
            return temporalStatisticsConfig != null ? temporalStatisticsConfig.toBuilder() : null;
        }

        public final void setTemporalStatisticsConfig(TemporalStatisticsConfigInput.BuilderImpl temporalStatisticsConfig) {
            Object oldValue = this.temporalStatisticsConfig;
            this.temporalStatisticsConfig = temporalStatisticsConfig != null ? temporalStatisticsConfig.build() : null;
            handleUnionValueChange(Type.TEMPORAL_STATISTICS_CONFIG, oldValue, this.temporalStatisticsConfig);
        }

        @Override
        public final Builder temporalStatisticsConfig(TemporalStatisticsConfigInput temporalStatisticsConfig) {
            Object oldValue = this.temporalStatisticsConfig;
            this.temporalStatisticsConfig = temporalStatisticsConfig;
            handleUnionValueChange(Type.TEMPORAL_STATISTICS_CONFIG, oldValue, this.temporalStatisticsConfig);
            return this;
        }

        public final ZonalStatisticsConfigInput.Builder getZonalStatisticsConfig() {
            return zonalStatisticsConfig != null ? zonalStatisticsConfig.toBuilder() : null;
        }

        public final void setZonalStatisticsConfig(ZonalStatisticsConfigInput.BuilderImpl zonalStatisticsConfig) {
            Object oldValue = this.zonalStatisticsConfig;
            this.zonalStatisticsConfig = zonalStatisticsConfig != null ? zonalStatisticsConfig.build() : null;
            handleUnionValueChange(Type.ZONAL_STATISTICS_CONFIG, oldValue, this.zonalStatisticsConfig);
        }

        @Override
        public final Builder zonalStatisticsConfig(ZonalStatisticsConfigInput zonalStatisticsConfig) {
            Object oldValue = this.zonalStatisticsConfig;
            this.zonalStatisticsConfig = zonalStatisticsConfig;
            handleUnionValueChange(Type.ZONAL_STATISTICS_CONFIG, oldValue, this.zonalStatisticsConfig);
            return this;
        }

        @Override
        public JobConfigInput build() {
            return new JobConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see JobConfigInput#type()
     */
    public enum Type {
        BAND_MATH_CONFIG,

        CLOUD_MASKING_CONFIG,

        CLOUD_REMOVAL_CONFIG,

        GEO_MOSAIC_CONFIG,

        LAND_COVER_SEGMENTATION_CONFIG,

        RESAMPLING_CONFIG,

        STACK_CONFIG,

        TEMPORAL_STATISTICS_CONFIG,

        ZONAL_STATISTICS_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
