/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Properties implements SdkPojo, Serializable, ToCopyableBuilder<Properties.Builder, Properties> {
    private static final SdkField<Float> EO_CLOUD_COVER_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("EoCloudCover").getter(getter(Properties::eoCloudCover)).setter(setter(Builder::eoCloudCover))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EoCloudCover").build()).build();

    private static final SdkField<Float> LANDSAT_CLOUD_COVER_LAND_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("LandsatCloudCoverLand").getter(getter(Properties::landsatCloudCoverLand))
            .setter(setter(Builder::landsatCloudCoverLand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LandsatCloudCoverLand").build())
            .build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Platform").getter(getter(Properties::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<Float> VIEW_OFF_NADIR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("ViewOffNadir").getter(getter(Properties::viewOffNadir)).setter(setter(Builder::viewOffNadir))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewOffNadir").build()).build();

    private static final SdkField<Float> VIEW_SUN_AZIMUTH_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("ViewSunAzimuth").getter(getter(Properties::viewSunAzimuth)).setter(setter(Builder::viewSunAzimuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewSunAzimuth").build()).build();

    private static final SdkField<Float> VIEW_SUN_ELEVATION_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("ViewSunElevation").getter(getter(Properties::viewSunElevation))
            .setter(setter(Builder::viewSunElevation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewSunElevation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EO_CLOUD_COVER_FIELD,
            LANDSAT_CLOUD_COVER_LAND_FIELD, PLATFORM_FIELD, VIEW_OFF_NADIR_FIELD, VIEW_SUN_AZIMUTH_FIELD,
            VIEW_SUN_ELEVATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float eoCloudCover;

    private final Float landsatCloudCoverLand;

    private final String platform;

    private final Float viewOffNadir;

    private final Float viewSunAzimuth;

    private final Float viewSunElevation;

    private Properties(BuilderImpl builder) {
        this.eoCloudCover = builder.eoCloudCover;
        this.landsatCloudCoverLand = builder.landsatCloudCoverLand;
        this.platform = builder.platform;
        this.viewOffNadir = builder.viewOffNadir;
        this.viewSunAzimuth = builder.viewSunAzimuth;
        this.viewSunElevation = builder.viewSunElevation;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Float eoCloudCover() {
        return eoCloudCover;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Float landsatCloudCoverLand() {
        return landsatCloudCoverLand;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Float viewOffNadir() {
        return viewOffNadir;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Float viewSunAzimuth() {
        return viewSunAzimuth;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Float viewSunElevation() {
        return viewSunElevation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eoCloudCover());
        hashCode = 31 * hashCode + Objects.hashCode(landsatCloudCoverLand());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(viewOffNadir());
        hashCode = 31 * hashCode + Objects.hashCode(viewSunAzimuth());
        hashCode = 31 * hashCode + Objects.hashCode(viewSunElevation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Properties)) {
            return false;
        }
        Properties other = (Properties) obj;
        return Objects.equals(eoCloudCover(), other.eoCloudCover())
                && Objects.equals(landsatCloudCoverLand(), other.landsatCloudCoverLand())
                && Objects.equals(platform(), other.platform()) && Objects.equals(viewOffNadir(), other.viewOffNadir())
                && Objects.equals(viewSunAzimuth(), other.viewSunAzimuth())
                && Objects.equals(viewSunElevation(), other.viewSunElevation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Properties").add("EoCloudCover", eoCloudCover())
                .add("LandsatCloudCoverLand", landsatCloudCoverLand()).add("Platform", platform())
                .add("ViewOffNadir", viewOffNadir()).add("ViewSunAzimuth", viewSunAzimuth())
                .add("ViewSunElevation", viewSunElevation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EoCloudCover":
            return Optional.ofNullable(clazz.cast(eoCloudCover()));
        case "LandsatCloudCoverLand":
            return Optional.ofNullable(clazz.cast(landsatCloudCoverLand()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "ViewOffNadir":
            return Optional.ofNullable(clazz.cast(viewOffNadir()));
        case "ViewSunAzimuth":
            return Optional.ofNullable(clazz.cast(viewSunAzimuth()));
        case "ViewSunElevation":
            return Optional.ofNullable(clazz.cast(viewSunElevation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Properties, T> g) {
        return obj -> g.apply((Properties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Properties> {
        /**
         * <p/>
         * 
         * @param eoCloudCover
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eoCloudCover(Float eoCloudCover);

        /**
         * <p/>
         * 
         * @param landsatCloudCoverLand
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landsatCloudCoverLand(Float landsatCloudCoverLand);

        /**
         * <p/>
         * 
         * @param platform
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p/>
         * 
         * @param viewOffNadir
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewOffNadir(Float viewOffNadir);

        /**
         * <p/>
         * 
         * @param viewSunAzimuth
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewSunAzimuth(Float viewSunAzimuth);

        /**
         * <p/>
         * 
         * @param viewSunElevation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewSunElevation(Float viewSunElevation);
    }

    static final class BuilderImpl implements Builder {
        private Float eoCloudCover;

        private Float landsatCloudCoverLand;

        private String platform;

        private Float viewOffNadir;

        private Float viewSunAzimuth;

        private Float viewSunElevation;

        private BuilderImpl() {
        }

        private BuilderImpl(Properties model) {
            eoCloudCover(model.eoCloudCover);
            landsatCloudCoverLand(model.landsatCloudCoverLand);
            platform(model.platform);
            viewOffNadir(model.viewOffNadir);
            viewSunAzimuth(model.viewSunAzimuth);
            viewSunElevation(model.viewSunElevation);
        }

        public final Float getEoCloudCover() {
            return eoCloudCover;
        }

        public final void setEoCloudCover(Float eoCloudCover) {
            this.eoCloudCover = eoCloudCover;
        }

        @Override
        public final Builder eoCloudCover(Float eoCloudCover) {
            this.eoCloudCover = eoCloudCover;
            return this;
        }

        public final Float getLandsatCloudCoverLand() {
            return landsatCloudCoverLand;
        }

        public final void setLandsatCloudCoverLand(Float landsatCloudCoverLand) {
            this.landsatCloudCoverLand = landsatCloudCoverLand;
        }

        @Override
        public final Builder landsatCloudCoverLand(Float landsatCloudCoverLand) {
            this.landsatCloudCoverLand = landsatCloudCoverLand;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final Float getViewOffNadir() {
            return viewOffNadir;
        }

        public final void setViewOffNadir(Float viewOffNadir) {
            this.viewOffNadir = viewOffNadir;
        }

        @Override
        public final Builder viewOffNadir(Float viewOffNadir) {
            this.viewOffNadir = viewOffNadir;
            return this;
        }

        public final Float getViewSunAzimuth() {
            return viewSunAzimuth;
        }

        public final void setViewSunAzimuth(Float viewSunAzimuth) {
            this.viewSunAzimuth = viewSunAzimuth;
        }

        @Override
        public final Builder viewSunAzimuth(Float viewSunAzimuth) {
            this.viewSunAzimuth = viewSunAzimuth;
            return this;
        }

        public final Float getViewSunElevation() {
            return viewSunElevation;
        }

        public final void setViewSunElevation(Float viewSunElevation) {
            this.viewSunElevation = viewSunElevation;
        }

        @Override
        public final Builder viewSunElevation(Float viewSunElevation) {
            this.viewSunElevation = viewSunElevation;
            return this;
        }

        @Override
        public Properties build() {
            return new Properties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
