/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyFilter implements SdkPojo, Serializable, ToCopyableBuilder<PropertyFilter.Builder, PropertyFilter> {
    private static final SdkField<Property> PROPERTY_FIELD = SdkField.<Property> builder(MarshallingType.SDK_POJO)
            .memberName("Property").getter(getter(PropertyFilter::property)).setter(setter(Builder::property))
            .constructor(Property::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Property").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Property property;

    private PropertyFilter(BuilderImpl builder) {
        this.property = builder.property;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Property property() {
        return property;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(property());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyFilter)) {
            return false;
        }
        PropertyFilter other = (PropertyFilter) obj;
        return Objects.equals(property(), other.property());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyFilter").add("Property", property()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Property":
            return Optional.ofNullable(clazz.cast(property()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyFilter, T> g) {
        return obj -> g.apply((PropertyFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyFilter> {
        /**
         * <p/>
         * 
         * @param property
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder property(Property property);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link Property.Builder} avoiding the need to
         * create one manually via {@link Property#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Property.Builder#build()} is called immediately and its result is
         * passed to {@link #property(Property)}.
         * 
         * @param property
         *        a consumer that will call methods on {@link Property.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #property(Property)
         */
        default Builder property(Consumer<Property.Builder> property) {
            return property(Property.builder().applyMutation(property).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Property property;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyFilter model) {
            property(model.property);
        }

        public final Property.Builder getProperty() {
            return property != null ? property.toBuilder() : null;
        }

        public final void setProperty(Property.BuilderImpl property) {
            this.property = property != null ? property.build() : null;
        }

        @Override
        public final Builder property(Property property) {
            this.property = property;
            return this;
        }

        @Override
        public PropertyFilter build() {
            return new PropertyFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
