/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response object containing details for a specific RasterDataCollection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RasterDataCollectionMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<RasterDataCollectionMetadata.Builder, RasterDataCollectionMetadata> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(RasterDataCollectionMetadata::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RasterDataCollectionMetadata::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DESCRIPTION_PAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DescriptionPageUrl").getter(getter(RasterDataCollectionMetadata::descriptionPageUrl))
            .setter(setter(Builder::descriptionPageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DescriptionPageUrl").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RasterDataCollectionMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<Filter>> SUPPORTED_FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("SupportedFilters")
            .getter(getter(RasterDataCollectionMetadata::supportedFilters))
            .setter(setter(Builder::supportedFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(RasterDataCollectionMetadata::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RasterDataCollectionMetadata::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD,
            DESCRIPTION_PAGE_URL_FIELD, NAME_FIELD, SUPPORTED_FILTERS_FIELD, TAGS_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String description;

    private final String descriptionPageUrl;

    private final String name;

    private final List<Filter> supportedFilters;

    private final Map<String, String> tags;

    private final String type;

    private RasterDataCollectionMetadata(BuilderImpl builder) {
        this.arn = builder.arn;
        this.description = builder.description;
        this.descriptionPageUrl = builder.descriptionPageUrl;
        this.name = builder.name;
        this.supportedFilters = builder.supportedFilters;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the raster data collection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the raster data collection.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A description of the raster data collection.
     * </p>
     * 
     * @return A description of the raster data collection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The description URL of the raster data collection.
     * </p>
     * 
     * @return The description URL of the raster data collection.
     */
    public final String descriptionPageUrl() {
        return descriptionPageUrl;
    }

    /**
     * <p>
     * The name of the raster data collection.
     * </p>
     * 
     * @return The name of the raster data collection.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedFilters() {
        return supportedFilters != null && !(supportedFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedFilters} method.
     * </p>
     * 
     * @return
     */
    public final List<Filter> supportedFilters() {
        return supportedFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Each tag consists of a key and a value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Each tag consists of a key and a value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of raster data collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataCollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of raster data collection.
     * @see DataCollectionType
     */
    public final DataCollectionType type() {
        return DataCollectionType.fromValue(type);
    }

    /**
     * <p>
     * The type of raster data collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataCollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of raster data collection.
     * @see DataCollectionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(descriptionPageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedFilters() ? supportedFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RasterDataCollectionMetadata)) {
            return false;
        }
        RasterDataCollectionMetadata other = (RasterDataCollectionMetadata) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && Objects.equals(descriptionPageUrl(), other.descriptionPageUrl()) && Objects.equals(name(), other.name())
                && hasSupportedFilters() == other.hasSupportedFilters()
                && Objects.equals(supportedFilters(), other.supportedFilters()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RasterDataCollectionMetadata").add("Arn", arn()).add("Description", description())
                .add("DescriptionPageUrl", descriptionPageUrl()).add("Name", name())
                .add("SupportedFilters", hasSupportedFilters() ? supportedFilters() : null)
                .add("Tags", hasTags() ? tags() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DescriptionPageUrl":
            return Optional.ofNullable(clazz.cast(descriptionPageUrl()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SupportedFilters":
            return Optional.ofNullable(clazz.cast(supportedFilters()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RasterDataCollectionMetadata, T> g) {
        return obj -> g.apply((RasterDataCollectionMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RasterDataCollectionMetadata> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the raster data collection.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the raster data collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A description of the raster data collection.
         * </p>
         * 
         * @param description
         *        A description of the raster data collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The description URL of the raster data collection.
         * </p>
         * 
         * @param descriptionPageUrl
         *        The description URL of the raster data collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptionPageUrl(String descriptionPageUrl);

        /**
         * <p>
         * The name of the raster data collection.
         * </p>
         * 
         * @param name
         *        The name of the raster data collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p/>
         * 
         * @param supportedFilters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedFilters(Collection<Filter> supportedFilters);

        /**
         * <p/>
         * 
         * @param supportedFilters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedFilters(Filter... supportedFilters);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.Filter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemakergeospatial.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.Filter.Builder#build()} is called
         * immediately and its result is passed to {@link #supportedFilters(List<Filter>)}.
         * 
         * @param supportedFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakergeospatial.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedFilters(java.util.Collection<Filter>)
         */
        Builder supportedFilters(Consumer<Filter.Builder>... supportedFilters);

        /**
         * <p>
         * Each tag consists of a key and a value.
         * </p>
         * 
         * @param tags
         *        Each tag consists of a key and a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of raster data collection.
         * </p>
         * 
         * @param type
         *        The type of raster data collection.
         * @see DataCollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataCollectionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of raster data collection.
         * </p>
         * 
         * @param type
         *        The type of raster data collection.
         * @see DataCollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataCollectionType
         */
        Builder type(DataCollectionType type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String description;

        private String descriptionPageUrl;

        private String name;

        private List<Filter> supportedFilters = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RasterDataCollectionMetadata model) {
            arn(model.arn);
            description(model.description);
            descriptionPageUrl(model.descriptionPageUrl);
            name(model.name);
            supportedFilters(model.supportedFilters);
            tags(model.tags);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDescriptionPageUrl() {
            return descriptionPageUrl;
        }

        public final void setDescriptionPageUrl(String descriptionPageUrl) {
            this.descriptionPageUrl = descriptionPageUrl;
        }

        @Override
        public final Builder descriptionPageUrl(String descriptionPageUrl) {
            this.descriptionPageUrl = descriptionPageUrl;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Filter.Builder> getSupportedFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.supportedFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedFilters(Collection<Filter.BuilderImpl> supportedFilters) {
            this.supportedFilters = FilterListCopier.copyFromBuilder(supportedFilters);
        }

        @Override
        public final Builder supportedFilters(Collection<Filter> supportedFilters) {
            this.supportedFilters = FilterListCopier.copy(supportedFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFilters(Filter... supportedFilters) {
            supportedFilters(Arrays.asList(supportedFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFilters(Consumer<Filter.Builder>... supportedFilters) {
            supportedFilters(Stream.of(supportedFilters).map(c -> Filter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataCollectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RasterDataCollectionMetadata build() {
            return new RasterDataCollectionMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
