/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RasterDataCollectionQueryOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<RasterDataCollectionQueryOutput.Builder, RasterDataCollectionQueryOutput> {
    private static final SdkField<AreaOfInterest> AREA_OF_INTEREST_FIELD = SdkField
            .<AreaOfInterest> builder(MarshallingType.SDK_POJO).memberName("AreaOfInterest")
            .getter(getter(RasterDataCollectionQueryOutput::areaOfInterest)).setter(setter(Builder::areaOfInterest))
            .constructor(AreaOfInterest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AreaOfInterest").build()).build();

    private static final SdkField<PropertyFilters> PROPERTY_FILTERS_FIELD = SdkField
            .<PropertyFilters> builder(MarshallingType.SDK_POJO).memberName("PropertyFilters")
            .getter(getter(RasterDataCollectionQueryOutput::propertyFilters)).setter(setter(Builder::propertyFilters))
            .constructor(PropertyFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyFilters").build()).build();

    private static final SdkField<String> RASTER_DATA_COLLECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RasterDataCollectionArn").getter(getter(RasterDataCollectionQueryOutput::rasterDataCollectionArn))
            .setter(setter(Builder::rasterDataCollectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RasterDataCollectionArn").build())
            .build();

    private static final SdkField<String> RASTER_DATA_COLLECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RasterDataCollectionName").getter(getter(RasterDataCollectionQueryOutput::rasterDataCollectionName))
            .setter(setter(Builder::rasterDataCollectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RasterDataCollectionName").build())
            .build();

    private static final SdkField<TimeRangeFilterInput> TIME_RANGE_FILTER_FIELD = SdkField
            .<TimeRangeFilterInput> builder(MarshallingType.SDK_POJO).memberName("TimeRangeFilter")
            .getter(getter(RasterDataCollectionQueryOutput::timeRangeFilter)).setter(setter(Builder::timeRangeFilter))
            .constructor(TimeRangeFilterInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AREA_OF_INTEREST_FIELD, PROPERTY_FILTERS_FIELD, RASTER_DATA_COLLECTION_ARN_FIELD,
                    RASTER_DATA_COLLECTION_NAME_FIELD, TIME_RANGE_FILTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final AreaOfInterest areaOfInterest;

    private final PropertyFilters propertyFilters;

    private final String rasterDataCollectionArn;

    private final String rasterDataCollectionName;

    private final TimeRangeFilterInput timeRangeFilter;

    private RasterDataCollectionQueryOutput(BuilderImpl builder) {
        this.areaOfInterest = builder.areaOfInterest;
        this.propertyFilters = builder.propertyFilters;
        this.rasterDataCollectionArn = builder.rasterDataCollectionArn;
        this.rasterDataCollectionName = builder.rasterDataCollectionName;
        this.timeRangeFilter = builder.timeRangeFilter;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final AreaOfInterest areaOfInterest() {
        return areaOfInterest;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final PropertyFilters propertyFilters() {
        return propertyFilters;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String rasterDataCollectionArn() {
        return rasterDataCollectionArn;
    }

    /**
     * <p>
     * The name of the raster data collection.
     * </p>
     * 
     * @return The name of the raster data collection.
     */
    public final String rasterDataCollectionName() {
        return rasterDataCollectionName;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final TimeRangeFilterInput timeRangeFilter() {
        return timeRangeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(areaOfInterest());
        hashCode = 31 * hashCode + Objects.hashCode(propertyFilters());
        hashCode = 31 * hashCode + Objects.hashCode(rasterDataCollectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(rasterDataCollectionName());
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RasterDataCollectionQueryOutput)) {
            return false;
        }
        RasterDataCollectionQueryOutput other = (RasterDataCollectionQueryOutput) obj;
        return Objects.equals(areaOfInterest(), other.areaOfInterest())
                && Objects.equals(propertyFilters(), other.propertyFilters())
                && Objects.equals(rasterDataCollectionArn(), other.rasterDataCollectionArn())
                && Objects.equals(rasterDataCollectionName(), other.rasterDataCollectionName())
                && Objects.equals(timeRangeFilter(), other.timeRangeFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RasterDataCollectionQueryOutput").add("AreaOfInterest", areaOfInterest())
                .add("PropertyFilters", propertyFilters()).add("RasterDataCollectionArn", rasterDataCollectionArn())
                .add("RasterDataCollectionName", rasterDataCollectionName())
                .add("TimeRangeFilter", timeRangeFilter() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AreaOfInterest":
            return Optional.ofNullable(clazz.cast(areaOfInterest()));
        case "PropertyFilters":
            return Optional.ofNullable(clazz.cast(propertyFilters()));
        case "RasterDataCollectionArn":
            return Optional.ofNullable(clazz.cast(rasterDataCollectionArn()));
        case "RasterDataCollectionName":
            return Optional.ofNullable(clazz.cast(rasterDataCollectionName()));
        case "TimeRangeFilter":
            return Optional.ofNullable(clazz.cast(timeRangeFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RasterDataCollectionQueryOutput, T> g) {
        return obj -> g.apply((RasterDataCollectionQueryOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RasterDataCollectionQueryOutput> {
        /**
         * <p/>
         * 
         * @param areaOfInterest
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areaOfInterest(AreaOfInterest areaOfInterest);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link AreaOfInterest.Builder} avoiding the need
         * to create one manually via {@link AreaOfInterest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AreaOfInterest.Builder#build()} is called immediately and its
         * result is passed to {@link #areaOfInterest(AreaOfInterest)}.
         * 
         * @param areaOfInterest
         *        a consumer that will call methods on {@link AreaOfInterest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #areaOfInterest(AreaOfInterest)
         */
        default Builder areaOfInterest(Consumer<AreaOfInterest.Builder> areaOfInterest) {
            return areaOfInterest(AreaOfInterest.builder().applyMutation(areaOfInterest).build());
        }

        /**
         * <p/>
         * 
         * @param propertyFilters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyFilters(PropertyFilters propertyFilters);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link PropertyFilters.Builder} avoiding the
         * need to create one manually via {@link PropertyFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PropertyFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #propertyFilters(PropertyFilters)}.
         * 
         * @param propertyFilters
         *        a consumer that will call methods on {@link PropertyFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyFilters(PropertyFilters)
         */
        default Builder propertyFilters(Consumer<PropertyFilters.Builder> propertyFilters) {
            return propertyFilters(PropertyFilters.builder().applyMutation(propertyFilters).build());
        }

        /**
         * <p/>
         * 
         * @param rasterDataCollectionArn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rasterDataCollectionArn(String rasterDataCollectionArn);

        /**
         * <p>
         * The name of the raster data collection.
         * </p>
         * 
         * @param rasterDataCollectionName
         *        The name of the raster data collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rasterDataCollectionName(String rasterDataCollectionName);

        /**
         * <p/>
         * 
         * @param timeRangeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRangeFilter(TimeRangeFilterInput timeRangeFilter);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link TimeRangeFilterInput.Builder} avoiding
         * the need to create one manually via {@link TimeRangeFilterInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeRangeFilterInput.Builder#build()} is called immediately and
         * its result is passed to {@link #timeRangeFilter(TimeRangeFilterInput)}.
         * 
         * @param timeRangeFilter
         *        a consumer that will call methods on {@link TimeRangeFilterInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRangeFilter(TimeRangeFilterInput)
         */
        default Builder timeRangeFilter(Consumer<TimeRangeFilterInput.Builder> timeRangeFilter) {
            return timeRangeFilter(TimeRangeFilterInput.builder().applyMutation(timeRangeFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AreaOfInterest areaOfInterest;

        private PropertyFilters propertyFilters;

        private String rasterDataCollectionArn;

        private String rasterDataCollectionName;

        private TimeRangeFilterInput timeRangeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(RasterDataCollectionQueryOutput model) {
            areaOfInterest(model.areaOfInterest);
            propertyFilters(model.propertyFilters);
            rasterDataCollectionArn(model.rasterDataCollectionArn);
            rasterDataCollectionName(model.rasterDataCollectionName);
            timeRangeFilter(model.timeRangeFilter);
        }

        public final AreaOfInterest.Builder getAreaOfInterest() {
            return areaOfInterest != null ? areaOfInterest.toBuilder() : null;
        }

        public final void setAreaOfInterest(AreaOfInterest.BuilderImpl areaOfInterest) {
            this.areaOfInterest = areaOfInterest != null ? areaOfInterest.build() : null;
        }

        @Override
        public final Builder areaOfInterest(AreaOfInterest areaOfInterest) {
            this.areaOfInterest = areaOfInterest;
            return this;
        }

        public final PropertyFilters.Builder getPropertyFilters() {
            return propertyFilters != null ? propertyFilters.toBuilder() : null;
        }

        public final void setPropertyFilters(PropertyFilters.BuilderImpl propertyFilters) {
            this.propertyFilters = propertyFilters != null ? propertyFilters.build() : null;
        }

        @Override
        public final Builder propertyFilters(PropertyFilters propertyFilters) {
            this.propertyFilters = propertyFilters;
            return this;
        }

        public final String getRasterDataCollectionArn() {
            return rasterDataCollectionArn;
        }

        public final void setRasterDataCollectionArn(String rasterDataCollectionArn) {
            this.rasterDataCollectionArn = rasterDataCollectionArn;
        }

        @Override
        public final Builder rasterDataCollectionArn(String rasterDataCollectionArn) {
            this.rasterDataCollectionArn = rasterDataCollectionArn;
            return this;
        }

        public final String getRasterDataCollectionName() {
            return rasterDataCollectionName;
        }

        public final void setRasterDataCollectionName(String rasterDataCollectionName) {
            this.rasterDataCollectionName = rasterDataCollectionName;
        }

        @Override
        public final Builder rasterDataCollectionName(String rasterDataCollectionName) {
            this.rasterDataCollectionName = rasterDataCollectionName;
            return this;
        }

        public final TimeRangeFilterInput.Builder getTimeRangeFilter() {
            return timeRangeFilter != null ? timeRangeFilter.toBuilder() : null;
        }

        public final void setTimeRangeFilter(TimeRangeFilterInput.BuilderImpl timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter != null ? timeRangeFilter.build() : null;
        }

        @Override
        public final Builder timeRangeFilter(TimeRangeFilterInput timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
            return this;
        }

        @Override
        public RasterDataCollectionQueryOutput build() {
            return new RasterDataCollectionQueryOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
