/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResamplingConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ResamplingConfigInput.Builder, ResamplingConfigInput> {
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlgorithmName").getter(getter(ResamplingConfigInput::algorithmNameAsString))
            .setter(setter(Builder::algorithmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()).build();

    private static final SdkField<OutputResolutionResamplingInput> OUTPUT_RESOLUTION_FIELD = SdkField
            .<OutputResolutionResamplingInput> builder(MarshallingType.SDK_POJO).memberName("OutputResolution")
            .getter(getter(ResamplingConfigInput::outputResolution)).setter(setter(Builder::outputResolution))
            .constructor(OutputResolutionResamplingInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputResolution").build()).build();

    private static final SdkField<List<String>> TARGET_BANDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetBands")
            .getter(getter(ResamplingConfigInput::targetBands))
            .setter(setter(Builder::targetBands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_NAME_FIELD,
            OUTPUT_RESOLUTION_FIELD, TARGET_BANDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String algorithmName;

    private final OutputResolutionResamplingInput outputResolution;

    private final List<String> targetBands;

    private ResamplingConfigInput(BuilderImpl builder) {
        this.algorithmName = builder.algorithmName;
        this.outputResolution = builder.outputResolution;
        this.targetBands = builder.targetBands;
    }

    /**
     * <p>
     * The name of the algorithm used for resampling.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithmName}
     * will return {@link AlgorithmNameResampling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #algorithmNameAsString}.
     * </p>
     * 
     * @return The name of the algorithm used for resampling.
     * @see AlgorithmNameResampling
     */
    public final AlgorithmNameResampling algorithmName() {
        return AlgorithmNameResampling.fromValue(algorithmName);
    }

    /**
     * <p>
     * The name of the algorithm used for resampling.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithmName}
     * will return {@link AlgorithmNameResampling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #algorithmNameAsString}.
     * </p>
     * 
     * @return The name of the algorithm used for resampling.
     * @see AlgorithmNameResampling
     */
    public final String algorithmNameAsString() {
        return algorithmName;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final OutputResolutionResamplingInput outputResolution() {
        return outputResolution;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetBands property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetBands() {
        return targetBands != null && !(targetBands instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetBands} method.
     * </p>
     * 
     * @return
     */
    public final List<String> targetBands() {
        return targetBands;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(algorithmNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputResolution());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetBands() ? targetBands() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResamplingConfigInput)) {
            return false;
        }
        ResamplingConfigInput other = (ResamplingConfigInput) obj;
        return Objects.equals(algorithmNameAsString(), other.algorithmNameAsString())
                && Objects.equals(outputResolution(), other.outputResolution()) && hasTargetBands() == other.hasTargetBands()
                && Objects.equals(targetBands(), other.targetBands());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResamplingConfigInput").add("AlgorithmName", algorithmNameAsString())
                .add("OutputResolution", outputResolution()).add("TargetBands", hasTargetBands() ? targetBands() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlgorithmName":
            return Optional.ofNullable(clazz.cast(algorithmNameAsString()));
        case "OutputResolution":
            return Optional.ofNullable(clazz.cast(outputResolution()));
        case "TargetBands":
            return Optional.ofNullable(clazz.cast(targetBands()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResamplingConfigInput, T> g) {
        return obj -> g.apply((ResamplingConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResamplingConfigInput> {
        /**
         * <p>
         * The name of the algorithm used for resampling.
         * </p>
         * 
         * @param algorithmName
         *        The name of the algorithm used for resampling.
         * @see AlgorithmNameResampling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmNameResampling
         */
        Builder algorithmName(String algorithmName);

        /**
         * <p>
         * The name of the algorithm used for resampling.
         * </p>
         * 
         * @param algorithmName
         *        The name of the algorithm used for resampling.
         * @see AlgorithmNameResampling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmNameResampling
         */
        Builder algorithmName(AlgorithmNameResampling algorithmName);

        /**
         * <p/>
         * 
         * @param outputResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputResolution(OutputResolutionResamplingInput outputResolution);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link OutputResolutionResamplingInput.Builder}
         * avoiding the need to create one manually via {@link OutputResolutionResamplingInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputResolutionResamplingInput.Builder#build()} is called
         * immediately and its result is passed to {@link #outputResolution(OutputResolutionResamplingInput)}.
         * 
         * @param outputResolution
         *        a consumer that will call methods on {@link OutputResolutionResamplingInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputResolution(OutputResolutionResamplingInput)
         */
        default Builder outputResolution(Consumer<OutputResolutionResamplingInput.Builder> outputResolution) {
            return outputResolution(OutputResolutionResamplingInput.builder().applyMutation(outputResolution).build());
        }

        /**
         * <p/>
         * 
         * @param targetBands
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBands(Collection<String> targetBands);

        /**
         * <p/>
         * 
         * @param targetBands
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBands(String... targetBands);
    }

    static final class BuilderImpl implements Builder {
        private String algorithmName;

        private OutputResolutionResamplingInput outputResolution;

        private List<String> targetBands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResamplingConfigInput model) {
            algorithmName(model.algorithmName);
            outputResolution(model.outputResolution);
            targetBands(model.targetBands);
        }

        public final String getAlgorithmName() {
            return algorithmName;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        @Override
        public final Builder algorithmName(AlgorithmNameResampling algorithmName) {
            this.algorithmName(algorithmName == null ? null : algorithmName.toString());
            return this;
        }

        public final OutputResolutionResamplingInput.Builder getOutputResolution() {
            return outputResolution != null ? outputResolution.toBuilder() : null;
        }

        public final void setOutputResolution(OutputResolutionResamplingInput.BuilderImpl outputResolution) {
            this.outputResolution = outputResolution != null ? outputResolution.build() : null;
        }

        @Override
        public final Builder outputResolution(OutputResolutionResamplingInput outputResolution) {
            this.outputResolution = outputResolution;
            return this;
        }

        public final Collection<String> getTargetBands() {
            if (targetBands instanceof SdkAutoConstructList) {
                return null;
            }
            return targetBands;
        }

        public final void setTargetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
        }

        @Override
        public final Builder targetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBands(String... targetBands) {
            targetBands(Arrays.asList(targetBands));
            return this;
        }

        @Override
        public ResamplingConfigInput build() {
            return new ResamplingConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
