/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Path to Amazon S3 storage location for input data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3DataInput implements SdkPojo, Serializable, ToCopyableBuilder<S3DataInput.Builder, S3DataInput> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(S3DataInput::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> METADATA_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataProvider").getter(getter(S3DataInput::metadataProviderAsString))
            .setter(setter(Builder::metadataProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProvider").build()).build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(S3DataInput::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            METADATA_PROVIDER_FIELD, S3_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final String metadataProvider;

    private final String s3Uri;

    private S3DataInput(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.metadataProvider = builder.metadataProvider;
        this.s3Uri = builder.s3Uri;
    }

    /**
     * <p>
     * The Key Management Service key ID for server-side encryption.
     * </p>
     * 
     * @return The Key Management Service key ID for server-side encryption.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Metadata provider from whom the Amazon S3 data has been acquired.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metadataProvider}
     * will return {@link MetadataProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metadataProviderAsString}.
     * </p>
     * 
     * @return Metadata provider from whom the Amazon S3 data has been acquired.
     * @see MetadataProvider
     */
    public final MetadataProvider metadataProvider() {
        return MetadataProvider.fromValue(metadataProvider);
    }

    /**
     * <p>
     * Metadata provider from whom the Amazon S3 data has been acquired.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metadataProvider}
     * will return {@link MetadataProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metadataProviderAsString}.
     * </p>
     * 
     * @return Metadata provider from whom the Amazon S3 data has been acquired.
     * @see MetadataProvider
     */
    public final String metadataProviderAsString() {
        return metadataProvider;
    }

    /**
     * <p>
     * The URL to the Amazon S3 input.
     * </p>
     * 
     * @return The URL to the Amazon S3 input.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(metadataProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataInput)) {
            return false;
        }
        S3DataInput other = (S3DataInput) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(metadataProviderAsString(), other.metadataProviderAsString())
                && Objects.equals(s3Uri(), other.s3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3DataInput").add("KmsKeyId", kmsKeyId()).add("MetadataProvider", metadataProviderAsString())
                .add("S3Uri", s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "MetadataProvider":
            return Optional.ofNullable(clazz.cast(metadataProviderAsString()));
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DataInput, T> g) {
        return obj -> g.apply((S3DataInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3DataInput> {
        /**
         * <p>
         * The Key Management Service key ID for server-side encryption.
         * </p>
         * 
         * @param kmsKeyId
         *        The Key Management Service key ID for server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Metadata provider from whom the Amazon S3 data has been acquired.
         * </p>
         * 
         * @param metadataProvider
         *        Metadata provider from whom the Amazon S3 data has been acquired.
         * @see MetadataProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataProvider
         */
        Builder metadataProvider(String metadataProvider);

        /**
         * <p>
         * Metadata provider from whom the Amazon S3 data has been acquired.
         * </p>
         * 
         * @param metadataProvider
         *        Metadata provider from whom the Amazon S3 data has been acquired.
         * @see MetadataProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataProvider
         */
        Builder metadataProvider(MetadataProvider metadataProvider);

        /**
         * <p>
         * The URL to the Amazon S3 input.
         * </p>
         * 
         * @param s3Uri
         *        The URL to the Amazon S3 input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private String metadataProvider;

        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataInput model) {
            kmsKeyId(model.kmsKeyId);
            metadataProvider(model.metadataProvider);
            s3Uri(model.s3Uri);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getMetadataProvider() {
            return metadataProvider;
        }

        public final void setMetadataProvider(String metadataProvider) {
            this.metadataProvider = metadataProvider;
        }

        @Override
        public final Builder metadataProvider(String metadataProvider) {
            this.metadataProvider = metadataProvider;
            return this;
        }

        @Override
        public final Builder metadataProvider(MetadataProvider metadataProvider) {
            this.metadataProvider(metadataProvider == null ? null : metadataProvider.toString());
            return this;
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        @Override
        public S3DataInput build() {
            return new S3DataInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
