/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVectorEnrichmentJobsResponse extends SageMakerGeospatialResponse implements
        ToCopyableBuilder<ListVectorEnrichmentJobsResponse.Builder, ListVectorEnrichmentJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListVectorEnrichmentJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ListVectorEnrichmentJobOutputConfig>> VECTOR_ENRICHMENT_JOB_SUMMARIES_FIELD = SdkField
            .<List<ListVectorEnrichmentJobOutputConfig>> builder(MarshallingType.LIST)
            .memberName("VectorEnrichmentJobSummaries")
            .getter(getter(ListVectorEnrichmentJobsResponse::vectorEnrichmentJobSummaries))
            .setter(setter(Builder::vectorEnrichmentJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VectorEnrichmentJobSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListVectorEnrichmentJobOutputConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListVectorEnrichmentJobOutputConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VECTOR_ENRICHMENT_JOB_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<ListVectorEnrichmentJobOutputConfig> vectorEnrichmentJobSummaries;

    private ListVectorEnrichmentJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vectorEnrichmentJobSummaries = builder.vectorEnrichmentJobSummaries;
    }

    /**
     * <p>
     * If the previous response was truncated, you receive this token. Use it in your next request to receive the next
     * set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you receive this token. Use it in your next request to receive
     *         the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VectorEnrichmentJobSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVectorEnrichmentJobSummaries() {
        return vectorEnrichmentJobSummaries != null && !(vectorEnrichmentJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains summary information about the Vector Enrichment jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVectorEnrichmentJobSummaries} method.
     * </p>
     * 
     * @return Contains summary information about the Vector Enrichment jobs.
     */
    public final List<ListVectorEnrichmentJobOutputConfig> vectorEnrichmentJobSummaries() {
        return vectorEnrichmentJobSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVectorEnrichmentJobSummaries() ? vectorEnrichmentJobSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVectorEnrichmentJobsResponse)) {
            return false;
        }
        ListVectorEnrichmentJobsResponse other = (ListVectorEnrichmentJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasVectorEnrichmentJobSummaries() == other.hasVectorEnrichmentJobSummaries()
                && Objects.equals(vectorEnrichmentJobSummaries(), other.vectorEnrichmentJobSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVectorEnrichmentJobsResponse")
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VectorEnrichmentJobSummaries", hasVectorEnrichmentJobSummaries() ? vectorEnrichmentJobSummaries() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "VectorEnrichmentJobSummaries":
            return Optional.ofNullable(clazz.cast(vectorEnrichmentJobSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVectorEnrichmentJobsResponse, T> g) {
        return obj -> g.apply((ListVectorEnrichmentJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerGeospatialResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVectorEnrichmentJobsResponse> {
        /**
         * <p>
         * If the previous response was truncated, you receive this token. Use it in your next request to receive the
         * next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you receive this token. Use it in your next request to receive
         *        the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Contains summary information about the Vector Enrichment jobs.
         * </p>
         * 
         * @param vectorEnrichmentJobSummaries
         *        Contains summary information about the Vector Enrichment jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorEnrichmentJobSummaries(Collection<ListVectorEnrichmentJobOutputConfig> vectorEnrichmentJobSummaries);

        /**
         * <p>
         * Contains summary information about the Vector Enrichment jobs.
         * </p>
         * 
         * @param vectorEnrichmentJobSummaries
         *        Contains summary information about the Vector Enrichment jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorEnrichmentJobSummaries(ListVectorEnrichmentJobOutputConfig... vectorEnrichmentJobSummaries);

        /**
         * <p>
         * Contains summary information about the Vector Enrichment jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #vectorEnrichmentJobSummaries(List<ListVectorEnrichmentJobOutputConfig>)}.
         * 
         * @param vectorEnrichmentJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectorEnrichmentJobSummaries(java.util.Collection<ListVectorEnrichmentJobOutputConfig>)
         */
        Builder vectorEnrichmentJobSummaries(
                Consumer<ListVectorEnrichmentJobOutputConfig.Builder>... vectorEnrichmentJobSummaries);
    }

    static final class BuilderImpl extends SageMakerGeospatialResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListVectorEnrichmentJobOutputConfig> vectorEnrichmentJobSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVectorEnrichmentJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            vectorEnrichmentJobSummaries(model.vectorEnrichmentJobSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListVectorEnrichmentJobOutputConfig.Builder> getVectorEnrichmentJobSummaries() {
            List<ListVectorEnrichmentJobOutputConfig.Builder> result = VectorEnrichmentJobListCopier
                    .copyToBuilder(this.vectorEnrichmentJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVectorEnrichmentJobSummaries(
                Collection<ListVectorEnrichmentJobOutputConfig.BuilderImpl> vectorEnrichmentJobSummaries) {
            this.vectorEnrichmentJobSummaries = VectorEnrichmentJobListCopier.copyFromBuilder(vectorEnrichmentJobSummaries);
        }

        @Override
        public final Builder vectorEnrichmentJobSummaries(
                Collection<ListVectorEnrichmentJobOutputConfig> vectorEnrichmentJobSummaries) {
            this.vectorEnrichmentJobSummaries = VectorEnrichmentJobListCopier.copy(vectorEnrichmentJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectorEnrichmentJobSummaries(ListVectorEnrichmentJobOutputConfig... vectorEnrichmentJobSummaries) {
            vectorEnrichmentJobSummaries(Arrays.asList(vectorEnrichmentJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectorEnrichmentJobSummaries(
                Consumer<ListVectorEnrichmentJobOutputConfig.Builder>... vectorEnrichmentJobSummaries) {
            vectorEnrichmentJobSummaries(Stream.of(vectorEnrichmentJobSummaries)
                    .map(c -> ListVectorEnrichmentJobOutputConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVectorEnrichmentJobsResponse build() {
            return new ListVectorEnrichmentJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
