/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input structure for the BandMath operation type. Defines Predefined and CustomIndices to be computed using BandMath.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BandMathConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<BandMathConfigInput.Builder, BandMathConfigInput> {
    private static final SdkField<CustomIndicesInput> CUSTOM_INDICES_FIELD = SdkField
            .<CustomIndicesInput> builder(MarshallingType.SDK_POJO).memberName("CustomIndices")
            .getter(getter(BandMathConfigInput::customIndices)).setter(setter(Builder::customIndices))
            .constructor(CustomIndicesInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomIndices").build()).build();

    private static final SdkField<List<String>> PREDEFINED_INDICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PredefinedIndices")
            .getter(getter(BandMathConfigInput::predefinedIndices))
            .setter(setter(Builder::predefinedIndices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedIndices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_INDICES_FIELD,
            PREDEFINED_INDICES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomIndicesInput customIndices;

    private final List<String> predefinedIndices;

    private BandMathConfigInput(BuilderImpl builder) {
        this.customIndices = builder.customIndices;
        this.predefinedIndices = builder.predefinedIndices;
    }

    /**
     * <p>
     * CustomIndices that are computed.
     * </p>
     * 
     * @return CustomIndices that are computed.
     */
    public final CustomIndicesInput customIndices() {
        return customIndices;
    }

    /**
     * For responses, this returns true if the service returned a value for the PredefinedIndices property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPredefinedIndices() {
        return predefinedIndices != null && !(predefinedIndices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or many of the supported predefined indices to compute. Allowed values: <code>NDVI</code>, <code>EVI2</code>,
     * <code>MSAVI</code>, <code>NDWI</code>, <code>NDMI</code>, <code>NDSI</code>, and <code>WDRVI</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPredefinedIndices} method.
     * </p>
     * 
     * @return One or many of the supported predefined indices to compute. Allowed values: <code>NDVI</code>,
     *         <code>EVI2</code>, <code>MSAVI</code>, <code>NDWI</code>, <code>NDMI</code>, <code>NDSI</code>, and
     *         <code>WDRVI</code>.
     */
    public final List<String> predefinedIndices() {
        return predefinedIndices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customIndices());
        hashCode = 31 * hashCode + Objects.hashCode(hasPredefinedIndices() ? predefinedIndices() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BandMathConfigInput)) {
            return false;
        }
        BandMathConfigInput other = (BandMathConfigInput) obj;
        return Objects.equals(customIndices(), other.customIndices()) && hasPredefinedIndices() == other.hasPredefinedIndices()
                && Objects.equals(predefinedIndices(), other.predefinedIndices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BandMathConfigInput").add("CustomIndices", customIndices())
                .add("PredefinedIndices", hasPredefinedIndices() ? predefinedIndices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomIndices":
            return Optional.ofNullable(clazz.cast(customIndices()));
        case "PredefinedIndices":
            return Optional.ofNullable(clazz.cast(predefinedIndices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomIndices", CUSTOM_INDICES_FIELD);
        map.put("PredefinedIndices", PREDEFINED_INDICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BandMathConfigInput, T> g) {
        return obj -> g.apply((BandMathConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BandMathConfigInput> {
        /**
         * <p>
         * CustomIndices that are computed.
         * </p>
         * 
         * @param customIndices
         *        CustomIndices that are computed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customIndices(CustomIndicesInput customIndices);

        /**
         * <p>
         * CustomIndices that are computed.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomIndicesInput.Builder} avoiding the
         * need to create one manually via {@link CustomIndicesInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomIndicesInput.Builder#build()} is called immediately and its
         * result is passed to {@link #customIndices(CustomIndicesInput)}.
         * 
         * @param customIndices
         *        a consumer that will call methods on {@link CustomIndicesInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customIndices(CustomIndicesInput)
         */
        default Builder customIndices(Consumer<CustomIndicesInput.Builder> customIndices) {
            return customIndices(CustomIndicesInput.builder().applyMutation(customIndices).build());
        }

        /**
         * <p>
         * One or many of the supported predefined indices to compute. Allowed values: <code>NDVI</code>,
         * <code>EVI2</code>, <code>MSAVI</code>, <code>NDWI</code>, <code>NDMI</code>, <code>NDSI</code>, and
         * <code>WDRVI</code>.
         * </p>
         * 
         * @param predefinedIndices
         *        One or many of the supported predefined indices to compute. Allowed values: <code>NDVI</code>,
         *        <code>EVI2</code>, <code>MSAVI</code>, <code>NDWI</code>, <code>NDMI</code>, <code>NDSI</code>, and
         *        <code>WDRVI</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedIndices(Collection<String> predefinedIndices);

        /**
         * <p>
         * One or many of the supported predefined indices to compute. Allowed values: <code>NDVI</code>,
         * <code>EVI2</code>, <code>MSAVI</code>, <code>NDWI</code>, <code>NDMI</code>, <code>NDSI</code>, and
         * <code>WDRVI</code>.
         * </p>
         * 
         * @param predefinedIndices
         *        One or many of the supported predefined indices to compute. Allowed values: <code>NDVI</code>,
         *        <code>EVI2</code>, <code>MSAVI</code>, <code>NDWI</code>, <code>NDMI</code>, <code>NDSI</code>, and
         *        <code>WDRVI</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedIndices(String... predefinedIndices);
    }

    static final class BuilderImpl implements Builder {
        private CustomIndicesInput customIndices;

        private List<String> predefinedIndices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BandMathConfigInput model) {
            customIndices(model.customIndices);
            predefinedIndices(model.predefinedIndices);
        }

        public final CustomIndicesInput.Builder getCustomIndices() {
            return customIndices != null ? customIndices.toBuilder() : null;
        }

        public final void setCustomIndices(CustomIndicesInput.BuilderImpl customIndices) {
            this.customIndices = customIndices != null ? customIndices.build() : null;
        }

        @Override
        public final Builder customIndices(CustomIndicesInput customIndices) {
            this.customIndices = customIndices;
            return this;
        }

        public final Collection<String> getPredefinedIndices() {
            if (predefinedIndices instanceof SdkAutoConstructList) {
                return null;
            }
            return predefinedIndices;
        }

        public final void setPredefinedIndices(Collection<String> predefinedIndices) {
            this.predefinedIndices = StringListInputCopier.copy(predefinedIndices);
        }

        @Override
        public final Builder predefinedIndices(Collection<String> predefinedIndices) {
            this.predefinedIndices = StringListInputCopier.copy(predefinedIndices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predefinedIndices(String... predefinedIndices) {
            predefinedIndices(Arrays.asList(predefinedIndices));
            return this;
        }

        @Override
        public BandMathConfigInput build() {
            return new BandMathConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
