/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportEarthObservationJobRequest extends SageMakerGeospatialRequest implements
        ToCopyableBuilder<ExportEarthObservationJobRequest.Builder, ExportEarthObservationJobRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ExportEarthObservationJobRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ExportEarthObservationJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(ExportEarthObservationJobRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<Boolean> EXPORT_SOURCE_IMAGES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExportSourceImages").getter(getter(ExportEarthObservationJobRequest::exportSourceImages))
            .setter(setter(Builder::exportSourceImages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSourceImages").build())
            .build();

    private static final SdkField<OutputConfigInput> OUTPUT_CONFIG_FIELD = SdkField
            .<OutputConfigInput> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(ExportEarthObservationJobRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(OutputConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CLIENT_TOKEN_FIELD,
            EXECUTION_ROLE_ARN_FIELD, EXPORT_SOURCE_IMAGES_FIELD, OUTPUT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String clientToken;

    private final String executionRoleArn;

    private final Boolean exportSourceImages;

    private final OutputConfigInput outputConfig;

    private ExportEarthObservationJobRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.executionRoleArn = builder.executionRoleArn;
        this.exportSourceImages = builder.exportSourceImages;
        this.outputConfig = builder.outputConfig;
    }

    /**
     * <p>
     * The input Amazon Resource Name (ARN) of the Earth Observation job being exported.
     * </p>
     * 
     * @return The input Amazon Resource Name (ARN) of the Earth Observation job being exported.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A unique token that guarantees that the call to this API is idempotent.
     * </p>
     * 
     * @return A unique token that guarantees that the call to this API is idempotent.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The source images provided to the Earth Observation job being exported.
     * </p>
     * 
     * @return The source images provided to the Earth Observation job being exported.
     */
    public final Boolean exportSourceImages() {
        return exportSourceImages;
    }

    /**
     * <p>
     * An object containing information about the output file.
     * </p>
     * 
     * @return An object containing information about the output file.
     */
    public final OutputConfigInput outputConfig() {
        return outputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(exportSourceImages());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportEarthObservationJobRequest)) {
            return false;
        }
        ExportEarthObservationJobRequest other = (ExportEarthObservationJobRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(exportSourceImages(), other.exportSourceImages())
                && Objects.equals(outputConfig(), other.outputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportEarthObservationJobRequest").add("Arn", arn()).add("ClientToken", clientToken())
                .add("ExecutionRoleArn", executionRoleArn()).add("ExportSourceImages", exportSourceImages())
                .add("OutputConfig", outputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "ExportSourceImages":
            return Optional.ofNullable(clazz.cast(exportSourceImages()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("ExportSourceImages", EXPORT_SOURCE_IMAGES_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportEarthObservationJobRequest, T> g) {
        return obj -> g.apply((ExportEarthObservationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerGeospatialRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportEarthObservationJobRequest> {
        /**
         * <p>
         * The input Amazon Resource Name (ARN) of the Earth Observation job being exported.
         * </p>
         * 
         * @param arn
         *        The input Amazon Resource Name (ARN) of the Earth Observation job being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A unique token that guarantees that the call to this API is idempotent.
         * </p>
         * 
         * @param clientToken
         *        A unique token that guarantees that the call to this API is idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The source images provided to the Earth Observation job being exported.
         * </p>
         * 
         * @param exportSourceImages
         *        The source images provided to the Earth Observation job being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportSourceImages(Boolean exportSourceImages);

        /**
         * <p>
         * An object containing information about the output file.
         * </p>
         * 
         * @param outputConfig
         *        An object containing information about the output file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfigInput outputConfig);

        /**
         * <p>
         * An object containing information about the output file.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputConfigInput.Builder} avoiding the
         * need to create one manually via {@link OutputConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConfigInput.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfigInput)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfigInput)
         */
        default Builder outputConfig(Consumer<OutputConfigInput.Builder> outputConfig) {
            return outputConfig(OutputConfigInput.builder().applyMutation(outputConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerGeospatialRequest.BuilderImpl implements Builder {
        private String arn;

        private String clientToken;

        private String executionRoleArn;

        private Boolean exportSourceImages;

        private OutputConfigInput outputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportEarthObservationJobRequest model) {
            super(model);
            arn(model.arn);
            clientToken(model.clientToken);
            executionRoleArn(model.executionRoleArn);
            exportSourceImages(model.exportSourceImages);
            outputConfig(model.outputConfig);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final Boolean getExportSourceImages() {
            return exportSourceImages;
        }

        public final void setExportSourceImages(Boolean exportSourceImages) {
            this.exportSourceImages = exportSourceImages;
        }

        @Override
        public final Builder exportSourceImages(Boolean exportSourceImages) {
            this.exportSourceImages = exportSourceImages;
            return this;
        }

        public final OutputConfigInput.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfigInput.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfigInput outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportEarthObservationJobRequest build() {
            return new ExportEarthObservationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
