/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportVectorEnrichmentJobResponse extends SageMakerGeospatialResponse implements
        ToCopyableBuilder<ExportVectorEnrichmentJobResponse.Builder, ExportVectorEnrichmentJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ExportVectorEnrichmentJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(ExportVectorEnrichmentJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(ExportVectorEnrichmentJobResponse::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportStatus").getter(getter(ExportVectorEnrichmentJobResponse::exportStatusAsString))
            .setter(setter(Builder::exportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()).build();

    private static final SdkField<ExportVectorEnrichmentJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<ExportVectorEnrichmentJobOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(ExportVectorEnrichmentJobResponse::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(ExportVectorEnrichmentJobOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, EXECUTION_ROLE_ARN_FIELD, EXPORT_STATUS_FIELD, OUTPUT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final Instant creationTime;

    private final String executionRoleArn;

    private final String exportStatus;

    private final ExportVectorEnrichmentJobOutputConfig outputConfig;

    private ExportVectorEnrichmentJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.executionRoleArn = builder.executionRoleArn;
        this.exportStatus = builder.exportStatus;
        this.outputConfig = builder.outputConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Vector Enrichment job being exported.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Vector Enrichment job being exported.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role with permission to upload to the location in OutputConfig.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role with permission to upload to the location in OutputConfig.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The status of the results the Vector Enrichment job being exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link VectorEnrichmentJobExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The status of the results the Vector Enrichment job being exported.
     * @see VectorEnrichmentJobExportStatus
     */
    public final VectorEnrichmentJobExportStatus exportStatus() {
        return VectorEnrichmentJobExportStatus.fromValue(exportStatus);
    }

    /**
     * <p>
     * The status of the results the Vector Enrichment job being exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link VectorEnrichmentJobExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The status of the results the Vector Enrichment job being exported.
     * @see VectorEnrichmentJobExportStatus
     */
    public final String exportStatusAsString() {
        return exportStatus;
    }

    /**
     * <p>
     * Output location information for exporting Vector Enrichment Job results.
     * </p>
     * 
     * @return Output location information for exporting Vector Enrichment Job results.
     */
    public final ExportVectorEnrichmentJobOutputConfig outputConfig() {
        return outputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportVectorEnrichmentJobResponse)) {
            return false;
        }
        ExportVectorEnrichmentJobResponse other = (ExportVectorEnrichmentJobResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(exportStatusAsString(), other.exportStatusAsString())
                && Objects.equals(outputConfig(), other.outputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportVectorEnrichmentJobResponse").add("Arn", arn()).add("CreationTime", creationTime())
                .add("ExecutionRoleArn", executionRoleArn()).add("ExportStatus", exportStatusAsString())
                .add("OutputConfig", outputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "ExportStatus":
            return Optional.ofNullable(clazz.cast(exportStatusAsString()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("ExportStatus", EXPORT_STATUS_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportVectorEnrichmentJobResponse, T> g) {
        return obj -> g.apply((ExportVectorEnrichmentJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerGeospatialResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportVectorEnrichmentJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Vector Enrichment job being exported.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Vector Enrichment job being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role with permission to upload to the location in OutputConfig.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role with permission to upload to the location in
         *        OutputConfig.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The status of the results the Vector Enrichment job being exported.
         * </p>
         * 
         * @param exportStatus
         *        The status of the results the Vector Enrichment job being exported.
         * @see VectorEnrichmentJobExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VectorEnrichmentJobExportStatus
         */
        Builder exportStatus(String exportStatus);

        /**
         * <p>
         * The status of the results the Vector Enrichment job being exported.
         * </p>
         * 
         * @param exportStatus
         *        The status of the results the Vector Enrichment job being exported.
         * @see VectorEnrichmentJobExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VectorEnrichmentJobExportStatus
         */
        Builder exportStatus(VectorEnrichmentJobExportStatus exportStatus);

        /**
         * <p>
         * Output location information for exporting Vector Enrichment Job results.
         * </p>
         * 
         * @param outputConfig
         *        Output location information for exporting Vector Enrichment Job results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(ExportVectorEnrichmentJobOutputConfig outputConfig);

        /**
         * <p>
         * Output location information for exporting Vector Enrichment Job results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExportVectorEnrichmentJobOutputConfig.Builder} avoiding the need to create one manually via
         * {@link ExportVectorEnrichmentJobOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportVectorEnrichmentJobOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfig(ExportVectorEnrichmentJobOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link ExportVectorEnrichmentJobOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(ExportVectorEnrichmentJobOutputConfig)
         */
        default Builder outputConfig(Consumer<ExportVectorEnrichmentJobOutputConfig.Builder> outputConfig) {
            return outputConfig(ExportVectorEnrichmentJobOutputConfig.builder().applyMutation(outputConfig).build());
        }
    }

    static final class BuilderImpl extends SageMakerGeospatialResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private String executionRoleArn;

        private String exportStatus;

        private ExportVectorEnrichmentJobOutputConfig outputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportVectorEnrichmentJobResponse model) {
            super(model);
            arn(model.arn);
            creationTime(model.creationTime);
            executionRoleArn(model.executionRoleArn);
            exportStatus(model.exportStatus);
            outputConfig(model.outputConfig);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getExportStatus() {
            return exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(VectorEnrichmentJobExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final ExportVectorEnrichmentJobOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ExportVectorEnrichmentJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ExportVectorEnrichmentJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        @Override
        public ExportVectorEnrichmentJobResponse build() {
            return new ExportVectorEnrichmentJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
