/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEarthObservationJobResponse extends SageMakerGeospatialResponse implements
        ToCopyableBuilder<GetEarthObservationJobResponse.Builder, GetEarthObservationJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetEarthObservationJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(GetEarthObservationJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInSeconds").getter(getter(GetEarthObservationJobResponse::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final SdkField<EarthObservationJobErrorDetails> ERROR_DETAILS_FIELD = SdkField
            .<EarthObservationJobErrorDetails> builder(MarshallingType.SDK_POJO).memberName("ErrorDetails")
            .getter(getter(GetEarthObservationJobResponse::errorDetails)).setter(setter(Builder::errorDetails))
            .constructor(EarthObservationJobErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(GetEarthObservationJobResponse::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<ExportErrorDetails> EXPORT_ERROR_DETAILS_FIELD = SdkField
            .<ExportErrorDetails> builder(MarshallingType.SDK_POJO).memberName("ExportErrorDetails")
            .getter(getter(GetEarthObservationJobResponse::exportErrorDetails)).setter(setter(Builder::exportErrorDetails))
            .constructor(ExportErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportErrorDetails").build())
            .build();

    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportStatus").getter(getter(GetEarthObservationJobResponse::exportStatusAsString))
            .setter(setter(Builder::exportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()).build();

    private static final SdkField<InputConfigOutput> INPUT_CONFIG_FIELD = SdkField
            .<InputConfigOutput> builder(MarshallingType.SDK_POJO).memberName("InputConfig")
            .getter(getter(GetEarthObservationJobResponse::inputConfig)).setter(setter(Builder::inputConfig))
            .constructor(InputConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final SdkField<JobConfigInput> JOB_CONFIG_FIELD = SdkField.<JobConfigInput> builder(MarshallingType.SDK_POJO)
            .memberName("JobConfig").getter(getter(GetEarthObservationJobResponse::jobConfig)).setter(setter(Builder::jobConfig))
            .constructor(JobConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(GetEarthObservationJobResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetEarthObservationJobResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<OutputBand>> OUTPUT_BANDS_FIELD = SdkField
            .<List<OutputBand>> builder(MarshallingType.LIST)
            .memberName("OutputBands")
            .getter(getter(GetEarthObservationJobResponse::outputBands))
            .setter(setter(Builder::outputBands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputBand> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputBand::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetEarthObservationJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetEarthObservationJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, DURATION_IN_SECONDS_FIELD, ERROR_DETAILS_FIELD, EXECUTION_ROLE_ARN_FIELD,
            EXPORT_ERROR_DETAILS_FIELD, EXPORT_STATUS_FIELD, INPUT_CONFIG_FIELD, JOB_CONFIG_FIELD, KMS_KEY_ID_FIELD, NAME_FIELD,
            OUTPUT_BANDS_FIELD, STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final Instant creationTime;

    private final Integer durationInSeconds;

    private final EarthObservationJobErrorDetails errorDetails;

    private final String executionRoleArn;

    private final ExportErrorDetails exportErrorDetails;

    private final String exportStatus;

    private final InputConfigOutput inputConfig;

    private final JobConfigInput jobConfig;

    private final String kmsKeyId;

    private final String name;

    private final List<OutputBand> outputBands;

    private final String status;

    private final Map<String, String> tags;

    private GetEarthObservationJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.durationInSeconds = builder.durationInSeconds;
        this.errorDetails = builder.errorDetails;
        this.executionRoleArn = builder.executionRoleArn;
        this.exportErrorDetails = builder.exportErrorDetails;
        this.exportStatus = builder.exportStatus;
        this.inputConfig = builder.inputConfig;
        this.jobConfig = builder.jobConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.name = builder.name;
        this.outputBands = builder.outputBands;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Earth Observation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Earth Observation job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The creation time of the initiated Earth Observation job.
     * </p>
     * 
     * @return The creation time of the initiated Earth Observation job.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The duration of Earth Observation job, in seconds.
     * </p>
     * 
     * @return The duration of Earth Observation job, in seconds.
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    /**
     * <p>
     * Details about the errors generated during the Earth Observation job.
     * </p>
     * 
     * @return Details about the errors generated during the Earth Observation job.
     */
    public final EarthObservationJobErrorDetails errorDetails() {
        return errorDetails;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * Details about the errors generated during ExportEarthObservationJob.
     * </p>
     * 
     * @return Details about the errors generated during ExportEarthObservationJob.
     */
    public final ExportErrorDetails exportErrorDetails() {
        return exportErrorDetails;
    }

    /**
     * <p>
     * The status of the Earth Observation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link EarthObservationJobExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The status of the Earth Observation job.
     * @see EarthObservationJobExportStatus
     */
    public final EarthObservationJobExportStatus exportStatus() {
        return EarthObservationJobExportStatus.fromValue(exportStatus);
    }

    /**
     * <p>
     * The status of the Earth Observation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link EarthObservationJobExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The status of the Earth Observation job.
     * @see EarthObservationJobExportStatus
     */
    public final String exportStatusAsString() {
        return exportStatus;
    }

    /**
     * <p>
     * Input data for the Earth Observation job.
     * </p>
     * 
     * @return Input data for the Earth Observation job.
     */
    public final InputConfigOutput inputConfig() {
        return inputConfig;
    }

    /**
     * <p>
     * An object containing information about the job configuration.
     * </p>
     * 
     * @return An object containing information about the job configuration.
     */
    public final JobConfigInput jobConfig() {
        return jobConfig;
    }

    /**
     * <p>
     * The Key Management Service key ID for server-side encryption.
     * </p>
     * 
     * @return The Key Management Service key ID for server-side encryption.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The name of the Earth Observation job.
     * </p>
     * 
     * @return The name of the Earth Observation job.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputBands property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputBands() {
        return outputBands != null && !(outputBands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Bands available in the output of an operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputBands} method.
     * </p>
     * 
     * @return Bands available in the output of an operation.
     */
    public final List<OutputBand> outputBands() {
        return outputBands;
    }

    /**
     * <p>
     * The status of a previously initiated Earth Observation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EarthObservationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a previously initiated Earth Observation job.
     * @see EarthObservationJobStatus
     */
    public final EarthObservationJobStatus status() {
        return EarthObservationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a previously initiated Earth Observation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EarthObservationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a previously initiated Earth Observation job.
     * @see EarthObservationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Each tag consists of a key and a value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Each tag consists of a key and a value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(exportErrorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputBands() ? outputBands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEarthObservationJobResponse)) {
            return false;
        }
        GetEarthObservationJobResponse other = (GetEarthObservationJobResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(durationInSeconds(), other.durationInSeconds())
                && Objects.equals(errorDetails(), other.errorDetails())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(exportErrorDetails(), other.exportErrorDetails())
                && Objects.equals(exportStatusAsString(), other.exportStatusAsString())
                && Objects.equals(inputConfig(), other.inputConfig()) && Objects.equals(jobConfig(), other.jobConfig())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(name(), other.name())
                && hasOutputBands() == other.hasOutputBands() && Objects.equals(outputBands(), other.outputBands())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEarthObservationJobResponse").add("Arn", arn()).add("CreationTime", creationTime())
                .add("DurationInSeconds", durationInSeconds()).add("ErrorDetails", errorDetails())
                .add("ExecutionRoleArn", executionRoleArn()).add("ExportErrorDetails", exportErrorDetails())
                .add("ExportStatus", exportStatusAsString()).add("InputConfig", inputConfig()).add("JobConfig", jobConfig())
                .add("KmsKeyId", kmsKeyId()).add("Name", name()).add("OutputBands", hasOutputBands() ? outputBands() : null)
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "ExportErrorDetails":
            return Optional.ofNullable(clazz.cast(exportErrorDetails()));
        case "ExportStatus":
            return Optional.ofNullable(clazz.cast(exportStatusAsString()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        case "JobConfig":
            return Optional.ofNullable(clazz.cast(jobConfig()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OutputBands":
            return Optional.ofNullable(clazz.cast(outputBands()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("ExportErrorDetails", EXPORT_ERROR_DETAILS_FIELD);
        map.put("ExportStatus", EXPORT_STATUS_FIELD);
        map.put("InputConfig", INPUT_CONFIG_FIELD);
        map.put("JobConfig", JOB_CONFIG_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("OutputBands", OUTPUT_BANDS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEarthObservationJobResponse, T> g) {
        return obj -> g.apply((GetEarthObservationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerGeospatialResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEarthObservationJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Earth Observation job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Earth Observation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The creation time of the initiated Earth Observation job.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the initiated Earth Observation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The duration of Earth Observation job, in seconds.
         * </p>
         * 
         * @param durationInSeconds
         *        The duration of Earth Observation job, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);

        /**
         * <p>
         * Details about the errors generated during the Earth Observation job.
         * </p>
         * 
         * @param errorDetails
         *        Details about the errors generated during the Earth Observation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(EarthObservationJobErrorDetails errorDetails);

        /**
         * <p>
         * Details about the errors generated during the Earth Observation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link EarthObservationJobErrorDetails.Builder}
         * avoiding the need to create one manually via {@link EarthObservationJobErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EarthObservationJobErrorDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #errorDetails(EarthObservationJobErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link EarthObservationJobErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(EarthObservationJobErrorDetails)
         */
        default Builder errorDetails(Consumer<EarthObservationJobErrorDetails.Builder> errorDetails) {
            return errorDetails(EarthObservationJobErrorDetails.builder().applyMutation(errorDetails).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * Details about the errors generated during ExportEarthObservationJob.
         * </p>
         * 
         * @param exportErrorDetails
         *        Details about the errors generated during ExportEarthObservationJob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportErrorDetails(ExportErrorDetails exportErrorDetails);

        /**
         * <p>
         * Details about the errors generated during ExportEarthObservationJob.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportErrorDetails.Builder} avoiding the
         * need to create one manually via {@link ExportErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #exportErrorDetails(ExportErrorDetails)}.
         * 
         * @param exportErrorDetails
         *        a consumer that will call methods on {@link ExportErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportErrorDetails(ExportErrorDetails)
         */
        default Builder exportErrorDetails(Consumer<ExportErrorDetails.Builder> exportErrorDetails) {
            return exportErrorDetails(ExportErrorDetails.builder().applyMutation(exportErrorDetails).build());
        }

        /**
         * <p>
         * The status of the Earth Observation job.
         * </p>
         * 
         * @param exportStatus
         *        The status of the Earth Observation job.
         * @see EarthObservationJobExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EarthObservationJobExportStatus
         */
        Builder exportStatus(String exportStatus);

        /**
         * <p>
         * The status of the Earth Observation job.
         * </p>
         * 
         * @param exportStatus
         *        The status of the Earth Observation job.
         * @see EarthObservationJobExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EarthObservationJobExportStatus
         */
        Builder exportStatus(EarthObservationJobExportStatus exportStatus);

        /**
         * <p>
         * Input data for the Earth Observation job.
         * </p>
         * 
         * @param inputConfig
         *        Input data for the Earth Observation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(InputConfigOutput inputConfig);

        /**
         * <p>
         * Input data for the Earth Observation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputConfigOutput.Builder} avoiding the
         * need to create one manually via {@link InputConfigOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputConfigOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #inputConfig(InputConfigOutput)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link InputConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(InputConfigOutput)
         */
        default Builder inputConfig(Consumer<InputConfigOutput.Builder> inputConfig) {
            return inputConfig(InputConfigOutput.builder().applyMutation(inputConfig).build());
        }

        /**
         * <p>
         * An object containing information about the job configuration.
         * </p>
         * 
         * @param jobConfig
         *        An object containing information about the job configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobConfig(JobConfigInput jobConfig);

        /**
         * <p>
         * An object containing information about the job configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobConfigInput.Builder} avoiding the need
         * to create one manually via {@link JobConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobConfigInput.Builder#build()} is called immediately and its
         * result is passed to {@link #jobConfig(JobConfigInput)}.
         * 
         * @param jobConfig
         *        a consumer that will call methods on {@link JobConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobConfig(JobConfigInput)
         */
        default Builder jobConfig(Consumer<JobConfigInput.Builder> jobConfig) {
            return jobConfig(JobConfigInput.builder().applyMutation(jobConfig).build());
        }

        /**
         * <p>
         * The Key Management Service key ID for server-side encryption.
         * </p>
         * 
         * @param kmsKeyId
         *        The Key Management Service key ID for server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The name of the Earth Observation job.
         * </p>
         * 
         * @param name
         *        The name of the Earth Observation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Bands available in the output of an operation.
         * </p>
         * 
         * @param outputBands
         *        Bands available in the output of an operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBands(Collection<OutputBand> outputBands);

        /**
         * <p>
         * Bands available in the output of an operation.
         * </p>
         * 
         * @param outputBands
         *        Bands available in the output of an operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBands(OutputBand... outputBands);

        /**
         * <p>
         * Bands available in the output of an operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.OutputBand.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.OutputBand#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.OutputBand.Builder#build()} is called
         * immediately and its result is passed to {@link #outputBands(List<OutputBand>)}.
         * 
         * @param outputBands
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakergeospatial.model.OutputBand.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputBands(java.util.Collection<OutputBand>)
         */
        Builder outputBands(Consumer<OutputBand.Builder>... outputBands);

        /**
         * <p>
         * The status of a previously initiated Earth Observation job.
         * </p>
         * 
         * @param status
         *        The status of a previously initiated Earth Observation job.
         * @see EarthObservationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EarthObservationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a previously initiated Earth Observation job.
         * </p>
         * 
         * @param status
         *        The status of a previously initiated Earth Observation job.
         * @see EarthObservationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EarthObservationJobStatus
         */
        Builder status(EarthObservationJobStatus status);

        /**
         * <p>
         * Each tag consists of a key and a value.
         * </p>
         * 
         * @param tags
         *        Each tag consists of a key and a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends SageMakerGeospatialResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private Integer durationInSeconds;

        private EarthObservationJobErrorDetails errorDetails;

        private String executionRoleArn;

        private ExportErrorDetails exportErrorDetails;

        private String exportStatus;

        private InputConfigOutput inputConfig;

        private JobConfigInput jobConfig;

        private String kmsKeyId;

        private String name;

        private List<OutputBand> outputBands = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEarthObservationJobResponse model) {
            super(model);
            arn(model.arn);
            creationTime(model.creationTime);
            durationInSeconds(model.durationInSeconds);
            errorDetails(model.errorDetails);
            executionRoleArn(model.executionRoleArn);
            exportErrorDetails(model.exportErrorDetails);
            exportStatus(model.exportStatus);
            inputConfig(model.inputConfig);
            jobConfig(model.jobConfig);
            kmsKeyId(model.kmsKeyId);
            name(model.name);
            outputBands(model.outputBands);
            status(model.status);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final EarthObservationJobErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(EarthObservationJobErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(EarthObservationJobErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final ExportErrorDetails.Builder getExportErrorDetails() {
            return exportErrorDetails != null ? exportErrorDetails.toBuilder() : null;
        }

        public final void setExportErrorDetails(ExportErrorDetails.BuilderImpl exportErrorDetails) {
            this.exportErrorDetails = exportErrorDetails != null ? exportErrorDetails.build() : null;
        }

        @Override
        public final Builder exportErrorDetails(ExportErrorDetails exportErrorDetails) {
            this.exportErrorDetails = exportErrorDetails;
            return this;
        }

        public final String getExportStatus() {
            return exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(EarthObservationJobExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final InputConfigOutput.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(InputConfigOutput.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(InputConfigOutput inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final JobConfigInput.Builder getJobConfig() {
            return jobConfig != null ? jobConfig.toBuilder() : null;
        }

        public final void setJobConfig(JobConfigInput.BuilderImpl jobConfig) {
            this.jobConfig = jobConfig != null ? jobConfig.build() : null;
        }

        @Override
        public final Builder jobConfig(JobConfigInput jobConfig) {
            this.jobConfig = jobConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<OutputBand.Builder> getOutputBands() {
            List<OutputBand.Builder> result = EarthObservationJobOutputBandsCopier.copyToBuilder(this.outputBands);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputBands(Collection<OutputBand.BuilderImpl> outputBands) {
            this.outputBands = EarthObservationJobOutputBandsCopier.copyFromBuilder(outputBands);
        }

        @Override
        public final Builder outputBands(Collection<OutputBand> outputBands) {
            this.outputBands = EarthObservationJobOutputBandsCopier.copy(outputBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputBands(OutputBand... outputBands) {
            outputBands(Arrays.asList(outputBands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputBands(Consumer<OutputBand.Builder>... outputBands) {
            outputBands(Stream.of(outputBands).map(c -> OutputBand.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EarthObservationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public GetEarthObservationJobResponse build() {
            return new GetEarthObservationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
