/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the items in the response for SearchRasterDataCollection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ItemSource implements SdkPojo, Serializable, ToCopyableBuilder<ItemSource.Builder, ItemSource> {
    private static final SdkField<Map<String, AssetValue>> ASSETS_FIELD = SdkField
            .<Map<String, AssetValue>> builder(MarshallingType.MAP)
            .memberName("Assets")
            .getter(getter(ItemSource::assets))
            .setter(setter(Builder::assets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AssetValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateTime").getter(getter(ItemSource::dateTime)).setter(setter(Builder::dateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTime").build()).build();

    private static final SdkField<Geometry> GEOMETRY_FIELD = SdkField.<Geometry> builder(MarshallingType.SDK_POJO)
            .memberName("Geometry").getter(getter(ItemSource::geometry)).setter(setter(Builder::geometry))
            .constructor(Geometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ItemSource::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Properties> PROPERTIES_FIELD = SdkField.<Properties> builder(MarshallingType.SDK_POJO)
            .memberName("Properties").getter(getter(ItemSource::properties)).setter(setter(Builder::properties))
            .constructor(Properties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSETS_FIELD, DATE_TIME_FIELD,
            GEOMETRY_FIELD, ID_FIELD, PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, AssetValue> assets;

    private final Instant dateTime;

    private final Geometry geometry;

    private final String id;

    private final Properties properties;

    private ItemSource(BuilderImpl builder) {
        this.assets = builder.assets;
        this.dateTime = builder.dateTime;
        this.geometry = builder.geometry;
        this.id = builder.id;
        this.properties = builder.properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Assets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAssets() {
        return assets != null && !(assets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is a dictionary of Asset Objects data associated with the Item that can be downloaded or streamed, each with
     * a unique key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssets} method.
     * </p>
     * 
     * @return This is a dictionary of Asset Objects data associated with the Item that can be downloaded or streamed,
     *         each with a unique key.
     */
    public final Map<String, AssetValue> assets() {
        return assets;
    }

    /**
     * <p>
     * The searchable date and time of the item, in UTC.
     * </p>
     * 
     * @return The searchable date and time of the item, in UTC.
     */
    public final Instant dateTime() {
        return dateTime;
    }

    /**
     * <p>
     * The item Geometry in GeoJson format.
     * </p>
     * 
     * @return The item Geometry in GeoJson format.
     */
    public final Geometry geometry() {
        return geometry;
    }

    /**
     * <p>
     * A unique Id for the source item.
     * </p>
     * 
     * @return A unique Id for the source item.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * This field contains additional properties of the item.
     * </p>
     * 
     * @return This field contains additional properties of the item.
     */
    public final Properties properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssets() ? assets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dateTime());
        hashCode = 31 * hashCode + Objects.hashCode(geometry());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemSource)) {
            return false;
        }
        ItemSource other = (ItemSource) obj;
        return hasAssets() == other.hasAssets() && Objects.equals(assets(), other.assets())
                && Objects.equals(dateTime(), other.dateTime()) && Objects.equals(geometry(), other.geometry())
                && Objects.equals(id(), other.id()) && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ItemSource").add("Assets", hasAssets() ? assets() : null).add("DateTime", dateTime())
                .add("Geometry", geometry()).add("Id", id()).add("Properties", properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Assets":
            return Optional.ofNullable(clazz.cast(assets()));
        case "DateTime":
            return Optional.ofNullable(clazz.cast(dateTime()));
        case "Geometry":
            return Optional.ofNullable(clazz.cast(geometry()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Assets", ASSETS_FIELD);
        map.put("DateTime", DATE_TIME_FIELD);
        map.put("Geometry", GEOMETRY_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItemSource, T> g) {
        return obj -> g.apply((ItemSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ItemSource> {
        /**
         * <p>
         * This is a dictionary of Asset Objects data associated with the Item that can be downloaded or streamed, each
         * with a unique key.
         * </p>
         * 
         * @param assets
         *        This is a dictionary of Asset Objects data associated with the Item that can be downloaded or
         *        streamed, each with a unique key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assets(Map<String, AssetValue> assets);

        /**
         * <p>
         * The searchable date and time of the item, in UTC.
         * </p>
         * 
         * @param dateTime
         *        The searchable date and time of the item, in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTime(Instant dateTime);

        /**
         * <p>
         * The item Geometry in GeoJson format.
         * </p>
         * 
         * @param geometry
         *        The item Geometry in GeoJson format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometry(Geometry geometry);

        /**
         * <p>
         * The item Geometry in GeoJson format.
         * </p>
         * This is a convenience method that creates an instance of the {@link Geometry.Builder} avoiding the need to
         * create one manually via {@link Geometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Geometry.Builder#build()} is called immediately and its result is
         * passed to {@link #geometry(Geometry)}.
         * 
         * @param geometry
         *        a consumer that will call methods on {@link Geometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometry(Geometry)
         */
        default Builder geometry(Consumer<Geometry.Builder> geometry) {
            return geometry(Geometry.builder().applyMutation(geometry).build());
        }

        /**
         * <p>
         * A unique Id for the source item.
         * </p>
         * 
         * @param id
         *        A unique Id for the source item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * This field contains additional properties of the item.
         * </p>
         * 
         * @param properties
         *        This field contains additional properties of the item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Properties properties);

        /**
         * <p>
         * This field contains additional properties of the item.
         * </p>
         * This is a convenience method that creates an instance of the {@link Properties.Builder} avoiding the need to
         * create one manually via {@link Properties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Properties.Builder#build()} is called immediately and its result
         * is passed to {@link #properties(Properties)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link Properties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(Properties)
         */
        default Builder properties(Consumer<Properties.Builder> properties) {
            return properties(Properties.builder().applyMutation(properties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, AssetValue> assets = DefaultSdkAutoConstructMap.getInstance();

        private Instant dateTime;

        private Geometry geometry;

        private String id;

        private Properties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(ItemSource model) {
            assets(model.assets);
            dateTime(model.dateTime);
            geometry(model.geometry);
            id(model.id);
            properties(model.properties);
        }

        public final Map<String, AssetValue.Builder> getAssets() {
            Map<String, AssetValue.Builder> result = AssetsMapCopier.copyToBuilder(this.assets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAssets(Map<String, AssetValue.BuilderImpl> assets) {
            this.assets = AssetsMapCopier.copyFromBuilder(assets);
        }

        @Override
        public final Builder assets(Map<String, AssetValue> assets) {
            this.assets = AssetsMapCopier.copy(assets);
            return this;
        }

        public final Instant getDateTime() {
            return dateTime;
        }

        public final void setDateTime(Instant dateTime) {
            this.dateTime = dateTime;
        }

        @Override
        public final Builder dateTime(Instant dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public final Geometry.Builder getGeometry() {
            return geometry != null ? geometry.toBuilder() : null;
        }

        public final void setGeometry(Geometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(Geometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Properties.Builder getProperties() {
            return properties != null ? properties.toBuilder() : null;
        }

        public final void setProperties(Properties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public ItemSource build() {
            return new ItemSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
