/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of PropertyFilter objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyFilters implements SdkPojo, Serializable, ToCopyableBuilder<PropertyFilters.Builder, PropertyFilters> {
    private static final SdkField<String> LOGICAL_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalOperator").getter(getter(PropertyFilters::logicalOperatorAsString))
            .setter(setter(Builder::logicalOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalOperator").build()).build();

    private static final SdkField<List<PropertyFilter>> PROPERTIES_FIELD = SdkField
            .<List<PropertyFilter>> builder(MarshallingType.LIST)
            .memberName("Properties")
            .getter(getter(PropertyFilters::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropertyFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_OPERATOR_FIELD,
            PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logicalOperator;

    private final List<PropertyFilter> properties;

    private PropertyFilters(BuilderImpl builder) {
        this.logicalOperator = builder.logicalOperator;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The Logical Operator used to combine the Property Filters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logicalOperator}
     * will return {@link LogicalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logicalOperatorAsString}.
     * </p>
     * 
     * @return The Logical Operator used to combine the Property Filters.
     * @see LogicalOperator
     */
    public final LogicalOperator logicalOperator() {
        return LogicalOperator.fromValue(logicalOperator);
    }

    /**
     * <p>
     * The Logical Operator used to combine the Property Filters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logicalOperator}
     * will return {@link LogicalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logicalOperatorAsString}.
     * </p>
     * 
     * @return The Logical Operator used to combine the Property Filters.
     * @see LogicalOperator
     */
    public final String logicalOperatorAsString() {
        return logicalOperator;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Property Filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return A list of Property Filters.
     */
    public final List<PropertyFilter> properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logicalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyFilters)) {
            return false;
        }
        PropertyFilters other = (PropertyFilters) obj;
        return Objects.equals(logicalOperatorAsString(), other.logicalOperatorAsString())
                && hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyFilters").add("LogicalOperator", logicalOperatorAsString())
                .add("Properties", hasProperties() ? properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogicalOperator":
            return Optional.ofNullable(clazz.cast(logicalOperatorAsString()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogicalOperator", LOGICAL_OPERATOR_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyFilters, T> g) {
        return obj -> g.apply((PropertyFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyFilters> {
        /**
         * <p>
         * The Logical Operator used to combine the Property Filters.
         * </p>
         * 
         * @param logicalOperator
         *        The Logical Operator used to combine the Property Filters.
         * @see LogicalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogicalOperator
         */
        Builder logicalOperator(String logicalOperator);

        /**
         * <p>
         * The Logical Operator used to combine the Property Filters.
         * </p>
         * 
         * @param logicalOperator
         *        The Logical Operator used to combine the Property Filters.
         * @see LogicalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogicalOperator
         */
        Builder logicalOperator(LogicalOperator logicalOperator);

        /**
         * <p>
         * A list of Property Filters.
         * </p>
         * 
         * @param properties
         *        A list of Property Filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Collection<PropertyFilter> properties);

        /**
         * <p>
         * A list of Property Filters.
         * </p>
         * 
         * @param properties
         *        A list of Property Filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(PropertyFilter... properties);

        /**
         * <p>
         * A list of Property Filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #properties(List<PropertyFilter>)}.
         * 
         * @param properties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(java.util.Collection<PropertyFilter>)
         */
        Builder properties(Consumer<PropertyFilter.Builder>... properties);
    }

    static final class BuilderImpl implements Builder {
        private String logicalOperator;

        private List<PropertyFilter> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyFilters model) {
            logicalOperator(model.logicalOperator);
            properties(model.properties);
        }

        public final String getLogicalOperator() {
            return logicalOperator;
        }

        public final void setLogicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
        }

        @Override
        public final Builder logicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
            return this;
        }

        @Override
        public final Builder logicalOperator(LogicalOperator logicalOperator) {
            this.logicalOperator(logicalOperator == null ? null : logicalOperator.toString());
            return this;
        }

        public final List<PropertyFilter.Builder> getProperties() {
            List<PropertyFilter.Builder> result = PropertyFiltersListCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<PropertyFilter.BuilderImpl> properties) {
            this.properties = PropertyFiltersListCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Collection<PropertyFilter> properties) {
            this.properties = PropertyFiltersListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(PropertyFilter... properties) {
            properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<PropertyFilter.Builder>... properties) {
            properties(Stream.of(properties).map(c -> PropertyFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PropertyFilters build() {
            return new PropertyFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
