/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing input configuration of ZonalStatistics operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ZonalStatisticsConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ZonalStatisticsConfigInput.Builder, ZonalStatisticsConfigInput> {
    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Statistics")
            .getter(getter(ZonalStatisticsConfigInput::statisticsAsStrings))
            .setter(setter(Builder::statisticsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGET_BANDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetBands")
            .getter(getter(ZonalStatisticsConfigInput::targetBands))
            .setter(setter(Builder::targetBands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ZONE_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZoneS3Path").getter(getter(ZonalStatisticsConfigInput::zoneS3Path)).setter(setter(Builder::zoneS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneS3Path").build()).build();

    private static final SdkField<String> ZONE_S3_PATH_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZoneS3PathKmsKeyId").getter(getter(ZonalStatisticsConfigInput::zoneS3PathKmsKeyId))
            .setter(setter(Builder::zoneS3PathKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneS3PathKmsKeyId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTICS_FIELD,
            TARGET_BANDS_FIELD, ZONE_S3_PATH_FIELD, ZONE_S3_PATH_KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> statistics;

    private final List<String> targetBands;

    private final String zoneS3Path;

    private final String zoneS3PathKmsKeyId;

    private ZonalStatisticsConfigInput(BuilderImpl builder) {
        this.statistics = builder.statistics;
        this.targetBands = builder.targetBands;
        this.zoneS3Path = builder.zoneS3Path;
        this.zoneS3PathKmsKeyId = builder.zoneS3PathKmsKeyId;
    }

    /**
     * <p>
     * List of zonal statistics to compute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatistics} method.
     * </p>
     * 
     * @return List of zonal statistics to compute.
     */
    public final List<ZonalStatistics> statistics() {
        return ZonalStatisticsListInputCopier.copyStringToEnum(statistics);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statistics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatistics() {
        return statistics != null && !(statistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of zonal statistics to compute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatistics} method.
     * </p>
     * 
     * @return List of zonal statistics to compute.
     */
    public final List<String> statisticsAsStrings() {
        return statistics;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetBands property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetBands() {
        return targetBands != null && !(targetBands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Bands used in the operation. If no target bands are specified, it uses all bands available input.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetBands} method.
     * </p>
     * 
     * @return Bands used in the operation. If no target bands are specified, it uses all bands available input.
     */
    public final List<String> targetBands() {
        return targetBands;
    }

    /**
     * <p>
     * The Amazon S3 path pointing to the GeoJSON containing the polygonal zones.
     * </p>
     * 
     * @return The Amazon S3 path pointing to the GeoJSON containing the polygonal zones.
     */
    public final String zoneS3Path() {
        return zoneS3Path;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or an ID of a Amazon Web Services Key Management Service (Amazon Web Services KMS)
     * key that Amazon SageMaker uses to decrypt your output artifacts with Amazon S3 server-side encryption. The
     * SageMaker execution role must have <code>kms:GenerateDataKey</code> permission.
     * </p>
     * <p>
     * The <code>KmsKeyId</code> can be any of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * // KMS Key ID
     * </p>
     * <p>
     * <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * // Amazon Resource Name (ARN) of a KMS Key
     * </p>
     * <p>
     * <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about key identifiers, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key identifiers
     * (KeyID)</a> in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or an ID of a Amazon Web Services Key Management Service (Amazon Web
     *         Services KMS) key that Amazon SageMaker uses to decrypt your output artifacts with Amazon S3 server-side
     *         encryption. The SageMaker execution role must have <code>kms:GenerateDataKey</code> permission.</p>
     *         <p>
     *         The <code>KmsKeyId</code> can be any of the following formats:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         // KMS Key ID
     *         </p>
     *         <p>
     *         <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         // Amazon Resource Name (ARN) of a KMS Key
     *         </p>
     *         <p>
     *         <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about key identifiers, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key identifiers
     *         (KeyID)</a> in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.
     */
    public final String zoneS3PathKmsKeyId() {
        return zoneS3PathKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStatistics() ? statisticsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetBands() ? targetBands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(zoneS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(zoneS3PathKmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZonalStatisticsConfigInput)) {
            return false;
        }
        ZonalStatisticsConfigInput other = (ZonalStatisticsConfigInput) obj;
        return hasStatistics() == other.hasStatistics() && Objects.equals(statisticsAsStrings(), other.statisticsAsStrings())
                && hasTargetBands() == other.hasTargetBands() && Objects.equals(targetBands(), other.targetBands())
                && Objects.equals(zoneS3Path(), other.zoneS3Path())
                && Objects.equals(zoneS3PathKmsKeyId(), other.zoneS3PathKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ZonalStatisticsConfigInput").add("Statistics", hasStatistics() ? statisticsAsStrings() : null)
                .add("TargetBands", hasTargetBands() ? targetBands() : null).add("ZoneS3Path", zoneS3Path())
                .add("ZoneS3PathKmsKeyId", zoneS3PathKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statistics":
            return Optional.ofNullable(clazz.cast(statisticsAsStrings()));
        case "TargetBands":
            return Optional.ofNullable(clazz.cast(targetBands()));
        case "ZoneS3Path":
            return Optional.ofNullable(clazz.cast(zoneS3Path()));
        case "ZoneS3PathKmsKeyId":
            return Optional.ofNullable(clazz.cast(zoneS3PathKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Statistics", STATISTICS_FIELD);
        map.put("TargetBands", TARGET_BANDS_FIELD);
        map.put("ZoneS3Path", ZONE_S3_PATH_FIELD);
        map.put("ZoneS3PathKmsKeyId", ZONE_S3_PATH_KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ZonalStatisticsConfigInput, T> g) {
        return obj -> g.apply((ZonalStatisticsConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ZonalStatisticsConfigInput> {
        /**
         * <p>
         * List of zonal statistics to compute.
         * </p>
         * 
         * @param statistics
         *        List of zonal statistics to compute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsWithStrings(Collection<String> statistics);

        /**
         * <p>
         * List of zonal statistics to compute.
         * </p>
         * 
         * @param statistics
         *        List of zonal statistics to compute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsWithStrings(String... statistics);

        /**
         * <p>
         * List of zonal statistics to compute.
         * </p>
         * 
         * @param statistics
         *        List of zonal statistics to compute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(Collection<ZonalStatistics> statistics);

        /**
         * <p>
         * List of zonal statistics to compute.
         * </p>
         * 
         * @param statistics
         *        List of zonal statistics to compute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(ZonalStatistics... statistics);

        /**
         * <p>
         * Bands used in the operation. If no target bands are specified, it uses all bands available input.
         * </p>
         * 
         * @param targetBands
         *        Bands used in the operation. If no target bands are specified, it uses all bands available input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBands(Collection<String> targetBands);

        /**
         * <p>
         * Bands used in the operation. If no target bands are specified, it uses all bands available input.
         * </p>
         * 
         * @param targetBands
         *        Bands used in the operation. If no target bands are specified, it uses all bands available input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBands(String... targetBands);

        /**
         * <p>
         * The Amazon S3 path pointing to the GeoJSON containing the polygonal zones.
         * </p>
         * 
         * @param zoneS3Path
         *        The Amazon S3 path pointing to the GeoJSON containing the polygonal zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneS3Path(String zoneS3Path);

        /**
         * <p>
         * The Amazon Resource Name (ARN) or an ID of a Amazon Web Services Key Management Service (Amazon Web Services
         * KMS) key that Amazon SageMaker uses to decrypt your output artifacts with Amazon S3 server-side encryption.
         * The SageMaker execution role must have <code>kms:GenerateDataKey</code> permission.
         * </p>
         * <p>
         * The <code>KmsKeyId</code> can be any of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * // KMS Key ID
         * </p>
         * <p>
         * <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * // Amazon Resource Name (ARN) of a KMS Key
         * </p>
         * <p>
         * <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about key identifiers, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key identifiers
         * (KeyID)</a> in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.
         * </p>
         * 
         * @param zoneS3PathKmsKeyId
         *        The Amazon Resource Name (ARN) or an ID of a Amazon Web Services Key Management Service (Amazon Web
         *        Services KMS) key that Amazon SageMaker uses to decrypt your output artifacts with Amazon S3
         *        server-side encryption. The SageMaker execution role must have <code>kms:GenerateDataKey</code>
         *        permission.</p>
         *        <p>
         *        The <code>KmsKeyId</code> can be any of the following formats:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        // KMS Key ID
         *        </p>
         *        <p>
         *        <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        // Amazon Resource Name (ARN) of a KMS Key
         *        </p>
         *        <p>
         *        <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about key identifiers, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key
         *        identifiers (KeyID)</a> in the Amazon Web Services Key Management Service (Amazon Web Services KMS)
         *        documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneS3PathKmsKeyId(String zoneS3PathKmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();

        private List<String> targetBands = DefaultSdkAutoConstructList.getInstance();

        private String zoneS3Path;

        private String zoneS3PathKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ZonalStatisticsConfigInput model) {
            statisticsWithStrings(model.statistics);
            targetBands(model.targetBands);
            zoneS3Path(model.zoneS3Path);
            zoneS3PathKmsKeyId(model.zoneS3PathKmsKeyId);
        }

        public final Collection<String> getStatistics() {
            if (statistics instanceof SdkAutoConstructList) {
                return null;
            }
            return statistics;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = ZonalStatisticsListInputCopier.copy(statistics);
        }

        @Override
        public final Builder statisticsWithStrings(Collection<String> statistics) {
            this.statistics = ZonalStatisticsListInputCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsWithStrings(String... statistics) {
            statisticsWithStrings(Arrays.asList(statistics));
            return this;
        }

        @Override
        public final Builder statistics(Collection<ZonalStatistics> statistics) {
            this.statistics = ZonalStatisticsListInputCopier.copyEnumToString(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(ZonalStatistics... statistics) {
            statistics(Arrays.asList(statistics));
            return this;
        }

        public final Collection<String> getTargetBands() {
            if (targetBands instanceof SdkAutoConstructList) {
                return null;
            }
            return targetBands;
        }

        public final void setTargetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
        }

        @Override
        public final Builder targetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBands(String... targetBands) {
            targetBands(Arrays.asList(targetBands));
            return this;
        }

        public final String getZoneS3Path() {
            return zoneS3Path;
        }

        public final void setZoneS3Path(String zoneS3Path) {
            this.zoneS3Path = zoneS3Path;
        }

        @Override
        public final Builder zoneS3Path(String zoneS3Path) {
            this.zoneS3Path = zoneS3Path;
            return this;
        }

        public final String getZoneS3PathKmsKeyId() {
            return zoneS3PathKmsKeyId;
        }

        public final void setZoneS3PathKmsKeyId(String zoneS3PathKmsKeyId) {
            this.zoneS3PathKmsKeyId = zoneS3PathKmsKeyId;
        }

        @Override
        public final Builder zoneS3PathKmsKeyId(String zoneS3PathKmsKeyId) {
            this.zoneS3PathKmsKeyId = zoneS3PathKmsKeyId;
            return this;
        }

        @Override
        public ZonalStatisticsConfigInput build() {
            return new ZonalStatisticsConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
