/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing information about the output file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportVectorEnrichmentJobOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportVectorEnrichmentJobOutputConfig.Builder, ExportVectorEnrichmentJobOutputConfig> {
    private static final SdkField<VectorEnrichmentJobS3Data> S3_DATA_FIELD = SdkField
            .<VectorEnrichmentJobS3Data> builder(MarshallingType.SDK_POJO).memberName("S3Data")
            .getter(getter(ExportVectorEnrichmentJobOutputConfig::s3Data)).setter(setter(Builder::s3Data))
            .constructor(VectorEnrichmentJobS3Data::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VectorEnrichmentJobS3Data s3Data;

    private ExportVectorEnrichmentJobOutputConfig(BuilderImpl builder) {
        this.s3Data = builder.s3Data;
    }

    /**
     * <p>
     * The input structure for Amazon S3 data; representing the Amazon S3 location of the input data objects.
     * </p>
     * 
     * @return The input structure for Amazon S3 data; representing the Amazon S3 location of the input data objects.
     */
    public final VectorEnrichmentJobS3Data s3Data() {
        return s3Data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportVectorEnrichmentJobOutputConfig)) {
            return false;
        }
        ExportVectorEnrichmentJobOutputConfig other = (ExportVectorEnrichmentJobOutputConfig) obj;
        return Objects.equals(s3Data(), other.s3Data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportVectorEnrichmentJobOutputConfig").add("S3Data", s3Data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Data":
            return Optional.ofNullable(clazz.cast(s3Data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3Data", S3_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportVectorEnrichmentJobOutputConfig, T> g) {
        return obj -> g.apply((ExportVectorEnrichmentJobOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportVectorEnrichmentJobOutputConfig> {
        /**
         * <p>
         * The input structure for Amazon S3 data; representing the Amazon S3 location of the input data objects.
         * </p>
         * 
         * @param s3Data
         *        The input structure for Amazon S3 data; representing the Amazon S3 location of the input data objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Data(VectorEnrichmentJobS3Data s3Data);

        /**
         * <p>
         * The input structure for Amazon S3 data; representing the Amazon S3 location of the input data objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorEnrichmentJobS3Data.Builder}
         * avoiding the need to create one manually via {@link VectorEnrichmentJobS3Data#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorEnrichmentJobS3Data.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Data(VectorEnrichmentJobS3Data)}.
         * 
         * @param s3Data
         *        a consumer that will call methods on {@link VectorEnrichmentJobS3Data.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Data(VectorEnrichmentJobS3Data)
         */
        default Builder s3Data(Consumer<VectorEnrichmentJobS3Data.Builder> s3Data) {
            return s3Data(VectorEnrichmentJobS3Data.builder().applyMutation(s3Data).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VectorEnrichmentJobS3Data s3Data;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportVectorEnrichmentJobOutputConfig model) {
            s3Data(model.s3Data);
        }

        public final VectorEnrichmentJobS3Data.Builder getS3Data() {
            return s3Data != null ? s3Data.toBuilder() : null;
        }

        public final void setS3Data(VectorEnrichmentJobS3Data.BuilderImpl s3Data) {
            this.s3Data = s3Data != null ? s3Data.build() : null;
        }

        @Override
        public final Builder s3Data(VectorEnrichmentJobS3Data s3Data) {
            this.s3Data = s3Data;
            return this;
        }

        @Override
        public ExportVectorEnrichmentJobOutputConfig build() {
            return new ExportVectorEnrichmentJobOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
