/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVectorEnrichmentJobResponse extends SageMakerGeospatialResponse implements
        ToCopyableBuilder<GetVectorEnrichmentJobResponse.Builder, GetVectorEnrichmentJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetVectorEnrichmentJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(GetVectorEnrichmentJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInSeconds").getter(getter(GetVectorEnrichmentJobResponse::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final SdkField<VectorEnrichmentJobErrorDetails> ERROR_DETAILS_FIELD = SdkField
            .<VectorEnrichmentJobErrorDetails> builder(MarshallingType.SDK_POJO).memberName("ErrorDetails")
            .getter(getter(GetVectorEnrichmentJobResponse::errorDetails)).setter(setter(Builder::errorDetails))
            .constructor(VectorEnrichmentJobErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(GetVectorEnrichmentJobResponse::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<VectorEnrichmentJobExportErrorDetails> EXPORT_ERROR_DETAILS_FIELD = SdkField
            .<VectorEnrichmentJobExportErrorDetails> builder(MarshallingType.SDK_POJO).memberName("ExportErrorDetails")
            .getter(getter(GetVectorEnrichmentJobResponse::exportErrorDetails)).setter(setter(Builder::exportErrorDetails))
            .constructor(VectorEnrichmentJobExportErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportErrorDetails").build())
            .build();

    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportStatus").getter(getter(GetVectorEnrichmentJobResponse::exportStatusAsString))
            .setter(setter(Builder::exportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()).build();

    private static final SdkField<VectorEnrichmentJobInputConfig> INPUT_CONFIG_FIELD = SdkField
            .<VectorEnrichmentJobInputConfig> builder(MarshallingType.SDK_POJO).memberName("InputConfig")
            .getter(getter(GetVectorEnrichmentJobResponse::inputConfig)).setter(setter(Builder::inputConfig))
            .constructor(VectorEnrichmentJobInputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final SdkField<VectorEnrichmentJobConfig> JOB_CONFIG_FIELD = SdkField
            .<VectorEnrichmentJobConfig> builder(MarshallingType.SDK_POJO).memberName("JobConfig")
            .getter(getter(GetVectorEnrichmentJobResponse::jobConfig)).setter(setter(Builder::jobConfig))
            .constructor(VectorEnrichmentJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(GetVectorEnrichmentJobResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetVectorEnrichmentJobResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetVectorEnrichmentJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetVectorEnrichmentJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetVectorEnrichmentJobResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, DURATION_IN_SECONDS_FIELD, ERROR_DETAILS_FIELD, EXECUTION_ROLE_ARN_FIELD,
            EXPORT_ERROR_DETAILS_FIELD, EXPORT_STATUS_FIELD, INPUT_CONFIG_FIELD, JOB_CONFIG_FIELD, KMS_KEY_ID_FIELD, NAME_FIELD,
            STATUS_FIELD, TAGS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final Instant creationTime;

    private final Integer durationInSeconds;

    private final VectorEnrichmentJobErrorDetails errorDetails;

    private final String executionRoleArn;

    private final VectorEnrichmentJobExportErrorDetails exportErrorDetails;

    private final String exportStatus;

    private final VectorEnrichmentJobInputConfig inputConfig;

    private final VectorEnrichmentJobConfig jobConfig;

    private final String kmsKeyId;

    private final String name;

    private final String status;

    private final Map<String, String> tags;

    private final String type;

    private GetVectorEnrichmentJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.durationInSeconds = builder.durationInSeconds;
        this.errorDetails = builder.errorDetails;
        this.executionRoleArn = builder.executionRoleArn;
        this.exportErrorDetails = builder.exportErrorDetails;
        this.exportStatus = builder.exportStatus;
        this.inputConfig = builder.inputConfig;
        this.jobConfig = builder.jobConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Vector Enrichment job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Vector Enrichment job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The duration of the Vector Enrichment job, in seconds.
     * </p>
     * 
     * @return The duration of the Vector Enrichment job, in seconds.
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    /**
     * <p>
     * Details about the errors generated during the Vector Enrichment job.
     * </p>
     * 
     * @return Details about the errors generated during the Vector Enrichment job.
     */
    public final VectorEnrichmentJobErrorDetails errorDetails() {
        return errorDetails;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * Details about the errors generated during the ExportVectorEnrichmentJob.
     * </p>
     * 
     * @return Details about the errors generated during the ExportVectorEnrichmentJob.
     */
    public final VectorEnrichmentJobExportErrorDetails exportErrorDetails() {
        return exportErrorDetails;
    }

    /**
     * <p>
     * The export status of the Vector Enrichment job being initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link VectorEnrichmentJobExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The export status of the Vector Enrichment job being initiated.
     * @see VectorEnrichmentJobExportStatus
     */
    public final VectorEnrichmentJobExportStatus exportStatus() {
        return VectorEnrichmentJobExportStatus.fromValue(exportStatus);
    }

    /**
     * <p>
     * The export status of the Vector Enrichment job being initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link VectorEnrichmentJobExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The export status of the Vector Enrichment job being initiated.
     * @see VectorEnrichmentJobExportStatus
     */
    public final String exportStatusAsString() {
        return exportStatus;
    }

    /**
     * <p>
     * Input configuration information for the Vector Enrichment job.
     * </p>
     * 
     * @return Input configuration information for the Vector Enrichment job.
     */
    public final VectorEnrichmentJobInputConfig inputConfig() {
        return inputConfig;
    }

    /**
     * <p>
     * An object containing information about the job configuration.
     * </p>
     * 
     * @return An object containing information about the job configuration.
     */
    public final VectorEnrichmentJobConfig jobConfig() {
        return jobConfig;
    }

    /**
     * <p>
     * The Key Management Service key ID for server-side encryption.
     * </p>
     * 
     * @return The Key Management Service key ID for server-side encryption.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The name of the Vector Enrichment job.
     * </p>
     * 
     * @return The name of the Vector Enrichment job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the initiated Vector Enrichment job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VectorEnrichmentJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the initiated Vector Enrichment job.
     * @see VectorEnrichmentJobStatus
     */
    public final VectorEnrichmentJobStatus status() {
        return VectorEnrichmentJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the initiated Vector Enrichment job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VectorEnrichmentJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the initiated Vector Enrichment job.
     * @see VectorEnrichmentJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Each tag consists of a key and a value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Each tag consists of a key and a value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of the Vector Enrichment job being initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link VectorEnrichmentJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the Vector Enrichment job being initiated.
     * @see VectorEnrichmentJobType
     */
    public final VectorEnrichmentJobType type() {
        return VectorEnrichmentJobType.fromValue(type);
    }

    /**
     * <p>
     * The type of the Vector Enrichment job being initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link VectorEnrichmentJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the Vector Enrichment job being initiated.
     * @see VectorEnrichmentJobType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(exportErrorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVectorEnrichmentJobResponse)) {
            return false;
        }
        GetVectorEnrichmentJobResponse other = (GetVectorEnrichmentJobResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(durationInSeconds(), other.durationInSeconds())
                && Objects.equals(errorDetails(), other.errorDetails())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(exportErrorDetails(), other.exportErrorDetails())
                && Objects.equals(exportStatusAsString(), other.exportStatusAsString())
                && Objects.equals(inputConfig(), other.inputConfig()) && Objects.equals(jobConfig(), other.jobConfig())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVectorEnrichmentJobResponse").add("Arn", arn()).add("CreationTime", creationTime())
                .add("DurationInSeconds", durationInSeconds()).add("ErrorDetails", errorDetails())
                .add("ExecutionRoleArn", executionRoleArn()).add("ExportErrorDetails", exportErrorDetails())
                .add("ExportStatus", exportStatusAsString()).add("InputConfig", inputConfig()).add("JobConfig", jobConfig())
                .add("KmsKeyId", kmsKeyId()).add("Name", name()).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "ExportErrorDetails":
            return Optional.ofNullable(clazz.cast(exportErrorDetails()));
        case "ExportStatus":
            return Optional.ofNullable(clazz.cast(exportStatusAsString()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        case "JobConfig":
            return Optional.ofNullable(clazz.cast(jobConfig()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("ExportErrorDetails", EXPORT_ERROR_DETAILS_FIELD);
        map.put("ExportStatus", EXPORT_STATUS_FIELD);
        map.put("InputConfig", INPUT_CONFIG_FIELD);
        map.put("JobConfig", JOB_CONFIG_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVectorEnrichmentJobResponse, T> g) {
        return obj -> g.apply((GetVectorEnrichmentJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerGeospatialResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetVectorEnrichmentJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Vector Enrichment job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Vector Enrichment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The duration of the Vector Enrichment job, in seconds.
         * </p>
         * 
         * @param durationInSeconds
         *        The duration of the Vector Enrichment job, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);

        /**
         * <p>
         * Details about the errors generated during the Vector Enrichment job.
         * </p>
         * 
         * @param errorDetails
         *        Details about the errors generated during the Vector Enrichment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(VectorEnrichmentJobErrorDetails errorDetails);

        /**
         * <p>
         * Details about the errors generated during the Vector Enrichment job.
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorEnrichmentJobErrorDetails.Builder}
         * avoiding the need to create one manually via {@link VectorEnrichmentJobErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorEnrichmentJobErrorDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #errorDetails(VectorEnrichmentJobErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link VectorEnrichmentJobErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(VectorEnrichmentJobErrorDetails)
         */
        default Builder errorDetails(Consumer<VectorEnrichmentJobErrorDetails.Builder> errorDetails) {
            return errorDetails(VectorEnrichmentJobErrorDetails.builder().applyMutation(errorDetails).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * Details about the errors generated during the ExportVectorEnrichmentJob.
         * </p>
         * 
         * @param exportErrorDetails
         *        Details about the errors generated during the ExportVectorEnrichmentJob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportErrorDetails(VectorEnrichmentJobExportErrorDetails exportErrorDetails);

        /**
         * <p>
         * Details about the errors generated during the ExportVectorEnrichmentJob.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VectorEnrichmentJobExportErrorDetails.Builder} avoiding the need to create one manually via
         * {@link VectorEnrichmentJobExportErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorEnrichmentJobExportErrorDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #exportErrorDetails(VectorEnrichmentJobExportErrorDetails)}.
         * 
         * @param exportErrorDetails
         *        a consumer that will call methods on {@link VectorEnrichmentJobExportErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportErrorDetails(VectorEnrichmentJobExportErrorDetails)
         */
        default Builder exportErrorDetails(Consumer<VectorEnrichmentJobExportErrorDetails.Builder> exportErrorDetails) {
            return exportErrorDetails(VectorEnrichmentJobExportErrorDetails.builder().applyMutation(exportErrorDetails).build());
        }

        /**
         * <p>
         * The export status of the Vector Enrichment job being initiated.
         * </p>
         * 
         * @param exportStatus
         *        The export status of the Vector Enrichment job being initiated.
         * @see VectorEnrichmentJobExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VectorEnrichmentJobExportStatus
         */
        Builder exportStatus(String exportStatus);

        /**
         * <p>
         * The export status of the Vector Enrichment job being initiated.
         * </p>
         * 
         * @param exportStatus
         *        The export status of the Vector Enrichment job being initiated.
         * @see VectorEnrichmentJobExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VectorEnrichmentJobExportStatus
         */
        Builder exportStatus(VectorEnrichmentJobExportStatus exportStatus);

        /**
         * <p>
         * Input configuration information for the Vector Enrichment job.
         * </p>
         * 
         * @param inputConfig
         *        Input configuration information for the Vector Enrichment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(VectorEnrichmentJobInputConfig inputConfig);

        /**
         * <p>
         * Input configuration information for the Vector Enrichment job.
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorEnrichmentJobInputConfig.Builder}
         * avoiding the need to create one manually via {@link VectorEnrichmentJobInputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorEnrichmentJobInputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputConfig(VectorEnrichmentJobInputConfig)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link VectorEnrichmentJobInputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(VectorEnrichmentJobInputConfig)
         */
        default Builder inputConfig(Consumer<VectorEnrichmentJobInputConfig.Builder> inputConfig) {
            return inputConfig(VectorEnrichmentJobInputConfig.builder().applyMutation(inputConfig).build());
        }

        /**
         * <p>
         * An object containing information about the job configuration.
         * </p>
         * 
         * @param jobConfig
         *        An object containing information about the job configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobConfig(VectorEnrichmentJobConfig jobConfig);

        /**
         * <p>
         * An object containing information about the job configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorEnrichmentJobConfig.Builder}
         * avoiding the need to create one manually via {@link VectorEnrichmentJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorEnrichmentJobConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #jobConfig(VectorEnrichmentJobConfig)}.
         * 
         * @param jobConfig
         *        a consumer that will call methods on {@link VectorEnrichmentJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobConfig(VectorEnrichmentJobConfig)
         */
        default Builder jobConfig(Consumer<VectorEnrichmentJobConfig.Builder> jobConfig) {
            return jobConfig(VectorEnrichmentJobConfig.builder().applyMutation(jobConfig).build());
        }

        /**
         * <p>
         * The Key Management Service key ID for server-side encryption.
         * </p>
         * 
         * @param kmsKeyId
         *        The Key Management Service key ID for server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The name of the Vector Enrichment job.
         * </p>
         * 
         * @param name
         *        The name of the Vector Enrichment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the initiated Vector Enrichment job.
         * </p>
         * 
         * @param status
         *        The status of the initiated Vector Enrichment job.
         * @see VectorEnrichmentJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VectorEnrichmentJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the initiated Vector Enrichment job.
         * </p>
         * 
         * @param status
         *        The status of the initiated Vector Enrichment job.
         * @see VectorEnrichmentJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VectorEnrichmentJobStatus
         */
        Builder status(VectorEnrichmentJobStatus status);

        /**
         * <p>
         * Each tag consists of a key and a value.
         * </p>
         * 
         * @param tags
         *        Each tag consists of a key and a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of the Vector Enrichment job being initiated.
         * </p>
         * 
         * @param type
         *        The type of the Vector Enrichment job being initiated.
         * @see VectorEnrichmentJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VectorEnrichmentJobType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the Vector Enrichment job being initiated.
         * </p>
         * 
         * @param type
         *        The type of the Vector Enrichment job being initiated.
         * @see VectorEnrichmentJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VectorEnrichmentJobType
         */
        Builder type(VectorEnrichmentJobType type);
    }

    static final class BuilderImpl extends SageMakerGeospatialResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private Integer durationInSeconds;

        private VectorEnrichmentJobErrorDetails errorDetails;

        private String executionRoleArn;

        private VectorEnrichmentJobExportErrorDetails exportErrorDetails;

        private String exportStatus;

        private VectorEnrichmentJobInputConfig inputConfig;

        private VectorEnrichmentJobConfig jobConfig;

        private String kmsKeyId;

        private String name;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVectorEnrichmentJobResponse model) {
            super(model);
            arn(model.arn);
            creationTime(model.creationTime);
            durationInSeconds(model.durationInSeconds);
            errorDetails(model.errorDetails);
            executionRoleArn(model.executionRoleArn);
            exportErrorDetails(model.exportErrorDetails);
            exportStatus(model.exportStatus);
            inputConfig(model.inputConfig);
            jobConfig(model.jobConfig);
            kmsKeyId(model.kmsKeyId);
            name(model.name);
            status(model.status);
            tags(model.tags);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final VectorEnrichmentJobErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(VectorEnrichmentJobErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(VectorEnrichmentJobErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final VectorEnrichmentJobExportErrorDetails.Builder getExportErrorDetails() {
            return exportErrorDetails != null ? exportErrorDetails.toBuilder() : null;
        }

        public final void setExportErrorDetails(VectorEnrichmentJobExportErrorDetails.BuilderImpl exportErrorDetails) {
            this.exportErrorDetails = exportErrorDetails != null ? exportErrorDetails.build() : null;
        }

        @Override
        public final Builder exportErrorDetails(VectorEnrichmentJobExportErrorDetails exportErrorDetails) {
            this.exportErrorDetails = exportErrorDetails;
            return this;
        }

        public final String getExportStatus() {
            return exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(VectorEnrichmentJobExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final VectorEnrichmentJobInputConfig.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(VectorEnrichmentJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(VectorEnrichmentJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final VectorEnrichmentJobConfig.Builder getJobConfig() {
            return jobConfig != null ? jobConfig.toBuilder() : null;
        }

        public final void setJobConfig(VectorEnrichmentJobConfig.BuilderImpl jobConfig) {
            this.jobConfig = jobConfig != null ? jobConfig.build() : null;
        }

        @Override
        public final Builder jobConfig(VectorEnrichmentJobConfig jobConfig) {
            this.jobConfig = jobConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VectorEnrichmentJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(VectorEnrichmentJobType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetVectorEnrichmentJobResponse build() {
            return new GetVectorEnrichmentJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
