/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing Polygon Geometry based on the <a
 * href="https://www.rfc-editor.org/rfc/rfc7946#section-3.1.6">GeoJson spec</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiPolygonGeometryInput implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiPolygonGeometryInput.Builder, MultiPolygonGeometryInput> {
    private static final SdkField<List<List<List<List<Double>>>>> COORDINATES_FIELD = SdkField
            .<List<List<List<List<Double>>>>> builder(MarshallingType.LIST)
            .memberName("Coordinates")
            .getter(getter(MultiPolygonGeometryInput::coordinates))
            .setter(setter(Builder::coordinates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Coordinates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<List<List<Double>>>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<List<List<Double>>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<List<Double>> builder(
                                                                                                            MarshallingType.LIST)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build(),
                                                                                                                    ListTrait
                                                                                                                            .builder()
                                                                                                                            .memberLocationName(
                                                                                                                                    null)
                                                                                                                            .memberFieldInfo(
                                                                                                                                    SdkField.<Double> builder(
                                                                                                                                            MarshallingType.DOUBLE)
                                                                                                                                            .traits(LocationTrait
                                                                                                                                                    .builder()
                                                                                                                                                    .location(
                                                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                                                    .locationName(
                                                                                                                                                            "member")
                                                                                                                                                    .build())
                                                                                                                                            .build())
                                                                                                                            .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COORDINATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<List<List<List<Double>>>> coordinates;

    private MultiPolygonGeometryInput(BuilderImpl builder) {
        this.coordinates = builder.coordinates;
    }

    /**
     * For responses, this returns true if the service returned a value for the Coordinates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCoordinates() {
        return coordinates != null && !(coordinates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The coordinates of the multipolygon geometry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCoordinates} method.
     * </p>
     * 
     * @return The coordinates of the multipolygon geometry.
     */
    public final List<List<List<List<Double>>>> coordinates() {
        return coordinates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCoordinates() ? coordinates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiPolygonGeometryInput)) {
            return false;
        }
        MultiPolygonGeometryInput other = (MultiPolygonGeometryInput) obj;
        return hasCoordinates() == other.hasCoordinates() && Objects.equals(coordinates(), other.coordinates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiPolygonGeometryInput")
                .add("Coordinates", coordinates() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Coordinates":
            return Optional.ofNullable(clazz.cast(coordinates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Coordinates", COORDINATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiPolygonGeometryInput, T> g) {
        return obj -> g.apply((MultiPolygonGeometryInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiPolygonGeometryInput> {
        /**
         * <p>
         * The coordinates of the multipolygon geometry.
         * </p>
         * 
         * @param coordinates
         *        The coordinates of the multipolygon geometry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coordinates(Collection<? extends Collection<? extends Collection<? extends Collection<Double>>>> coordinates);

        /**
         * <p>
         * The coordinates of the multipolygon geometry.
         * </p>
         * 
         * @param coordinates
         *        The coordinates of the multipolygon geometry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coordinates(Collection<? extends Collection<? extends Collection<Double>>>... coordinates);
    }

    static final class BuilderImpl implements Builder {
        private List<List<List<List<Double>>>> coordinates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MultiPolygonGeometryInput model) {
            coordinates(model.coordinates);
        }

        public final Collection<? extends Collection<? extends Collection<? extends Collection<Double>>>> getCoordinates() {
            if (coordinates instanceof SdkAutoConstructList) {
                return null;
            }
            return coordinates;
        }

        public final void setCoordinates(
                Collection<? extends Collection<? extends Collection<? extends Collection<Double>>>> coordinates) {
            this.coordinates = LinearRingsListCopier.copy(coordinates);
        }

        @Override
        public final Builder coordinates(
                Collection<? extends Collection<? extends Collection<? extends Collection<Double>>>> coordinates) {
            this.coordinates = LinearRingsListCopier.copy(coordinates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coordinates(Collection<? extends Collection<? extends Collection<Double>>>... coordinates) {
            coordinates(Arrays.asList(coordinates));
            return this;
        }

        @Override
        public MultiPolygonGeometryInput build() {
            return new MultiPolygonGeometryInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
