/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an arithmetic operation to compute spectral index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Operation implements SdkPojo, Serializable, ToCopyableBuilder<Operation.Builder, Operation> {
    private static final SdkField<String> EQUATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Equation").getter(getter(Operation::equation)).setter(setter(Builder::equation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Equation").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Operation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputType").getter(getter(Operation::outputTypeAsString)).setter(setter(Builder::outputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQUATION_FIELD, NAME_FIELD,
            OUTPUT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String equation;

    private final String name;

    private final String outputType;

    private Operation(BuilderImpl builder) {
        this.equation = builder.equation;
        this.name = builder.name;
        this.outputType = builder.outputType;
    }

    /**
     * <p>
     * Textual representation of the math operation; Equation used to compute the spectral index.
     * </p>
     * 
     * @return Textual representation of the math operation; Equation used to compute the spectral index.
     */
    public final String equation() {
        return equation;
    }

    /**
     * <p>
     * The name of the operation.
     * </p>
     * 
     * @return The name of the operation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputType} will
     * return {@link OutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputTypeAsString}.
     * </p>
     * 
     * @return The type of the operation.
     * @see OutputType
     */
    public final OutputType outputType() {
        return OutputType.fromValue(outputType);
    }

    /**
     * <p>
     * The type of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputType} will
     * return {@link OutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputTypeAsString}.
     * </p>
     * 
     * @return The type of the operation.
     * @see OutputType
     */
    public final String outputTypeAsString() {
        return outputType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(equation());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(outputTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation) obj;
        return Objects.equals(equation(), other.equation()) && Objects.equals(name(), other.name())
                && Objects.equals(outputTypeAsString(), other.outputTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Operation").add("Equation", equation()).add("Name", name())
                .add("OutputType", outputTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Equation":
            return Optional.ofNullable(clazz.cast(equation()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OutputType":
            return Optional.ofNullable(clazz.cast(outputTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Equation", EQUATION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("OutputType", OUTPUT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Operation, T> g) {
        return obj -> g.apply((Operation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Operation> {
        /**
         * <p>
         * Textual representation of the math operation; Equation used to compute the spectral index.
         * </p>
         * 
         * @param equation
         *        Textual representation of the math operation; Equation used to compute the spectral index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equation(String equation);

        /**
         * <p>
         * The name of the operation.
         * </p>
         * 
         * @param name
         *        The name of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the operation.
         * </p>
         * 
         * @param outputType
         *        The type of the operation.
         * @see OutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputType
         */
        Builder outputType(String outputType);

        /**
         * <p>
         * The type of the operation.
         * </p>
         * 
         * @param outputType
         *        The type of the operation.
         * @see OutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputType
         */
        Builder outputType(OutputType outputType);
    }

    static final class BuilderImpl implements Builder {
        private String equation;

        private String name;

        private String outputType;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            equation(model.equation);
            name(model.name);
            outputType(model.outputType);
        }

        public final String getEquation() {
            return equation;
        }

        public final void setEquation(String equation) {
            this.equation = equation;
        }

        @Override
        public final Builder equation(String equation) {
            this.equation = equation;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOutputType() {
            return outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(OutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        @Override
        public Operation build() {
            return new Operation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
