/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input structure representing Output Resolution for Stacking Operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputResolutionStackInput implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputResolutionStackInput.Builder, OutputResolutionStackInput> {
    private static final SdkField<String> PREDEFINED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Predefined").getter(getter(OutputResolutionStackInput::predefinedAsString))
            .setter(setter(Builder::predefined))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predefined").build()).build();

    private static final SdkField<UserDefined> USER_DEFINED_FIELD = SdkField.<UserDefined> builder(MarshallingType.SDK_POJO)
            .memberName("UserDefined").getter(getter(OutputResolutionStackInput::userDefined))
            .setter(setter(Builder::userDefined)).constructor(UserDefined::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefined").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_FIELD,
            USER_DEFINED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String predefined;

    private final UserDefined userDefined;

    private OutputResolutionStackInput(BuilderImpl builder) {
        this.predefined = builder.predefined;
        this.userDefined = builder.userDefined;
    }

    /**
     * <p>
     * A string value representing Predefined Output Resolution for a stacking operation. Allowed values are
     * <code>HIGHEST</code>, <code>LOWEST</code>, and <code>AVERAGE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #predefined} will
     * return {@link PredefinedResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #predefinedAsString}.
     * </p>
     * 
     * @return A string value representing Predefined Output Resolution for a stacking operation. Allowed values are
     *         <code>HIGHEST</code>, <code>LOWEST</code>, and <code>AVERAGE</code>.
     * @see PredefinedResolution
     */
    public final PredefinedResolution predefined() {
        return PredefinedResolution.fromValue(predefined);
    }

    /**
     * <p>
     * A string value representing Predefined Output Resolution for a stacking operation. Allowed values are
     * <code>HIGHEST</code>, <code>LOWEST</code>, and <code>AVERAGE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #predefined} will
     * return {@link PredefinedResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #predefinedAsString}.
     * </p>
     * 
     * @return A string value representing Predefined Output Resolution for a stacking operation. Allowed values are
     *         <code>HIGHEST</code>, <code>LOWEST</code>, and <code>AVERAGE</code>.
     * @see PredefinedResolution
     */
    public final String predefinedAsString() {
        return predefined;
    }

    /**
     * <p>
     * The structure representing User Output Resolution for a Stacking operation defined as a value and unit.
     * </p>
     * 
     * @return The structure representing User Output Resolution for a Stacking operation defined as a value and unit.
     */
    public final UserDefined userDefined() {
        return userDefined;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predefinedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userDefined());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputResolutionStackInput)) {
            return false;
        }
        OutputResolutionStackInput other = (OutputResolutionStackInput) obj;
        return Objects.equals(predefinedAsString(), other.predefinedAsString())
                && Objects.equals(userDefined(), other.userDefined());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputResolutionStackInput").add("Predefined", predefinedAsString())
                .add("UserDefined", userDefined()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Predefined":
            return Optional.ofNullable(clazz.cast(predefinedAsString()));
        case "UserDefined":
            return Optional.ofNullable(clazz.cast(userDefined()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Predefined", PREDEFINED_FIELD);
        map.put("UserDefined", USER_DEFINED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputResolutionStackInput, T> g) {
        return obj -> g.apply((OutputResolutionStackInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputResolutionStackInput> {
        /**
         * <p>
         * A string value representing Predefined Output Resolution for a stacking operation. Allowed values are
         * <code>HIGHEST</code>, <code>LOWEST</code>, and <code>AVERAGE</code>.
         * </p>
         * 
         * @param predefined
         *        A string value representing Predefined Output Resolution for a stacking operation. Allowed values are
         *        <code>HIGHEST</code>, <code>LOWEST</code>, and <code>AVERAGE</code>.
         * @see PredefinedResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PredefinedResolution
         */
        Builder predefined(String predefined);

        /**
         * <p>
         * A string value representing Predefined Output Resolution for a stacking operation. Allowed values are
         * <code>HIGHEST</code>, <code>LOWEST</code>, and <code>AVERAGE</code>.
         * </p>
         * 
         * @param predefined
         *        A string value representing Predefined Output Resolution for a stacking operation. Allowed values are
         *        <code>HIGHEST</code>, <code>LOWEST</code>, and <code>AVERAGE</code>.
         * @see PredefinedResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PredefinedResolution
         */
        Builder predefined(PredefinedResolution predefined);

        /**
         * <p>
         * The structure representing User Output Resolution for a Stacking operation defined as a value and unit.
         * </p>
         * 
         * @param userDefined
         *        The structure representing User Output Resolution for a Stacking operation defined as a value and
         *        unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefined(UserDefined userDefined);

        /**
         * <p>
         * The structure representing User Output Resolution for a Stacking operation defined as a value and unit.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserDefined.Builder} avoiding the need to
         * create one manually via {@link UserDefined#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserDefined.Builder#build()} is called immediately and its result
         * is passed to {@link #userDefined(UserDefined)}.
         * 
         * @param userDefined
         *        a consumer that will call methods on {@link UserDefined.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userDefined(UserDefined)
         */
        default Builder userDefined(Consumer<UserDefined.Builder> userDefined) {
            return userDefined(UserDefined.builder().applyMutation(userDefined).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String predefined;

        private UserDefined userDefined;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputResolutionStackInput model) {
            predefined(model.predefined);
            userDefined(model.userDefined);
        }

        public final String getPredefined() {
            return predefined;
        }

        public final void setPredefined(String predefined) {
            this.predefined = predefined;
        }

        @Override
        public final Builder predefined(String predefined) {
            this.predefined = predefined;
            return this;
        }

        @Override
        public final Builder predefined(PredefinedResolution predefined) {
            this.predefined(predefined == null ? null : predefined.toString());
            return this;
        }

        public final UserDefined.Builder getUserDefined() {
            return userDefined != null ? userDefined.toBuilder() : null;
        }

        public final void setUserDefined(UserDefined.BuilderImpl userDefined) {
            this.userDefined = userDefined != null ? userDefined.build() : null;
        }

        @Override
        public final Builder userDefined(UserDefined userDefined) {
            this.userDefined = userDefined;
            return this;
        }

        @Override
        public OutputResolutionStackInput build() {
            return new OutputResolutionStackInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
