/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single searchable property to search on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Property implements SdkPojo, Serializable, ToCopyableBuilder<Property.Builder, Property> {
    private static final SdkField<EoCloudCoverInput> EO_CLOUD_COVER_FIELD = SdkField
            .<EoCloudCoverInput> builder(MarshallingType.SDK_POJO).memberName("EoCloudCover")
            .getter(getter(Property::eoCloudCover)).setter(setter(Builder::eoCloudCover)).constructor(EoCloudCoverInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EoCloudCover").build()).build();

    private static final SdkField<LandsatCloudCoverLandInput> LANDSAT_CLOUD_COVER_LAND_FIELD = SdkField
            .<LandsatCloudCoverLandInput> builder(MarshallingType.SDK_POJO).memberName("LandsatCloudCoverLand")
            .getter(getter(Property::landsatCloudCoverLand)).setter(setter(Builder::landsatCloudCoverLand))
            .constructor(LandsatCloudCoverLandInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LandsatCloudCoverLand").build())
            .build();

    private static final SdkField<PlatformInput> PLATFORM_FIELD = SdkField.<PlatformInput> builder(MarshallingType.SDK_POJO)
            .memberName("Platform").getter(getter(Property::platform)).setter(setter(Builder::platform))
            .constructor(PlatformInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<ViewOffNadirInput> VIEW_OFF_NADIR_FIELD = SdkField
            .<ViewOffNadirInput> builder(MarshallingType.SDK_POJO).memberName("ViewOffNadir")
            .getter(getter(Property::viewOffNadir)).setter(setter(Builder::viewOffNadir)).constructor(ViewOffNadirInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewOffNadir").build()).build();

    private static final SdkField<ViewSunAzimuthInput> VIEW_SUN_AZIMUTH_FIELD = SdkField
            .<ViewSunAzimuthInput> builder(MarshallingType.SDK_POJO).memberName("ViewSunAzimuth")
            .getter(getter(Property::viewSunAzimuth)).setter(setter(Builder::viewSunAzimuth))
            .constructor(ViewSunAzimuthInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewSunAzimuth").build()).build();

    private static final SdkField<ViewSunElevationInput> VIEW_SUN_ELEVATION_FIELD = SdkField
            .<ViewSunElevationInput> builder(MarshallingType.SDK_POJO).memberName("ViewSunElevation")
            .getter(getter(Property::viewSunElevation)).setter(setter(Builder::viewSunElevation))
            .constructor(ViewSunElevationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewSunElevation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EO_CLOUD_COVER_FIELD,
            LANDSAT_CLOUD_COVER_LAND_FIELD, PLATFORM_FIELD, VIEW_OFF_NADIR_FIELD, VIEW_SUN_AZIMUTH_FIELD,
            VIEW_SUN_ELEVATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EoCloudCoverInput eoCloudCover;

    private final LandsatCloudCoverLandInput landsatCloudCoverLand;

    private final PlatformInput platform;

    private final ViewOffNadirInput viewOffNadir;

    private final ViewSunAzimuthInput viewSunAzimuth;

    private final ViewSunElevationInput viewSunElevation;

    private final Type type;

    private Property(BuilderImpl builder) {
        this.eoCloudCover = builder.eoCloudCover;
        this.landsatCloudCoverLand = builder.landsatCloudCoverLand;
        this.platform = builder.platform;
        this.viewOffNadir = builder.viewOffNadir;
        this.viewSunAzimuth = builder.viewSunAzimuth;
        this.viewSunElevation = builder.viewSunElevation;
        this.type = builder.type;
    }

    /**
     * <p>
     * The structure representing EoCloudCover property filter containing a lower bound and upper bound.
     * </p>
     * 
     * @return The structure representing EoCloudCover property filter containing a lower bound and upper bound.
     */
    public final EoCloudCoverInput eoCloudCover() {
        return eoCloudCover;
    }

    /**
     * <p>
     * The structure representing Land Cloud Cover property filter for Landsat collection containing a lower bound and
     * upper bound.
     * </p>
     * 
     * @return The structure representing Land Cloud Cover property filter for Landsat collection containing a lower
     *         bound and upper bound.
     */
    public final LandsatCloudCoverLandInput landsatCloudCoverLand() {
        return landsatCloudCoverLand;
    }

    /**
     * <p>
     * The structure representing Platform property filter consisting of value and comparison operator.
     * </p>
     * 
     * @return The structure representing Platform property filter consisting of value and comparison operator.
     */
    public final PlatformInput platform() {
        return platform;
    }

    /**
     * <p>
     * The structure representing ViewOffNadir property filter containing a lower bound and upper bound.
     * </p>
     * 
     * @return The structure representing ViewOffNadir property filter containing a lower bound and upper bound.
     */
    public final ViewOffNadirInput viewOffNadir() {
        return viewOffNadir;
    }

    /**
     * <p>
     * The structure representing ViewSunAzimuth property filter containing a lower bound and upper bound.
     * </p>
     * 
     * @return The structure representing ViewSunAzimuth property filter containing a lower bound and upper bound.
     */
    public final ViewSunAzimuthInput viewSunAzimuth() {
        return viewSunAzimuth;
    }

    /**
     * <p>
     * The structure representing ViewSunElevation property filter containing a lower bound and upper bound.
     * </p>
     * 
     * @return The structure representing ViewSunElevation property filter containing a lower bound and upper bound.
     */
    public final ViewSunElevationInput viewSunElevation() {
        return viewSunElevation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eoCloudCover());
        hashCode = 31 * hashCode + Objects.hashCode(landsatCloudCoverLand());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(viewOffNadir());
        hashCode = 31 * hashCode + Objects.hashCode(viewSunAzimuth());
        hashCode = 31 * hashCode + Objects.hashCode(viewSunElevation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property other = (Property) obj;
        return Objects.equals(eoCloudCover(), other.eoCloudCover())
                && Objects.equals(landsatCloudCoverLand(), other.landsatCloudCoverLand())
                && Objects.equals(platform(), other.platform()) && Objects.equals(viewOffNadir(), other.viewOffNadir())
                && Objects.equals(viewSunAzimuth(), other.viewSunAzimuth())
                && Objects.equals(viewSunElevation(), other.viewSunElevation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Property").add("EoCloudCover", eoCloudCover())
                .add("LandsatCloudCoverLand", landsatCloudCoverLand()).add("Platform", platform())
                .add("ViewOffNadir", viewOffNadir()).add("ViewSunAzimuth", viewSunAzimuth())
                .add("ViewSunElevation", viewSunElevation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EoCloudCover":
            return Optional.ofNullable(clazz.cast(eoCloudCover()));
        case "LandsatCloudCoverLand":
            return Optional.ofNullable(clazz.cast(landsatCloudCoverLand()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "ViewOffNadir":
            return Optional.ofNullable(clazz.cast(viewOffNadir()));
        case "ViewSunAzimuth":
            return Optional.ofNullable(clazz.cast(viewSunAzimuth()));
        case "ViewSunElevation":
            return Optional.ofNullable(clazz.cast(viewSunElevation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #eoCloudCover()} initialized to the given value.
     *
     * <p>
     * The structure representing EoCloudCover property filter containing a lower bound and upper bound.
     * </p>
     * 
     * @param eoCloudCover
     *        The structure representing EoCloudCover property filter containing a lower bound and upper bound.
     */
    public static Property fromEoCloudCover(EoCloudCoverInput eoCloudCover) {
        return builder().eoCloudCover(eoCloudCover).build();
    }

    /**
     * Create an instance of this class with {@link #eoCloudCover()} initialized to the given value.
     *
     * <p>
     * The structure representing EoCloudCover property filter containing a lower bound and upper bound.
     * </p>
     * 
     * @param eoCloudCover
     *        The structure representing EoCloudCover property filter containing a lower bound and upper bound.
     */
    public static Property fromEoCloudCover(Consumer<EoCloudCoverInput.Builder> eoCloudCover) {
        EoCloudCoverInput.Builder builder = EoCloudCoverInput.builder();
        eoCloudCover.accept(builder);
        return fromEoCloudCover(builder.build());
    }

    /**
     * Create an instance of this class with {@link #landsatCloudCoverLand()} initialized to the given value.
     *
     * <p>
     * The structure representing Land Cloud Cover property filter for Landsat collection containing a lower bound and
     * upper bound.
     * </p>
     * 
     * @param landsatCloudCoverLand
     *        The structure representing Land Cloud Cover property filter for Landsat collection containing a lower
     *        bound and upper bound.
     */
    public static Property fromLandsatCloudCoverLand(LandsatCloudCoverLandInput landsatCloudCoverLand) {
        return builder().landsatCloudCoverLand(landsatCloudCoverLand).build();
    }

    /**
     * Create an instance of this class with {@link #landsatCloudCoverLand()} initialized to the given value.
     *
     * <p>
     * The structure representing Land Cloud Cover property filter for Landsat collection containing a lower bound and
     * upper bound.
     * </p>
     * 
     * @param landsatCloudCoverLand
     *        The structure representing Land Cloud Cover property filter for Landsat collection containing a lower
     *        bound and upper bound.
     */
    public static Property fromLandsatCloudCoverLand(Consumer<LandsatCloudCoverLandInput.Builder> landsatCloudCoverLand) {
        LandsatCloudCoverLandInput.Builder builder = LandsatCloudCoverLandInput.builder();
        landsatCloudCoverLand.accept(builder);
        return fromLandsatCloudCoverLand(builder.build());
    }

    /**
     * Create an instance of this class with {@link #platform()} initialized to the given value.
     *
     * <p>
     * The structure representing Platform property filter consisting of value and comparison operator.
     * </p>
     * 
     * @param platform
     *        The structure representing Platform property filter consisting of value and comparison operator.
     */
    public static Property fromPlatform(PlatformInput platform) {
        return builder().platform(platform).build();
    }

    /**
     * Create an instance of this class with {@link #platform()} initialized to the given value.
     *
     * <p>
     * The structure representing Platform property filter consisting of value and comparison operator.
     * </p>
     * 
     * @param platform
     *        The structure representing Platform property filter consisting of value and comparison operator.
     */
    public static Property fromPlatform(Consumer<PlatformInput.Builder> platform) {
        PlatformInput.Builder builder = PlatformInput.builder();
        platform.accept(builder);
        return fromPlatform(builder.build());
    }

    /**
     * Create an instance of this class with {@link #viewOffNadir()} initialized to the given value.
     *
     * <p>
     * The structure representing ViewOffNadir property filter containing a lower bound and upper bound.
     * </p>
     * 
     * @param viewOffNadir
     *        The structure representing ViewOffNadir property filter containing a lower bound and upper bound.
     */
    public static Property fromViewOffNadir(ViewOffNadirInput viewOffNadir) {
        return builder().viewOffNadir(viewOffNadir).build();
    }

    /**
     * Create an instance of this class with {@link #viewOffNadir()} initialized to the given value.
     *
     * <p>
     * The structure representing ViewOffNadir property filter containing a lower bound and upper bound.
     * </p>
     * 
     * @param viewOffNadir
     *        The structure representing ViewOffNadir property filter containing a lower bound and upper bound.
     */
    public static Property fromViewOffNadir(Consumer<ViewOffNadirInput.Builder> viewOffNadir) {
        ViewOffNadirInput.Builder builder = ViewOffNadirInput.builder();
        viewOffNadir.accept(builder);
        return fromViewOffNadir(builder.build());
    }

    /**
     * Create an instance of this class with {@link #viewSunAzimuth()} initialized to the given value.
     *
     * <p>
     * The structure representing ViewSunAzimuth property filter containing a lower bound and upper bound.
     * </p>
     * 
     * @param viewSunAzimuth
     *        The structure representing ViewSunAzimuth property filter containing a lower bound and upper bound.
     */
    public static Property fromViewSunAzimuth(ViewSunAzimuthInput viewSunAzimuth) {
        return builder().viewSunAzimuth(viewSunAzimuth).build();
    }

    /**
     * Create an instance of this class with {@link #viewSunAzimuth()} initialized to the given value.
     *
     * <p>
     * The structure representing ViewSunAzimuth property filter containing a lower bound and upper bound.
     * </p>
     * 
     * @param viewSunAzimuth
     *        The structure representing ViewSunAzimuth property filter containing a lower bound and upper bound.
     */
    public static Property fromViewSunAzimuth(Consumer<ViewSunAzimuthInput.Builder> viewSunAzimuth) {
        ViewSunAzimuthInput.Builder builder = ViewSunAzimuthInput.builder();
        viewSunAzimuth.accept(builder);
        return fromViewSunAzimuth(builder.build());
    }

    /**
     * Create an instance of this class with {@link #viewSunElevation()} initialized to the given value.
     *
     * <p>
     * The structure representing ViewSunElevation property filter containing a lower bound and upper bound.
     * </p>
     * 
     * @param viewSunElevation
     *        The structure representing ViewSunElevation property filter containing a lower bound and upper bound.
     */
    public static Property fromViewSunElevation(ViewSunElevationInput viewSunElevation) {
        return builder().viewSunElevation(viewSunElevation).build();
    }

    /**
     * Create an instance of this class with {@link #viewSunElevation()} initialized to the given value.
     *
     * <p>
     * The structure representing ViewSunElevation property filter containing a lower bound and upper bound.
     * </p>
     * 
     * @param viewSunElevation
     *        The structure representing ViewSunElevation property filter containing a lower bound and upper bound.
     */
    public static Property fromViewSunElevation(Consumer<ViewSunElevationInput.Builder> viewSunElevation) {
        ViewSunElevationInput.Builder builder = ViewSunElevationInput.builder();
        viewSunElevation.accept(builder);
        return fromViewSunElevation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EoCloudCover", EO_CLOUD_COVER_FIELD);
        map.put("LandsatCloudCoverLand", LANDSAT_CLOUD_COVER_LAND_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("ViewOffNadir", VIEW_OFF_NADIR_FIELD);
        map.put("ViewSunAzimuth", VIEW_SUN_AZIMUTH_FIELD);
        map.put("ViewSunElevation", VIEW_SUN_ELEVATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Property, T> g) {
        return obj -> g.apply((Property) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Property> {
        /**
         * <p>
         * The structure representing EoCloudCover property filter containing a lower bound and upper bound.
         * </p>
         * 
         * @param eoCloudCover
         *        The structure representing EoCloudCover property filter containing a lower bound and upper bound.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eoCloudCover(EoCloudCoverInput eoCloudCover);

        /**
         * <p>
         * The structure representing EoCloudCover property filter containing a lower bound and upper bound.
         * </p>
         * This is a convenience method that creates an instance of the {@link EoCloudCoverInput.Builder} avoiding the
         * need to create one manually via {@link EoCloudCoverInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EoCloudCoverInput.Builder#build()} is called immediately and its
         * result is passed to {@link #eoCloudCover(EoCloudCoverInput)}.
         * 
         * @param eoCloudCover
         *        a consumer that will call methods on {@link EoCloudCoverInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eoCloudCover(EoCloudCoverInput)
         */
        default Builder eoCloudCover(Consumer<EoCloudCoverInput.Builder> eoCloudCover) {
            return eoCloudCover(EoCloudCoverInput.builder().applyMutation(eoCloudCover).build());
        }

        /**
         * <p>
         * The structure representing Land Cloud Cover property filter for Landsat collection containing a lower bound
         * and upper bound.
         * </p>
         * 
         * @param landsatCloudCoverLand
         *        The structure representing Land Cloud Cover property filter for Landsat collection containing a lower
         *        bound and upper bound.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landsatCloudCoverLand(LandsatCloudCoverLandInput landsatCloudCoverLand);

        /**
         * <p>
         * The structure representing Land Cloud Cover property filter for Landsat collection containing a lower bound
         * and upper bound.
         * </p>
         * This is a convenience method that creates an instance of the {@link LandsatCloudCoverLandInput.Builder}
         * avoiding the need to create one manually via {@link LandsatCloudCoverLandInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LandsatCloudCoverLandInput.Builder#build()} is called immediately
         * and its result is passed to {@link #landsatCloudCoverLand(LandsatCloudCoverLandInput)}.
         * 
         * @param landsatCloudCoverLand
         *        a consumer that will call methods on {@link LandsatCloudCoverLandInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #landsatCloudCoverLand(LandsatCloudCoverLandInput)
         */
        default Builder landsatCloudCoverLand(Consumer<LandsatCloudCoverLandInput.Builder> landsatCloudCoverLand) {
            return landsatCloudCoverLand(LandsatCloudCoverLandInput.builder().applyMutation(landsatCloudCoverLand).build());
        }

        /**
         * <p>
         * The structure representing Platform property filter consisting of value and comparison operator.
         * </p>
         * 
         * @param platform
         *        The structure representing Platform property filter consisting of value and comparison operator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(PlatformInput platform);

        /**
         * <p>
         * The structure representing Platform property filter consisting of value and comparison operator.
         * </p>
         * This is a convenience method that creates an instance of the {@link PlatformInput.Builder} avoiding the need
         * to create one manually via {@link PlatformInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PlatformInput.Builder#build()} is called immediately and its
         * result is passed to {@link #platform(PlatformInput)}.
         * 
         * @param platform
         *        a consumer that will call methods on {@link PlatformInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platform(PlatformInput)
         */
        default Builder platform(Consumer<PlatformInput.Builder> platform) {
            return platform(PlatformInput.builder().applyMutation(platform).build());
        }

        /**
         * <p>
         * The structure representing ViewOffNadir property filter containing a lower bound and upper bound.
         * </p>
         * 
         * @param viewOffNadir
         *        The structure representing ViewOffNadir property filter containing a lower bound and upper bound.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewOffNadir(ViewOffNadirInput viewOffNadir);

        /**
         * <p>
         * The structure representing ViewOffNadir property filter containing a lower bound and upper bound.
         * </p>
         * This is a convenience method that creates an instance of the {@link ViewOffNadirInput.Builder} avoiding the
         * need to create one manually via {@link ViewOffNadirInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViewOffNadirInput.Builder#build()} is called immediately and its
         * result is passed to {@link #viewOffNadir(ViewOffNadirInput)}.
         * 
         * @param viewOffNadir
         *        a consumer that will call methods on {@link ViewOffNadirInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewOffNadir(ViewOffNadirInput)
         */
        default Builder viewOffNadir(Consumer<ViewOffNadirInput.Builder> viewOffNadir) {
            return viewOffNadir(ViewOffNadirInput.builder().applyMutation(viewOffNadir).build());
        }

        /**
         * <p>
         * The structure representing ViewSunAzimuth property filter containing a lower bound and upper bound.
         * </p>
         * 
         * @param viewSunAzimuth
         *        The structure representing ViewSunAzimuth property filter containing a lower bound and upper bound.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewSunAzimuth(ViewSunAzimuthInput viewSunAzimuth);

        /**
         * <p>
         * The structure representing ViewSunAzimuth property filter containing a lower bound and upper bound.
         * </p>
         * This is a convenience method that creates an instance of the {@link ViewSunAzimuthInput.Builder} avoiding the
         * need to create one manually via {@link ViewSunAzimuthInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViewSunAzimuthInput.Builder#build()} is called immediately and
         * its result is passed to {@link #viewSunAzimuth(ViewSunAzimuthInput)}.
         * 
         * @param viewSunAzimuth
         *        a consumer that will call methods on {@link ViewSunAzimuthInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewSunAzimuth(ViewSunAzimuthInput)
         */
        default Builder viewSunAzimuth(Consumer<ViewSunAzimuthInput.Builder> viewSunAzimuth) {
            return viewSunAzimuth(ViewSunAzimuthInput.builder().applyMutation(viewSunAzimuth).build());
        }

        /**
         * <p>
         * The structure representing ViewSunElevation property filter containing a lower bound and upper bound.
         * </p>
         * 
         * @param viewSunElevation
         *        The structure representing ViewSunElevation property filter containing a lower bound and upper bound.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewSunElevation(ViewSunElevationInput viewSunElevation);

        /**
         * <p>
         * The structure representing ViewSunElevation property filter containing a lower bound and upper bound.
         * </p>
         * This is a convenience method that creates an instance of the {@link ViewSunElevationInput.Builder} avoiding
         * the need to create one manually via {@link ViewSunElevationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViewSunElevationInput.Builder#build()} is called immediately and
         * its result is passed to {@link #viewSunElevation(ViewSunElevationInput)}.
         * 
         * @param viewSunElevation
         *        a consumer that will call methods on {@link ViewSunElevationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewSunElevation(ViewSunElevationInput)
         */
        default Builder viewSunElevation(Consumer<ViewSunElevationInput.Builder> viewSunElevation) {
            return viewSunElevation(ViewSunElevationInput.builder().applyMutation(viewSunElevation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EoCloudCoverInput eoCloudCover;

        private LandsatCloudCoverLandInput landsatCloudCoverLand;

        private PlatformInput platform;

        private ViewOffNadirInput viewOffNadir;

        private ViewSunAzimuthInput viewSunAzimuth;

        private ViewSunElevationInput viewSunElevation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Property model) {
            eoCloudCover(model.eoCloudCover);
            landsatCloudCoverLand(model.landsatCloudCoverLand);
            platform(model.platform);
            viewOffNadir(model.viewOffNadir);
            viewSunAzimuth(model.viewSunAzimuth);
            viewSunElevation(model.viewSunElevation);
        }

        public final EoCloudCoverInput.Builder getEoCloudCover() {
            return eoCloudCover != null ? eoCloudCover.toBuilder() : null;
        }

        public final void setEoCloudCover(EoCloudCoverInput.BuilderImpl eoCloudCover) {
            Object oldValue = this.eoCloudCover;
            this.eoCloudCover = eoCloudCover != null ? eoCloudCover.build() : null;
            handleUnionValueChange(Type.EO_CLOUD_COVER, oldValue, this.eoCloudCover);
        }

        @Override
        public final Builder eoCloudCover(EoCloudCoverInput eoCloudCover) {
            Object oldValue = this.eoCloudCover;
            this.eoCloudCover = eoCloudCover;
            handleUnionValueChange(Type.EO_CLOUD_COVER, oldValue, this.eoCloudCover);
            return this;
        }

        public final LandsatCloudCoverLandInput.Builder getLandsatCloudCoverLand() {
            return landsatCloudCoverLand != null ? landsatCloudCoverLand.toBuilder() : null;
        }

        public final void setLandsatCloudCoverLand(LandsatCloudCoverLandInput.BuilderImpl landsatCloudCoverLand) {
            Object oldValue = this.landsatCloudCoverLand;
            this.landsatCloudCoverLand = landsatCloudCoverLand != null ? landsatCloudCoverLand.build() : null;
            handleUnionValueChange(Type.LANDSAT_CLOUD_COVER_LAND, oldValue, this.landsatCloudCoverLand);
        }

        @Override
        public final Builder landsatCloudCoverLand(LandsatCloudCoverLandInput landsatCloudCoverLand) {
            Object oldValue = this.landsatCloudCoverLand;
            this.landsatCloudCoverLand = landsatCloudCoverLand;
            handleUnionValueChange(Type.LANDSAT_CLOUD_COVER_LAND, oldValue, this.landsatCloudCoverLand);
            return this;
        }

        public final PlatformInput.Builder getPlatform() {
            return platform != null ? platform.toBuilder() : null;
        }

        public final void setPlatform(PlatformInput.BuilderImpl platform) {
            Object oldValue = this.platform;
            this.platform = platform != null ? platform.build() : null;
            handleUnionValueChange(Type.PLATFORM, oldValue, this.platform);
        }

        @Override
        public final Builder platform(PlatformInput platform) {
            Object oldValue = this.platform;
            this.platform = platform;
            handleUnionValueChange(Type.PLATFORM, oldValue, this.platform);
            return this;
        }

        public final ViewOffNadirInput.Builder getViewOffNadir() {
            return viewOffNadir != null ? viewOffNadir.toBuilder() : null;
        }

        public final void setViewOffNadir(ViewOffNadirInput.BuilderImpl viewOffNadir) {
            Object oldValue = this.viewOffNadir;
            this.viewOffNadir = viewOffNadir != null ? viewOffNadir.build() : null;
            handleUnionValueChange(Type.VIEW_OFF_NADIR, oldValue, this.viewOffNadir);
        }

        @Override
        public final Builder viewOffNadir(ViewOffNadirInput viewOffNadir) {
            Object oldValue = this.viewOffNadir;
            this.viewOffNadir = viewOffNadir;
            handleUnionValueChange(Type.VIEW_OFF_NADIR, oldValue, this.viewOffNadir);
            return this;
        }

        public final ViewSunAzimuthInput.Builder getViewSunAzimuth() {
            return viewSunAzimuth != null ? viewSunAzimuth.toBuilder() : null;
        }

        public final void setViewSunAzimuth(ViewSunAzimuthInput.BuilderImpl viewSunAzimuth) {
            Object oldValue = this.viewSunAzimuth;
            this.viewSunAzimuth = viewSunAzimuth != null ? viewSunAzimuth.build() : null;
            handleUnionValueChange(Type.VIEW_SUN_AZIMUTH, oldValue, this.viewSunAzimuth);
        }

        @Override
        public final Builder viewSunAzimuth(ViewSunAzimuthInput viewSunAzimuth) {
            Object oldValue = this.viewSunAzimuth;
            this.viewSunAzimuth = viewSunAzimuth;
            handleUnionValueChange(Type.VIEW_SUN_AZIMUTH, oldValue, this.viewSunAzimuth);
            return this;
        }

        public final ViewSunElevationInput.Builder getViewSunElevation() {
            return viewSunElevation != null ? viewSunElevation.toBuilder() : null;
        }

        public final void setViewSunElevation(ViewSunElevationInput.BuilderImpl viewSunElevation) {
            Object oldValue = this.viewSunElevation;
            this.viewSunElevation = viewSunElevation != null ? viewSunElevation.build() : null;
            handleUnionValueChange(Type.VIEW_SUN_ELEVATION, oldValue, this.viewSunElevation);
        }

        @Override
        public final Builder viewSunElevation(ViewSunElevationInput viewSunElevation) {
            Object oldValue = this.viewSunElevation;
            this.viewSunElevation = viewSunElevation;
            handleUnionValueChange(Type.VIEW_SUN_ELEVATION, oldValue, this.viewSunElevation);
            return this;
        }

        @Override
        public Property build() {
            return new Property(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Property#type()
     */
    public enum Type {
        EO_CLOUD_COVER,

        LANDSAT_CLOUD_COVER_LAND,

        PLATFORM,

        VIEW_OFF_NADIR,

        VIEW_SUN_AZIMUTH,

        VIEW_SUN_ELEVATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
