/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * VectorEnrichmentJob error details in response from GetVectorEnrichmentJob.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VectorEnrichmentJobErrorDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<VectorEnrichmentJobErrorDetails.Builder, VectorEnrichmentJobErrorDetails> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(VectorEnrichmentJobErrorDetails::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorType").getter(getter(VectorEnrichmentJobErrorDetails::errorTypeAsString))
            .setter(setter(Builder::errorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD,
            ERROR_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String errorMessage;

    private final String errorType;

    private VectorEnrichmentJobErrorDetails(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.errorType = builder.errorType;
    }

    /**
     * <p>
     * A message that you define and then is processed and rendered by the Vector Enrichment job when the error occurs.
     * </p>
     * 
     * @return A message that you define and then is processed and rendered by the Vector Enrichment job when the error
     *         occurs.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The type of error generated during the Vector Enrichment job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorType} will
     * return {@link VectorEnrichmentJobErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorTypeAsString}.
     * </p>
     * 
     * @return The type of error generated during the Vector Enrichment job.
     * @see VectorEnrichmentJobErrorType
     */
    public final VectorEnrichmentJobErrorType errorType() {
        return VectorEnrichmentJobErrorType.fromValue(errorType);
    }

    /**
     * <p>
     * The type of error generated during the Vector Enrichment job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorType} will
     * return {@link VectorEnrichmentJobErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorTypeAsString}.
     * </p>
     * 
     * @return The type of error generated during the Vector Enrichment job.
     * @see VectorEnrichmentJobErrorType
     */
    public final String errorTypeAsString() {
        return errorType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorEnrichmentJobErrorDetails)) {
            return false;
        }
        VectorEnrichmentJobErrorDetails other = (VectorEnrichmentJobErrorDetails) obj;
        return Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(errorTypeAsString(), other.errorTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VectorEnrichmentJobErrorDetails").add("ErrorMessage", errorMessage())
                .add("ErrorType", errorTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "ErrorType":
            return Optional.ofNullable(clazz.cast(errorTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("ErrorType", ERROR_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VectorEnrichmentJobErrorDetails, T> g) {
        return obj -> g.apply((VectorEnrichmentJobErrorDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VectorEnrichmentJobErrorDetails> {
        /**
         * <p>
         * A message that you define and then is processed and rendered by the Vector Enrichment job when the error
         * occurs.
         * </p>
         * 
         * @param errorMessage
         *        A message that you define and then is processed and rendered by the Vector Enrichment job when the
         *        error occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The type of error generated during the Vector Enrichment job.
         * </p>
         * 
         * @param errorType
         *        The type of error generated during the Vector Enrichment job.
         * @see VectorEnrichmentJobErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VectorEnrichmentJobErrorType
         */
        Builder errorType(String errorType);

        /**
         * <p>
         * The type of error generated during the Vector Enrichment job.
         * </p>
         * 
         * @param errorType
         *        The type of error generated during the Vector Enrichment job.
         * @see VectorEnrichmentJobErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VectorEnrichmentJobErrorType
         */
        Builder errorType(VectorEnrichmentJobErrorType errorType);
    }

    static final class BuilderImpl implements Builder {
        private String errorMessage;

        private String errorType;

        private BuilderImpl() {
        }

        private BuilderImpl(VectorEnrichmentJobErrorDetails model) {
            errorMessage(model.errorMessage);
            errorType(model.errorType);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorType() {
            return errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public final Builder errorType(VectorEnrichmentJobErrorType errorType) {
            this.errorType(errorType == null ? null : errorType.toString());
            return this;
        }

        @Override
        public VectorEnrichmentJobErrorDetails build() {
            return new VectorEnrichmentJobErrorDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
