/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A GeoJSON object representing the geographic extent in the coordinate space.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AreaOfInterestGeometry implements SdkPojo, Serializable,
        ToCopyableBuilder<AreaOfInterestGeometry.Builder, AreaOfInterestGeometry> {
    private static final SdkField<MultiPolygonGeometryInput> MULTI_POLYGON_GEOMETRY_FIELD = SdkField
            .<MultiPolygonGeometryInput> builder(MarshallingType.SDK_POJO).memberName("MultiPolygonGeometry")
            .getter(getter(AreaOfInterestGeometry::multiPolygonGeometry)).setter(setter(Builder::multiPolygonGeometry))
            .constructor(MultiPolygonGeometryInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiPolygonGeometry").build())
            .build();

    private static final SdkField<PolygonGeometryInput> POLYGON_GEOMETRY_FIELD = SdkField
            .<PolygonGeometryInput> builder(MarshallingType.SDK_POJO).memberName("PolygonGeometry")
            .getter(getter(AreaOfInterestGeometry::polygonGeometry)).setter(setter(Builder::polygonGeometry))
            .constructor(PolygonGeometryInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolygonGeometry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTI_POLYGON_GEOMETRY_FIELD,
            POLYGON_GEOMETRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MultiPolygonGeometryInput multiPolygonGeometry;

    private final PolygonGeometryInput polygonGeometry;

    private final Type type;

    private AreaOfInterestGeometry(BuilderImpl builder) {
        this.multiPolygonGeometry = builder.multiPolygonGeometry;
        this.polygonGeometry = builder.polygonGeometry;
        this.type = builder.type;
    }

    /**
     * <p>
     * The structure representing the MultiPolygon Geometry.
     * </p>
     * 
     * @return The structure representing the MultiPolygon Geometry.
     */
    public final MultiPolygonGeometryInput multiPolygonGeometry() {
        return multiPolygonGeometry;
    }

    /**
     * <p>
     * The structure representing Polygon Geometry.
     * </p>
     * 
     * @return The structure representing Polygon Geometry.
     */
    public final PolygonGeometryInput polygonGeometry() {
        return polygonGeometry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(multiPolygonGeometry());
        hashCode = 31 * hashCode + Objects.hashCode(polygonGeometry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AreaOfInterestGeometry)) {
            return false;
        }
        AreaOfInterestGeometry other = (AreaOfInterestGeometry) obj;
        return Objects.equals(multiPolygonGeometry(), other.multiPolygonGeometry())
                && Objects.equals(polygonGeometry(), other.polygonGeometry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AreaOfInterestGeometry").add("MultiPolygonGeometry", multiPolygonGeometry())
                .add("PolygonGeometry", polygonGeometry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiPolygonGeometry":
            return Optional.ofNullable(clazz.cast(multiPolygonGeometry()));
        case "PolygonGeometry":
            return Optional.ofNullable(clazz.cast(polygonGeometry()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #multiPolygonGeometry()} initialized to the given value.
     *
     * <p>
     * The structure representing the MultiPolygon Geometry.
     * </p>
     * 
     * @param multiPolygonGeometry
     *        The structure representing the MultiPolygon Geometry.
     */
    public static AreaOfInterestGeometry fromMultiPolygonGeometry(MultiPolygonGeometryInput multiPolygonGeometry) {
        return builder().multiPolygonGeometry(multiPolygonGeometry).build();
    }

    /**
     * Create an instance of this class with {@link #multiPolygonGeometry()} initialized to the given value.
     *
     * <p>
     * The structure representing the MultiPolygon Geometry.
     * </p>
     * 
     * @param multiPolygonGeometry
     *        The structure representing the MultiPolygon Geometry.
     */
    public static AreaOfInterestGeometry fromMultiPolygonGeometry(Consumer<MultiPolygonGeometryInput.Builder> multiPolygonGeometry) {
        MultiPolygonGeometryInput.Builder builder = MultiPolygonGeometryInput.builder();
        multiPolygonGeometry.accept(builder);
        return fromMultiPolygonGeometry(builder.build());
    }

    /**
     * Create an instance of this class with {@link #polygonGeometry()} initialized to the given value.
     *
     * <p>
     * The structure representing Polygon Geometry.
     * </p>
     * 
     * @param polygonGeometry
     *        The structure representing Polygon Geometry.
     */
    public static AreaOfInterestGeometry fromPolygonGeometry(PolygonGeometryInput polygonGeometry) {
        return builder().polygonGeometry(polygonGeometry).build();
    }

    /**
     * Create an instance of this class with {@link #polygonGeometry()} initialized to the given value.
     *
     * <p>
     * The structure representing Polygon Geometry.
     * </p>
     * 
     * @param polygonGeometry
     *        The structure representing Polygon Geometry.
     */
    public static AreaOfInterestGeometry fromPolygonGeometry(Consumer<PolygonGeometryInput.Builder> polygonGeometry) {
        PolygonGeometryInput.Builder builder = PolygonGeometryInput.builder();
        polygonGeometry.accept(builder);
        return fromPolygonGeometry(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MultiPolygonGeometry", MULTI_POLYGON_GEOMETRY_FIELD);
        map.put("PolygonGeometry", POLYGON_GEOMETRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AreaOfInterestGeometry, T> g) {
        return obj -> g.apply((AreaOfInterestGeometry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AreaOfInterestGeometry> {
        /**
         * <p>
         * The structure representing the MultiPolygon Geometry.
         * </p>
         * 
         * @param multiPolygonGeometry
         *        The structure representing the MultiPolygon Geometry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiPolygonGeometry(MultiPolygonGeometryInput multiPolygonGeometry);

        /**
         * <p>
         * The structure representing the MultiPolygon Geometry.
         * </p>
         * This is a convenience method that creates an instance of the {@link MultiPolygonGeometryInput.Builder}
         * avoiding the need to create one manually via {@link MultiPolygonGeometryInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiPolygonGeometryInput.Builder#build()} is called immediately
         * and its result is passed to {@link #multiPolygonGeometry(MultiPolygonGeometryInput)}.
         * 
         * @param multiPolygonGeometry
         *        a consumer that will call methods on {@link MultiPolygonGeometryInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiPolygonGeometry(MultiPolygonGeometryInput)
         */
        default Builder multiPolygonGeometry(Consumer<MultiPolygonGeometryInput.Builder> multiPolygonGeometry) {
            return multiPolygonGeometry(MultiPolygonGeometryInput.builder().applyMutation(multiPolygonGeometry).build());
        }

        /**
         * <p>
         * The structure representing Polygon Geometry.
         * </p>
         * 
         * @param polygonGeometry
         *        The structure representing Polygon Geometry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder polygonGeometry(PolygonGeometryInput polygonGeometry);

        /**
         * <p>
         * The structure representing Polygon Geometry.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolygonGeometryInput.Builder} avoiding
         * the need to create one manually via {@link PolygonGeometryInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolygonGeometryInput.Builder#build()} is called immediately and
         * its result is passed to {@link #polygonGeometry(PolygonGeometryInput)}.
         * 
         * @param polygonGeometry
         *        a consumer that will call methods on {@link PolygonGeometryInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #polygonGeometry(PolygonGeometryInput)
         */
        default Builder polygonGeometry(Consumer<PolygonGeometryInput.Builder> polygonGeometry) {
            return polygonGeometry(PolygonGeometryInput.builder().applyMutation(polygonGeometry).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MultiPolygonGeometryInput multiPolygonGeometry;

        private PolygonGeometryInput polygonGeometry;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AreaOfInterestGeometry model) {
            multiPolygonGeometry(model.multiPolygonGeometry);
            polygonGeometry(model.polygonGeometry);
        }

        public final MultiPolygonGeometryInput.Builder getMultiPolygonGeometry() {
            return multiPolygonGeometry != null ? multiPolygonGeometry.toBuilder() : null;
        }

        public final void setMultiPolygonGeometry(MultiPolygonGeometryInput.BuilderImpl multiPolygonGeometry) {
            Object oldValue = this.multiPolygonGeometry;
            this.multiPolygonGeometry = multiPolygonGeometry != null ? multiPolygonGeometry.build() : null;
            handleUnionValueChange(Type.MULTI_POLYGON_GEOMETRY, oldValue, this.multiPolygonGeometry);
        }

        @Override
        public final Builder multiPolygonGeometry(MultiPolygonGeometryInput multiPolygonGeometry) {
            Object oldValue = this.multiPolygonGeometry;
            this.multiPolygonGeometry = multiPolygonGeometry;
            handleUnionValueChange(Type.MULTI_POLYGON_GEOMETRY, oldValue, this.multiPolygonGeometry);
            return this;
        }

        public final PolygonGeometryInput.Builder getPolygonGeometry() {
            return polygonGeometry != null ? polygonGeometry.toBuilder() : null;
        }

        public final void setPolygonGeometry(PolygonGeometryInput.BuilderImpl polygonGeometry) {
            Object oldValue = this.polygonGeometry;
            this.polygonGeometry = polygonGeometry != null ? polygonGeometry.build() : null;
            handleUnionValueChange(Type.POLYGON_GEOMETRY, oldValue, this.polygonGeometry);
        }

        @Override
        public final Builder polygonGeometry(PolygonGeometryInput polygonGeometry) {
            Object oldValue = this.polygonGeometry;
            this.polygonGeometry = polygonGeometry;
            handleUnionValueChange(Type.POLYGON_GEOMETRY, oldValue, this.polygonGeometry);
            return this;
        }

        @Override
        public AreaOfInterestGeometry build() {
            return new AreaOfInterestGeometry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AreaOfInterestGeometry#type()
     */
    public enum Type {
        MULTI_POLYGON_GEOMETRY,

        POLYGON_GEOMETRY,

        UNKNOWN_TO_SDK_VERSION
    }
}
