/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing a Geometry in terms of Type and Coordinates as per GeoJson spec.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Geometry implements SdkPojo, Serializable, ToCopyableBuilder<Geometry.Builder, Geometry> {
    private static final SdkField<List<List<List<Double>>>> COORDINATES_FIELD = SdkField
            .<List<List<List<Double>>>> builder(MarshallingType.LIST)
            .memberName("Coordinates")
            .getter(getter(Geometry::coordinates))
            .setter(setter(Builder::coordinates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Coordinates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<List<Double>>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<List<Double>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<Double> builder(
                                                                                                            MarshallingType.DOUBLE)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Geometry::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COORDINATES_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<List<List<Double>>> coordinates;

    private final String type;

    private Geometry(BuilderImpl builder) {
        this.coordinates = builder.coordinates;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Coordinates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCoordinates() {
        return coordinates != null && !(coordinates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The coordinates of the GeoJson Geometry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCoordinates} method.
     * </p>
     * 
     * @return The coordinates of the GeoJson Geometry.
     */
    public final List<List<List<Double>>> coordinates() {
        return coordinates;
    }

    /**
     * <p>
     * GeoJson Geometry types like Polygon and MultiPolygon.
     * </p>
     * 
     * @return GeoJson Geometry types like Polygon and MultiPolygon.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCoordinates() ? coordinates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Geometry)) {
            return false;
        }
        Geometry other = (Geometry) obj;
        return hasCoordinates() == other.hasCoordinates() && Objects.equals(coordinates(), other.coordinates())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Geometry").add("Coordinates", coordinates() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Coordinates":
            return Optional.ofNullable(clazz.cast(coordinates()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Coordinates", COORDINATES_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Geometry, T> g) {
        return obj -> g.apply((Geometry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Geometry> {
        /**
         * <p>
         * The coordinates of the GeoJson Geometry.
         * </p>
         * 
         * @param coordinates
         *        The coordinates of the GeoJson Geometry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coordinates(Collection<? extends Collection<? extends Collection<Double>>> coordinates);

        /**
         * <p>
         * The coordinates of the GeoJson Geometry.
         * </p>
         * 
         * @param coordinates
         *        The coordinates of the GeoJson Geometry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coordinates(Collection<? extends Collection<Double>>... coordinates);

        /**
         * <p>
         * GeoJson Geometry types like Polygon and MultiPolygon.
         * </p>
         * 
         * @param type
         *        GeoJson Geometry types like Polygon and MultiPolygon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private List<List<List<Double>>> coordinates = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Geometry model) {
            coordinates(model.coordinates);
            type(model.type);
        }

        public final Collection<? extends Collection<? extends Collection<Double>>> getCoordinates() {
            if (coordinates instanceof SdkAutoConstructList) {
                return null;
            }
            return coordinates;
        }

        public final void setCoordinates(Collection<? extends Collection<? extends Collection<Double>>> coordinates) {
            this.coordinates = LinearRingsCopier.copy(coordinates);
        }

        @Override
        public final Builder coordinates(Collection<? extends Collection<? extends Collection<Double>>> coordinates) {
            this.coordinates = LinearRingsCopier.copy(coordinates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coordinates(Collection<? extends Collection<Double>>... coordinates) {
            coordinates(Arrays.asList(coordinates));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Geometry build() {
            return new Geometry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
