/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The InputConfig for an EarthObservationJob response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputConfigOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<InputConfigOutput.Builder, InputConfigOutput> {
    private static final SdkField<String> PREVIOUS_EARTH_OBSERVATION_JOB_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreviousEarthObservationJobArn")
            .getter(getter(InputConfigOutput::previousEarthObservationJobArn))
            .setter(setter(Builder::previousEarthObservationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousEarthObservationJobArn")
                    .build()).build();

    private static final SdkField<RasterDataCollectionQueryOutput> RASTER_DATA_COLLECTION_QUERY_FIELD = SdkField
            .<RasterDataCollectionQueryOutput> builder(MarshallingType.SDK_POJO).memberName("RasterDataCollectionQuery")
            .getter(getter(InputConfigOutput::rasterDataCollectionQuery)).setter(setter(Builder::rasterDataCollectionQuery))
            .constructor(RasterDataCollectionQueryOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RasterDataCollectionQuery").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREVIOUS_EARTH_OBSERVATION_JOB_ARN_FIELD, RASTER_DATA_COLLECTION_QUERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String previousEarthObservationJobArn;

    private final RasterDataCollectionQueryOutput rasterDataCollectionQuery;

    private InputConfigOutput(BuilderImpl builder) {
        this.previousEarthObservationJobArn = builder.previousEarthObservationJobArn;
        this.rasterDataCollectionQuery = builder.rasterDataCollectionQuery;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the previous Earth Observation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the previous Earth Observation job.
     */
    public final String previousEarthObservationJobArn() {
        return previousEarthObservationJobArn;
    }

    /**
     * <p>
     * The structure representing the RasterDataCollection Query consisting of the Area of Interest,
     * RasterDataCollectionArn, RasterDataCollectionName, TimeRange, and Property Filters.
     * </p>
     * 
     * @return The structure representing the RasterDataCollection Query consisting of the Area of Interest,
     *         RasterDataCollectionArn, RasterDataCollectionName, TimeRange, and Property Filters.
     */
    public final RasterDataCollectionQueryOutput rasterDataCollectionQuery() {
        return rasterDataCollectionQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(previousEarthObservationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(rasterDataCollectionQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConfigOutput)) {
            return false;
        }
        InputConfigOutput other = (InputConfigOutput) obj;
        return Objects.equals(previousEarthObservationJobArn(), other.previousEarthObservationJobArn())
                && Objects.equals(rasterDataCollectionQuery(), other.rasterDataCollectionQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputConfigOutput").add("PreviousEarthObservationJobArn", previousEarthObservationJobArn())
                .add("RasterDataCollectionQuery", rasterDataCollectionQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreviousEarthObservationJobArn":
            return Optional.ofNullable(clazz.cast(previousEarthObservationJobArn()));
        case "RasterDataCollectionQuery":
            return Optional.ofNullable(clazz.cast(rasterDataCollectionQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PreviousEarthObservationJobArn", PREVIOUS_EARTH_OBSERVATION_JOB_ARN_FIELD);
        map.put("RasterDataCollectionQuery", RASTER_DATA_COLLECTION_QUERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputConfigOutput, T> g) {
        return obj -> g.apply((InputConfigOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputConfigOutput> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the previous Earth Observation job.
         * </p>
         * 
         * @param previousEarthObservationJobArn
         *        The Amazon Resource Name (ARN) of the previous Earth Observation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousEarthObservationJobArn(String previousEarthObservationJobArn);

        /**
         * <p>
         * The structure representing the RasterDataCollection Query consisting of the Area of Interest,
         * RasterDataCollectionArn, RasterDataCollectionName, TimeRange, and Property Filters.
         * </p>
         * 
         * @param rasterDataCollectionQuery
         *        The structure representing the RasterDataCollection Query consisting of the Area of Interest,
         *        RasterDataCollectionArn, RasterDataCollectionName, TimeRange, and Property Filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rasterDataCollectionQuery(RasterDataCollectionQueryOutput rasterDataCollectionQuery);

        /**
         * <p>
         * The structure representing the RasterDataCollection Query consisting of the Area of Interest,
         * RasterDataCollectionArn, RasterDataCollectionName, TimeRange, and Property Filters.
         * </p>
         * This is a convenience method that creates an instance of the {@link RasterDataCollectionQueryOutput.Builder}
         * avoiding the need to create one manually via {@link RasterDataCollectionQueryOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RasterDataCollectionQueryOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #rasterDataCollectionQuery(RasterDataCollectionQueryOutput)}.
         * 
         * @param rasterDataCollectionQuery
         *        a consumer that will call methods on {@link RasterDataCollectionQueryOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rasterDataCollectionQuery(RasterDataCollectionQueryOutput)
         */
        default Builder rasterDataCollectionQuery(Consumer<RasterDataCollectionQueryOutput.Builder> rasterDataCollectionQuery) {
            return rasterDataCollectionQuery(RasterDataCollectionQueryOutput.builder().applyMutation(rasterDataCollectionQuery)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String previousEarthObservationJobArn;

        private RasterDataCollectionQueryOutput rasterDataCollectionQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConfigOutput model) {
            previousEarthObservationJobArn(model.previousEarthObservationJobArn);
            rasterDataCollectionQuery(model.rasterDataCollectionQuery);
        }

        public final String getPreviousEarthObservationJobArn() {
            return previousEarthObservationJobArn;
        }

        public final void setPreviousEarthObservationJobArn(String previousEarthObservationJobArn) {
            this.previousEarthObservationJobArn = previousEarthObservationJobArn;
        }

        @Override
        public final Builder previousEarthObservationJobArn(String previousEarthObservationJobArn) {
            this.previousEarthObservationJobArn = previousEarthObservationJobArn;
            return this;
        }

        public final RasterDataCollectionQueryOutput.Builder getRasterDataCollectionQuery() {
            return rasterDataCollectionQuery != null ? rasterDataCollectionQuery.toBuilder() : null;
        }

        public final void setRasterDataCollectionQuery(RasterDataCollectionQueryOutput.BuilderImpl rasterDataCollectionQuery) {
            this.rasterDataCollectionQuery = rasterDataCollectionQuery != null ? rasterDataCollectionQuery.build() : null;
        }

        @Override
        public final Builder rasterDataCollectionQuery(RasterDataCollectionQueryOutput rasterDataCollectionQuery) {
            this.rasterDataCollectionQuery = rasterDataCollectionQuery;
            return this;
        }

        @Override
        public InputConfigOutput build() {
            return new InputConfigOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
