/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single EarthObservationJob output band.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputBand implements SdkPojo, Serializable, ToCopyableBuilder<OutputBand.Builder, OutputBand> {
    private static final SdkField<String> BAND_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BandName").getter(getter(OutputBand::bandName)).setter(setter(Builder::bandName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandName").build()).build();

    private static final SdkField<String> OUTPUT_DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputDataType").getter(getter(OutputBand::outputDataTypeAsString))
            .setter(setter(Builder::outputDataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BAND_NAME_FIELD,
            OUTPUT_DATA_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bandName;

    private final String outputDataType;

    private OutputBand(BuilderImpl builder) {
        this.bandName = builder.bandName;
        this.outputDataType = builder.outputDataType;
    }

    /**
     * <p>
     * The name of the band.
     * </p>
     * 
     * @return The name of the band.
     */
    public final String bandName() {
        return bandName;
    }

    /**
     * <p>
     * The datatype of the output band.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputDataType}
     * will return {@link OutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputDataTypeAsString}.
     * </p>
     * 
     * @return The datatype of the output band.
     * @see OutputType
     */
    public final OutputType outputDataType() {
        return OutputType.fromValue(outputDataType);
    }

    /**
     * <p>
     * The datatype of the output band.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputDataType}
     * will return {@link OutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputDataTypeAsString}.
     * </p>
     * 
     * @return The datatype of the output band.
     * @see OutputType
     */
    public final String outputDataTypeAsString() {
        return outputDataType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bandName());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputBand)) {
            return false;
        }
        OutputBand other = (OutputBand) obj;
        return Objects.equals(bandName(), other.bandName())
                && Objects.equals(outputDataTypeAsString(), other.outputDataTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputBand").add("BandName", bandName()).add("OutputDataType", outputDataTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BandName":
            return Optional.ofNullable(clazz.cast(bandName()));
        case "OutputDataType":
            return Optional.ofNullable(clazz.cast(outputDataTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BandName", BAND_NAME_FIELD);
        map.put("OutputDataType", OUTPUT_DATA_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputBand, T> g) {
        return obj -> g.apply((OutputBand) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputBand> {
        /**
         * <p>
         * The name of the band.
         * </p>
         * 
         * @param bandName
         *        The name of the band.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandName(String bandName);

        /**
         * <p>
         * The datatype of the output band.
         * </p>
         * 
         * @param outputDataType
         *        The datatype of the output band.
         * @see OutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputType
         */
        Builder outputDataType(String outputDataType);

        /**
         * <p>
         * The datatype of the output band.
         * </p>
         * 
         * @param outputDataType
         *        The datatype of the output band.
         * @see OutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputType
         */
        Builder outputDataType(OutputType outputDataType);
    }

    static final class BuilderImpl implements Builder {
        private String bandName;

        private String outputDataType;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputBand model) {
            bandName(model.bandName);
            outputDataType(model.outputDataType);
        }

        public final String getBandName() {
            return bandName;
        }

        public final void setBandName(String bandName) {
            this.bandName = bandName;
        }

        @Override
        public final Builder bandName(String bandName) {
            this.bandName = bandName;
            return this;
        }

        public final String getOutputDataType() {
            return outputDataType;
        }

        public final void setOutputDataType(String outputDataType) {
            this.outputDataType = outputDataType;
        }

        @Override
        public final Builder outputDataType(String outputDataType) {
            this.outputDataType = outputDataType;
            return this;
        }

        @Override
        public final Builder outputDataType(OutputType outputDataType) {
            this.outputDataType(outputDataType == null ? null : outputDataType.toString());
            return this;
        }

        @Override
        public OutputBand build() {
            return new OutputBand(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
