/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the configuration for Temporal Statistics operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemporalStatisticsConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<TemporalStatisticsConfigInput.Builder, TemporalStatisticsConfigInput> {
    private static final SdkField<String> GROUP_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupBy").getter(getter(TemporalStatisticsConfigInput::groupByAsString))
            .setter(setter(Builder::groupBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build()).build();

    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Statistics")
            .getter(getter(TemporalStatisticsConfigInput::statisticsAsStrings))
            .setter(setter(Builder::statisticsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGET_BANDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetBands")
            .getter(getter(TemporalStatisticsConfigInput::targetBands))
            .setter(setter(Builder::targetBands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_FIELD,
            STATISTICS_FIELD, TARGET_BANDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupBy;

    private final List<String> statistics;

    private final List<String> targetBands;

    private TemporalStatisticsConfigInput(BuilderImpl builder) {
        this.groupBy = builder.groupBy;
        this.statistics = builder.statistics;
        this.targetBands = builder.targetBands;
    }

    /**
     * <p>
     * The input for the temporal statistics grouping by time frequency option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupBy} will
     * return {@link GroupBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupByAsString}.
     * </p>
     * 
     * @return The input for the temporal statistics grouping by time frequency option.
     * @see GroupBy
     */
    public final GroupBy groupBy() {
        return GroupBy.fromValue(groupBy);
    }

    /**
     * <p>
     * The input for the temporal statistics grouping by time frequency option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupBy} will
     * return {@link GroupBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupByAsString}.
     * </p>
     * 
     * @return The input for the temporal statistics grouping by time frequency option.
     * @see GroupBy
     */
    public final String groupByAsString() {
        return groupBy;
    }

    /**
     * <p>
     * The list of the statistics method options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatistics} method.
     * </p>
     * 
     * @return The list of the statistics method options.
     */
    public final List<TemporalStatistics> statistics() {
        return TemporalStatisticsListInputCopier.copyStringToEnum(statistics);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statistics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatistics() {
        return statistics != null && !(statistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the statistics method options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatistics} method.
     * </p>
     * 
     * @return The list of the statistics method options.
     */
    public final List<String> statisticsAsStrings() {
        return statistics;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetBands property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetBands() {
        return targetBands != null && !(targetBands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of target band names for the temporal statistic to calculate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetBands} method.
     * </p>
     * 
     * @return The list of target band names for the temporal statistic to calculate.
     */
    public final List<String> targetBands() {
        return targetBands;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatistics() ? statisticsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetBands() ? targetBands() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemporalStatisticsConfigInput)) {
            return false;
        }
        TemporalStatisticsConfigInput other = (TemporalStatisticsConfigInput) obj;
        return Objects.equals(groupByAsString(), other.groupByAsString()) && hasStatistics() == other.hasStatistics()
                && Objects.equals(statisticsAsStrings(), other.statisticsAsStrings())
                && hasTargetBands() == other.hasTargetBands() && Objects.equals(targetBands(), other.targetBands());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemporalStatisticsConfigInput").add("GroupBy", groupByAsString())
                .add("Statistics", hasStatistics() ? statisticsAsStrings() : null)
                .add("TargetBands", hasTargetBands() ? targetBands() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupBy":
            return Optional.ofNullable(clazz.cast(groupByAsString()));
        case "Statistics":
            return Optional.ofNullable(clazz.cast(statisticsAsStrings()));
        case "TargetBands":
            return Optional.ofNullable(clazz.cast(targetBands()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupBy", GROUP_BY_FIELD);
        map.put("Statistics", STATISTICS_FIELD);
        map.put("TargetBands", TARGET_BANDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemporalStatisticsConfigInput, T> g) {
        return obj -> g.apply((TemporalStatisticsConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemporalStatisticsConfigInput> {
        /**
         * <p>
         * The input for the temporal statistics grouping by time frequency option.
         * </p>
         * 
         * @param groupBy
         *        The input for the temporal statistics grouping by time frequency option.
         * @see GroupBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupBy
         */
        Builder groupBy(String groupBy);

        /**
         * <p>
         * The input for the temporal statistics grouping by time frequency option.
         * </p>
         * 
         * @param groupBy
         *        The input for the temporal statistics grouping by time frequency option.
         * @see GroupBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupBy
         */
        Builder groupBy(GroupBy groupBy);

        /**
         * <p>
         * The list of the statistics method options.
         * </p>
         * 
         * @param statistics
         *        The list of the statistics method options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsWithStrings(Collection<String> statistics);

        /**
         * <p>
         * The list of the statistics method options.
         * </p>
         * 
         * @param statistics
         *        The list of the statistics method options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsWithStrings(String... statistics);

        /**
         * <p>
         * The list of the statistics method options.
         * </p>
         * 
         * @param statistics
         *        The list of the statistics method options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(Collection<TemporalStatistics> statistics);

        /**
         * <p>
         * The list of the statistics method options.
         * </p>
         * 
         * @param statistics
         *        The list of the statistics method options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(TemporalStatistics... statistics);

        /**
         * <p>
         * The list of target band names for the temporal statistic to calculate.
         * </p>
         * 
         * @param targetBands
         *        The list of target band names for the temporal statistic to calculate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBands(Collection<String> targetBands);

        /**
         * <p>
         * The list of target band names for the temporal statistic to calculate.
         * </p>
         * 
         * @param targetBands
         *        The list of target band names for the temporal statistic to calculate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBands(String... targetBands);
    }

    static final class BuilderImpl implements Builder {
        private String groupBy;

        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();

        private List<String> targetBands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TemporalStatisticsConfigInput model) {
            groupBy(model.groupBy);
            statisticsWithStrings(model.statistics);
            targetBands(model.targetBands);
        }

        public final String getGroupBy() {
            return groupBy;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public final Builder groupBy(GroupBy groupBy) {
            this.groupBy(groupBy == null ? null : groupBy.toString());
            return this;
        }

        public final Collection<String> getStatistics() {
            if (statistics instanceof SdkAutoConstructList) {
                return null;
            }
            return statistics;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = TemporalStatisticsListInputCopier.copy(statistics);
        }

        @Override
        public final Builder statisticsWithStrings(Collection<String> statistics) {
            this.statistics = TemporalStatisticsListInputCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsWithStrings(String... statistics) {
            statisticsWithStrings(Arrays.asList(statistics));
            return this;
        }

        @Override
        public final Builder statistics(Collection<TemporalStatistics> statistics) {
            this.statistics = TemporalStatisticsListInputCopier.copyEnumToString(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(TemporalStatistics... statistics) {
            statistics(Arrays.asList(statistics));
            return this;
        }

        public final Collection<String> getTargetBands() {
            if (targetBands instanceof SdkAutoConstructList) {
                return null;
            }
            return targetBands;
        }

        public final void setTargetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
        }

        @Override
        public final Builder targetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBands(String... targetBands) {
            targetBands(Arrays.asList(targetBands));
            return this;
        }

        @Override
        public TemporalStatisticsConfigInput build() {
            return new TemporalStatisticsConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
