/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * It contains configs such as ReverseGeocodingConfig and MapMatchingConfig.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VectorEnrichmentJobConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<VectorEnrichmentJobConfig.Builder, VectorEnrichmentJobConfig> {
    private static final SdkField<MapMatchingConfig> MAP_MATCHING_CONFIG_FIELD = SdkField
            .<MapMatchingConfig> builder(MarshallingType.SDK_POJO).memberName("MapMatchingConfig")
            .getter(getter(VectorEnrichmentJobConfig::mapMatchingConfig)).setter(setter(Builder::mapMatchingConfig))
            .constructor(MapMatchingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapMatchingConfig").build()).build();

    private static final SdkField<ReverseGeocodingConfig> REVERSE_GEOCODING_CONFIG_FIELD = SdkField
            .<ReverseGeocodingConfig> builder(MarshallingType.SDK_POJO).memberName("ReverseGeocodingConfig")
            .getter(getter(VectorEnrichmentJobConfig::reverseGeocodingConfig)).setter(setter(Builder::reverseGeocodingConfig))
            .constructor(ReverseGeocodingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReverseGeocodingConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_MATCHING_CONFIG_FIELD,
            REVERSE_GEOCODING_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MapMatchingConfig mapMatchingConfig;

    private final ReverseGeocodingConfig reverseGeocodingConfig;

    private final Type type;

    private VectorEnrichmentJobConfig(BuilderImpl builder) {
        this.mapMatchingConfig = builder.mapMatchingConfig;
        this.reverseGeocodingConfig = builder.reverseGeocodingConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * The input structure for Map Matching operation type.
     * </p>
     * 
     * @return The input structure for Map Matching operation type.
     */
    public final MapMatchingConfig mapMatchingConfig() {
        return mapMatchingConfig;
    }

    /**
     * <p>
     * The input structure for Reverse Geocoding operation type.
     * </p>
     * 
     * @return The input structure for Reverse Geocoding operation type.
     */
    public final ReverseGeocodingConfig reverseGeocodingConfig() {
        return reverseGeocodingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mapMatchingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(reverseGeocodingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorEnrichmentJobConfig)) {
            return false;
        }
        VectorEnrichmentJobConfig other = (VectorEnrichmentJobConfig) obj;
        return Objects.equals(mapMatchingConfig(), other.mapMatchingConfig())
                && Objects.equals(reverseGeocodingConfig(), other.reverseGeocodingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VectorEnrichmentJobConfig").add("MapMatchingConfig", mapMatchingConfig())
                .add("ReverseGeocodingConfig", reverseGeocodingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MapMatchingConfig":
            return Optional.ofNullable(clazz.cast(mapMatchingConfig()));
        case "ReverseGeocodingConfig":
            return Optional.ofNullable(clazz.cast(reverseGeocodingConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #mapMatchingConfig()} initialized to the given value.
     *
     * <p>
     * The input structure for Map Matching operation type.
     * </p>
     * 
     * @param mapMatchingConfig
     *        The input structure for Map Matching operation type.
     */
    public static VectorEnrichmentJobConfig fromMapMatchingConfig(MapMatchingConfig mapMatchingConfig) {
        return builder().mapMatchingConfig(mapMatchingConfig).build();
    }

    /**
     * Create an instance of this class with {@link #mapMatchingConfig()} initialized to the given value.
     *
     * <p>
     * The input structure for Map Matching operation type.
     * </p>
     * 
     * @param mapMatchingConfig
     *        The input structure for Map Matching operation type.
     */
    public static VectorEnrichmentJobConfig fromMapMatchingConfig(Consumer<MapMatchingConfig.Builder> mapMatchingConfig) {
        MapMatchingConfig.Builder builder = MapMatchingConfig.builder();
        mapMatchingConfig.accept(builder);
        return fromMapMatchingConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #reverseGeocodingConfig()} initialized to the given value.
     *
     * <p>
     * The input structure for Reverse Geocoding operation type.
     * </p>
     * 
     * @param reverseGeocodingConfig
     *        The input structure for Reverse Geocoding operation type.
     */
    public static VectorEnrichmentJobConfig fromReverseGeocodingConfig(ReverseGeocodingConfig reverseGeocodingConfig) {
        return builder().reverseGeocodingConfig(reverseGeocodingConfig).build();
    }

    /**
     * Create an instance of this class with {@link #reverseGeocodingConfig()} initialized to the given value.
     *
     * <p>
     * The input structure for Reverse Geocoding operation type.
     * </p>
     * 
     * @param reverseGeocodingConfig
     *        The input structure for Reverse Geocoding operation type.
     */
    public static VectorEnrichmentJobConfig fromReverseGeocodingConfig(
            Consumer<ReverseGeocodingConfig.Builder> reverseGeocodingConfig) {
        ReverseGeocodingConfig.Builder builder = ReverseGeocodingConfig.builder();
        reverseGeocodingConfig.accept(builder);
        return fromReverseGeocodingConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MapMatchingConfig", MAP_MATCHING_CONFIG_FIELD);
        map.put("ReverseGeocodingConfig", REVERSE_GEOCODING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VectorEnrichmentJobConfig, T> g) {
        return obj -> g.apply((VectorEnrichmentJobConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VectorEnrichmentJobConfig> {
        /**
         * <p>
         * The input structure for Map Matching operation type.
         * </p>
         * 
         * @param mapMatchingConfig
         *        The input structure for Map Matching operation type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapMatchingConfig(MapMatchingConfig mapMatchingConfig);

        /**
         * <p>
         * The input structure for Map Matching operation type.
         * </p>
         * This is a convenience method that creates an instance of the {@link MapMatchingConfig.Builder} avoiding the
         * need to create one manually via {@link MapMatchingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MapMatchingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #mapMatchingConfig(MapMatchingConfig)}.
         * 
         * @param mapMatchingConfig
         *        a consumer that will call methods on {@link MapMatchingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapMatchingConfig(MapMatchingConfig)
         */
        default Builder mapMatchingConfig(Consumer<MapMatchingConfig.Builder> mapMatchingConfig) {
            return mapMatchingConfig(MapMatchingConfig.builder().applyMutation(mapMatchingConfig).build());
        }

        /**
         * <p>
         * The input structure for Reverse Geocoding operation type.
         * </p>
         * 
         * @param reverseGeocodingConfig
         *        The input structure for Reverse Geocoding operation type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseGeocodingConfig(ReverseGeocodingConfig reverseGeocodingConfig);

        /**
         * <p>
         * The input structure for Reverse Geocoding operation type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReverseGeocodingConfig.Builder} avoiding
         * the need to create one manually via {@link ReverseGeocodingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReverseGeocodingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #reverseGeocodingConfig(ReverseGeocodingConfig)}.
         * 
         * @param reverseGeocodingConfig
         *        a consumer that will call methods on {@link ReverseGeocodingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reverseGeocodingConfig(ReverseGeocodingConfig)
         */
        default Builder reverseGeocodingConfig(Consumer<ReverseGeocodingConfig.Builder> reverseGeocodingConfig) {
            return reverseGeocodingConfig(ReverseGeocodingConfig.builder().applyMutation(reverseGeocodingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MapMatchingConfig mapMatchingConfig;

        private ReverseGeocodingConfig reverseGeocodingConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(VectorEnrichmentJobConfig model) {
            mapMatchingConfig(model.mapMatchingConfig);
            reverseGeocodingConfig(model.reverseGeocodingConfig);
        }

        public final MapMatchingConfig.Builder getMapMatchingConfig() {
            return mapMatchingConfig != null ? mapMatchingConfig.toBuilder() : null;
        }

        public final void setMapMatchingConfig(MapMatchingConfig.BuilderImpl mapMatchingConfig) {
            Object oldValue = this.mapMatchingConfig;
            this.mapMatchingConfig = mapMatchingConfig != null ? mapMatchingConfig.build() : null;
            handleUnionValueChange(Type.MAP_MATCHING_CONFIG, oldValue, this.mapMatchingConfig);
        }

        @Override
        public final Builder mapMatchingConfig(MapMatchingConfig mapMatchingConfig) {
            Object oldValue = this.mapMatchingConfig;
            this.mapMatchingConfig = mapMatchingConfig;
            handleUnionValueChange(Type.MAP_MATCHING_CONFIG, oldValue, this.mapMatchingConfig);
            return this;
        }

        public final ReverseGeocodingConfig.Builder getReverseGeocodingConfig() {
            return reverseGeocodingConfig != null ? reverseGeocodingConfig.toBuilder() : null;
        }

        public final void setReverseGeocodingConfig(ReverseGeocodingConfig.BuilderImpl reverseGeocodingConfig) {
            Object oldValue = this.reverseGeocodingConfig;
            this.reverseGeocodingConfig = reverseGeocodingConfig != null ? reverseGeocodingConfig.build() : null;
            handleUnionValueChange(Type.REVERSE_GEOCODING_CONFIG, oldValue, this.reverseGeocodingConfig);
        }

        @Override
        public final Builder reverseGeocodingConfig(ReverseGeocodingConfig reverseGeocodingConfig) {
            Object oldValue = this.reverseGeocodingConfig;
            this.reverseGeocodingConfig = reverseGeocodingConfig;
            handleUnionValueChange(Type.REVERSE_GEOCODING_CONFIG, oldValue, this.reverseGeocodingConfig);
            return this;
        }

        @Override
        public VectorEnrichmentJobConfig build() {
            return new VectorEnrichmentJobConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see VectorEnrichmentJobConfig#type()
     */
    public enum Type {
        MAP_MATCHING_CONFIG,

        REVERSE_GEOCODING_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
