/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The geographic extent of the Earth Observation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AreaOfInterest implements SdkPojo, Serializable, ToCopyableBuilder<AreaOfInterest.Builder, AreaOfInterest> {
    private static final SdkField<AreaOfInterestGeometry> AREA_OF_INTEREST_GEOMETRY_FIELD = SdkField
            .<AreaOfInterestGeometry> builder(MarshallingType.SDK_POJO).memberName("AreaOfInterestGeometry")
            .getter(getter(AreaOfInterest::areaOfInterestGeometry)).setter(setter(Builder::areaOfInterestGeometry))
            .constructor(AreaOfInterestGeometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AreaOfInterestGeometry").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AREA_OF_INTEREST_GEOMETRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AreaOfInterestGeometry areaOfInterestGeometry;

    private final Type type;

    private AreaOfInterest(BuilderImpl builder) {
        this.areaOfInterestGeometry = builder.areaOfInterestGeometry;
        this.type = builder.type;
    }

    /**
     * <p>
     * A GeoJSON object representing the geographic extent in the coordinate space.
     * </p>
     * 
     * @return A GeoJSON object representing the geographic extent in the coordinate space.
     */
    public final AreaOfInterestGeometry areaOfInterestGeometry() {
        return areaOfInterestGeometry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(areaOfInterestGeometry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AreaOfInterest)) {
            return false;
        }
        AreaOfInterest other = (AreaOfInterest) obj;
        return Objects.equals(areaOfInterestGeometry(), other.areaOfInterestGeometry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AreaOfInterest").add("AreaOfInterestGeometry", areaOfInterestGeometry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AreaOfInterestGeometry":
            return Optional.ofNullable(clazz.cast(areaOfInterestGeometry()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #areaOfInterestGeometry()} initialized to the given value.
     *
     * <p>
     * A GeoJSON object representing the geographic extent in the coordinate space.
     * </p>
     * 
     * @param areaOfInterestGeometry
     *        A GeoJSON object representing the geographic extent in the coordinate space.
     */
    public static AreaOfInterest fromAreaOfInterestGeometry(AreaOfInterestGeometry areaOfInterestGeometry) {
        return builder().areaOfInterestGeometry(areaOfInterestGeometry).build();
    }

    /**
     * Create an instance of this class with {@link #areaOfInterestGeometry()} initialized to the given value.
     *
     * <p>
     * A GeoJSON object representing the geographic extent in the coordinate space.
     * </p>
     * 
     * @param areaOfInterestGeometry
     *        A GeoJSON object representing the geographic extent in the coordinate space.
     */
    public static AreaOfInterest fromAreaOfInterestGeometry(Consumer<AreaOfInterestGeometry.Builder> areaOfInterestGeometry) {
        AreaOfInterestGeometry.Builder builder = AreaOfInterestGeometry.builder();
        areaOfInterestGeometry.accept(builder);
        return fromAreaOfInterestGeometry(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AreaOfInterestGeometry", AREA_OF_INTEREST_GEOMETRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AreaOfInterest, T> g) {
        return obj -> g.apply((AreaOfInterest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AreaOfInterest> {
        /**
         * <p>
         * A GeoJSON object representing the geographic extent in the coordinate space.
         * </p>
         * 
         * @param areaOfInterestGeometry
         *        A GeoJSON object representing the geographic extent in the coordinate space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areaOfInterestGeometry(AreaOfInterestGeometry areaOfInterestGeometry);

        /**
         * <p>
         * A GeoJSON object representing the geographic extent in the coordinate space.
         * </p>
         * This is a convenience method that creates an instance of the {@link AreaOfInterestGeometry.Builder} avoiding
         * the need to create one manually via {@link AreaOfInterestGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AreaOfInterestGeometry.Builder#build()} is called immediately and
         * its result is passed to {@link #areaOfInterestGeometry(AreaOfInterestGeometry)}.
         * 
         * @param areaOfInterestGeometry
         *        a consumer that will call methods on {@link AreaOfInterestGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #areaOfInterestGeometry(AreaOfInterestGeometry)
         */
        default Builder areaOfInterestGeometry(Consumer<AreaOfInterestGeometry.Builder> areaOfInterestGeometry) {
            return areaOfInterestGeometry(AreaOfInterestGeometry.builder().applyMutation(areaOfInterestGeometry).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AreaOfInterestGeometry areaOfInterestGeometry;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AreaOfInterest model) {
            areaOfInterestGeometry(model.areaOfInterestGeometry);
        }

        public final AreaOfInterestGeometry.Builder getAreaOfInterestGeometry() {
            return areaOfInterestGeometry != null ? areaOfInterestGeometry.toBuilder() : null;
        }

        public final void setAreaOfInterestGeometry(AreaOfInterestGeometry.BuilderImpl areaOfInterestGeometry) {
            Object oldValue = this.areaOfInterestGeometry;
            this.areaOfInterestGeometry = areaOfInterestGeometry != null ? areaOfInterestGeometry.build() : null;
            handleUnionValueChange(Type.AREA_OF_INTEREST_GEOMETRY, oldValue, this.areaOfInterestGeometry);
        }

        @Override
        public final Builder areaOfInterestGeometry(AreaOfInterestGeometry areaOfInterestGeometry) {
            Object oldValue = this.areaOfInterestGeometry;
            this.areaOfInterestGeometry = areaOfInterestGeometry;
            handleUnionValueChange(Type.AREA_OF_INTEREST_GEOMETRY, oldValue, this.areaOfInterestGeometry);
            return this;
        }

        @Override
        public AreaOfInterest build() {
            return new AreaOfInterest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AreaOfInterest#type()
     */
    public enum Type {
        AREA_OF_INTEREST_GEOMETRY,

        UNKNOWN_TO_SDK_VERSION
    }
}
