/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input structure for Cloud Removal Operation type
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudRemovalConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudRemovalConfigInput.Builder, CloudRemovalConfigInput> {
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlgorithmName").getter(getter(CloudRemovalConfigInput::algorithmNameAsString))
            .setter(setter(Builder::algorithmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()).build();

    private static final SdkField<String> INTERPOLATION_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InterpolationValue").getter(getter(CloudRemovalConfigInput::interpolationValue))
            .setter(setter(Builder::interpolationValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterpolationValue").build())
            .build();

    private static final SdkField<List<String>> TARGET_BANDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetBands")
            .getter(getter(CloudRemovalConfigInput::targetBands))
            .setter(setter(Builder::targetBands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_NAME_FIELD,
            INTERPOLATION_VALUE_FIELD, TARGET_BANDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String algorithmName;

    private final String interpolationValue;

    private final List<String> targetBands;

    private CloudRemovalConfigInput(BuilderImpl builder) {
        this.algorithmName = builder.algorithmName;
        this.interpolationValue = builder.interpolationValue;
        this.targetBands = builder.targetBands;
    }

    /**
     * <p>
     * The name of the algorithm used for cloud removal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithmName}
     * will return {@link AlgorithmNameCloudRemoval#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #algorithmNameAsString}.
     * </p>
     * 
     * @return The name of the algorithm used for cloud removal.
     * @see AlgorithmNameCloudRemoval
     */
    public final AlgorithmNameCloudRemoval algorithmName() {
        return AlgorithmNameCloudRemoval.fromValue(algorithmName);
    }

    /**
     * <p>
     * The name of the algorithm used for cloud removal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithmName}
     * will return {@link AlgorithmNameCloudRemoval#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #algorithmNameAsString}.
     * </p>
     * 
     * @return The name of the algorithm used for cloud removal.
     * @see AlgorithmNameCloudRemoval
     */
    public final String algorithmNameAsString() {
        return algorithmName;
    }

    /**
     * <p>
     * The interpolation value you provide for cloud removal.
     * </p>
     * 
     * @return The interpolation value you provide for cloud removal.
     */
    public final String interpolationValue() {
        return interpolationValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetBands property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetBands() {
        return targetBands != null && !(targetBands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * TargetBands to be returned in the output of CloudRemoval operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetBands} method.
     * </p>
     * 
     * @return TargetBands to be returned in the output of CloudRemoval operation.
     */
    public final List<String> targetBands() {
        return targetBands;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(algorithmNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(interpolationValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetBands() ? targetBands() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudRemovalConfigInput)) {
            return false;
        }
        CloudRemovalConfigInput other = (CloudRemovalConfigInput) obj;
        return Objects.equals(algorithmNameAsString(), other.algorithmNameAsString())
                && Objects.equals(interpolationValue(), other.interpolationValue()) && hasTargetBands() == other.hasTargetBands()
                && Objects.equals(targetBands(), other.targetBands());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudRemovalConfigInput").add("AlgorithmName", algorithmNameAsString())
                .add("InterpolationValue", interpolationValue()).add("TargetBands", hasTargetBands() ? targetBands() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlgorithmName":
            return Optional.ofNullable(clazz.cast(algorithmNameAsString()));
        case "InterpolationValue":
            return Optional.ofNullable(clazz.cast(interpolationValue()));
        case "TargetBands":
            return Optional.ofNullable(clazz.cast(targetBands()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AlgorithmName", ALGORITHM_NAME_FIELD);
        map.put("InterpolationValue", INTERPOLATION_VALUE_FIELD);
        map.put("TargetBands", TARGET_BANDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudRemovalConfigInput, T> g) {
        return obj -> g.apply((CloudRemovalConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudRemovalConfigInput> {
        /**
         * <p>
         * The name of the algorithm used for cloud removal.
         * </p>
         * 
         * @param algorithmName
         *        The name of the algorithm used for cloud removal.
         * @see AlgorithmNameCloudRemoval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmNameCloudRemoval
         */
        Builder algorithmName(String algorithmName);

        /**
         * <p>
         * The name of the algorithm used for cloud removal.
         * </p>
         * 
         * @param algorithmName
         *        The name of the algorithm used for cloud removal.
         * @see AlgorithmNameCloudRemoval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmNameCloudRemoval
         */
        Builder algorithmName(AlgorithmNameCloudRemoval algorithmName);

        /**
         * <p>
         * The interpolation value you provide for cloud removal.
         * </p>
         * 
         * @param interpolationValue
         *        The interpolation value you provide for cloud removal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interpolationValue(String interpolationValue);

        /**
         * <p>
         * TargetBands to be returned in the output of CloudRemoval operation.
         * </p>
         * 
         * @param targetBands
         *        TargetBands to be returned in the output of CloudRemoval operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBands(Collection<String> targetBands);

        /**
         * <p>
         * TargetBands to be returned in the output of CloudRemoval operation.
         * </p>
         * 
         * @param targetBands
         *        TargetBands to be returned in the output of CloudRemoval operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBands(String... targetBands);
    }

    static final class BuilderImpl implements Builder {
        private String algorithmName;

        private String interpolationValue;

        private List<String> targetBands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudRemovalConfigInput model) {
            algorithmName(model.algorithmName);
            interpolationValue(model.interpolationValue);
            targetBands(model.targetBands);
        }

        public final String getAlgorithmName() {
            return algorithmName;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        @Override
        public final Builder algorithmName(AlgorithmNameCloudRemoval algorithmName) {
            this.algorithmName(algorithmName == null ? null : algorithmName.toString());
            return this;
        }

        public final String getInterpolationValue() {
            return interpolationValue;
        }

        public final void setInterpolationValue(String interpolationValue) {
            this.interpolationValue = interpolationValue;
        }

        @Override
        public final Builder interpolationValue(String interpolationValue) {
            this.interpolationValue = interpolationValue;
            return this;
        }

        public final Collection<String> getTargetBands() {
            if (targetBands instanceof SdkAutoConstructList) {
                return null;
            }
            return targetBands;
        }

        public final void setTargetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
        }

        @Override
        public final Builder targetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBands(String... targetBands) {
            targetBands(Arrays.asList(targetBands));
            return this;
        }

        @Override
        public CloudRemovalConfigInput build() {
            return new CloudRemovalConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
