/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the filters supported by a RasterDataCollection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<Float> MAXIMUM_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Maximum")
            .getter(getter(Filter::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()).build();

    private static final SdkField<Float> MINIMUM_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Minimum")
            .getter(getter(Filter::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Filter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Filter::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_FIELD, MINIMUM_FIELD,
            NAME_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float maximum;

    private final Float minimum;

    private final String name;

    private final String type;

    private Filter(BuilderImpl builder) {
        this.maximum = builder.maximum;
        this.minimum = builder.minimum;
        this.name = builder.name;
        this.type = builder.type;
    }

    /**
     * <p>
     * The maximum value of the filter.
     * </p>
     * 
     * @return The maximum value of the filter.
     */
    public final Float maximum() {
        return maximum;
    }

    /**
     * <p>
     * The minimum value of the filter.
     * </p>
     * 
     * @return The minimum value of the filter.
     */
    public final Float minimum() {
        return minimum;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * 
     * @return The name of the filter.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the filter being used.
     * </p>
     * 
     * @return The type of the filter being used.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(maximum(), other.maximum()) && Objects.equals(minimum(), other.minimum())
                && Objects.equals(name(), other.name()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("Maximum", maximum()).add("Minimum", minimum()).add("Name", name())
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        case "Minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Maximum", MAXIMUM_FIELD);
        map.put("Minimum", MINIMUM_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * The maximum value of the filter.
         * </p>
         * 
         * @param maximum
         *        The maximum value of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Float maximum);

        /**
         * <p>
         * The minimum value of the filter.
         * </p>
         * 
         * @param minimum
         *        The minimum value of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Float minimum);

        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param name
         *        The name of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the filter being used.
         * </p>
         * 
         * @param type
         *        The type of the filter being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private Float maximum;

        private Float minimum;

        private String name;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            maximum(model.maximum);
            minimum(model.minimum);
            name(model.name);
            type(model.type);
        }

        public final Float getMaximum() {
            return maximum;
        }

        public final void setMaximum(Float maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Float maximum) {
            this.maximum = maximum;
            return this;
        }

        public final Float getMinimum() {
            return minimum;
        }

        public final void setMinimum(Float minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Float minimum) {
            this.minimum = minimum;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
