/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRasterDataCollectionsResponse extends SageMakerGeospatialResponse implements
        ToCopyableBuilder<ListRasterDataCollectionsResponse.Builder, ListRasterDataCollectionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRasterDataCollectionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<RasterDataCollectionMetadata>> RASTER_DATA_COLLECTION_SUMMARIES_FIELD = SdkField
            .<List<RasterDataCollectionMetadata>> builder(MarshallingType.LIST)
            .memberName("RasterDataCollectionSummaries")
            .getter(getter(ListRasterDataCollectionsResponse::rasterDataCollectionSummaries))
            .setter(setter(Builder::rasterDataCollectionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RasterDataCollectionSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RasterDataCollectionMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(RasterDataCollectionMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RASTER_DATA_COLLECTION_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<RasterDataCollectionMetadata> rasterDataCollectionSummaries;

    private ListRasterDataCollectionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.rasterDataCollectionSummaries = builder.rasterDataCollectionSummaries;
    }

    /**
     * <p>
     * If the previous response was truncated, you receive this token. Use it in your next request to receive the next
     * set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you receive this token. Use it in your next request to receive
     *         the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RasterDataCollectionSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRasterDataCollectionSummaries() {
        return rasterDataCollectionSummaries != null && !(rasterDataCollectionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains summary information about the raster data collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRasterDataCollectionSummaries} method.
     * </p>
     * 
     * @return Contains summary information about the raster data collection.
     */
    public final List<RasterDataCollectionMetadata> rasterDataCollectionSummaries() {
        return rasterDataCollectionSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRasterDataCollectionSummaries() ? rasterDataCollectionSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRasterDataCollectionsResponse)) {
            return false;
        }
        ListRasterDataCollectionsResponse other = (ListRasterDataCollectionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasRasterDataCollectionSummaries() == other.hasRasterDataCollectionSummaries()
                && Objects.equals(rasterDataCollectionSummaries(), other.rasterDataCollectionSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListRasterDataCollectionsResponse")
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RasterDataCollectionSummaries", hasRasterDataCollectionSummaries() ? rasterDataCollectionSummaries() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RasterDataCollectionSummaries":
            return Optional.ofNullable(clazz.cast(rasterDataCollectionSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RasterDataCollectionSummaries", RASTER_DATA_COLLECTION_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRasterDataCollectionsResponse, T> g) {
        return obj -> g.apply((ListRasterDataCollectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerGeospatialResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRasterDataCollectionsResponse> {
        /**
         * <p>
         * If the previous response was truncated, you receive this token. Use it in your next request to receive the
         * next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you receive this token. Use it in your next request to receive
         *        the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Contains summary information about the raster data collection.
         * </p>
         * 
         * @param rasterDataCollectionSummaries
         *        Contains summary information about the raster data collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rasterDataCollectionSummaries(Collection<RasterDataCollectionMetadata> rasterDataCollectionSummaries);

        /**
         * <p>
         * Contains summary information about the raster data collection.
         * </p>
         * 
         * @param rasterDataCollectionSummaries
         *        Contains summary information about the raster data collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rasterDataCollectionSummaries(RasterDataCollectionMetadata... rasterDataCollectionSummaries);

        /**
         * <p>
         * Contains summary information about the raster data collection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionMetadata.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionMetadata.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #rasterDataCollectionSummaries(List<RasterDataCollectionMetadata>)}.
         * 
         * @param rasterDataCollectionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rasterDataCollectionSummaries(java.util.Collection<RasterDataCollectionMetadata>)
         */
        Builder rasterDataCollectionSummaries(Consumer<RasterDataCollectionMetadata.Builder>... rasterDataCollectionSummaries);
    }

    static final class BuilderImpl extends SageMakerGeospatialResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RasterDataCollectionMetadata> rasterDataCollectionSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRasterDataCollectionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            rasterDataCollectionSummaries(model.rasterDataCollectionSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RasterDataCollectionMetadata.Builder> getRasterDataCollectionSummaries() {
            List<RasterDataCollectionMetadata.Builder> result = DataCollectionsListCopier
                    .copyToBuilder(this.rasterDataCollectionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRasterDataCollectionSummaries(
                Collection<RasterDataCollectionMetadata.BuilderImpl> rasterDataCollectionSummaries) {
            this.rasterDataCollectionSummaries = DataCollectionsListCopier.copyFromBuilder(rasterDataCollectionSummaries);
        }

        @Override
        public final Builder rasterDataCollectionSummaries(Collection<RasterDataCollectionMetadata> rasterDataCollectionSummaries) {
            this.rasterDataCollectionSummaries = DataCollectionsListCopier.copy(rasterDataCollectionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rasterDataCollectionSummaries(RasterDataCollectionMetadata... rasterDataCollectionSummaries) {
            rasterDataCollectionSummaries(Arrays.asList(rasterDataCollectionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rasterDataCollectionSummaries(
                Consumer<RasterDataCollectionMetadata.Builder>... rasterDataCollectionSummaries) {
            rasterDataCollectionSummaries(Stream.of(rasterDataCollectionSummaries)
                    .map(c -> RasterDataCollectionMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRasterDataCollectionsResponse build() {
            return new ListRasterDataCollectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
