/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input structure for Map Matching operation type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MapMatchingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MapMatchingConfig.Builder, MapMatchingConfig> {
    private static final SdkField<String> ID_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdAttributeName").getter(getter(MapMatchingConfig::idAttributeName))
            .setter(setter(Builder::idAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdAttributeName").build()).build();

    private static final SdkField<String> TIMESTAMP_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampAttributeName").getter(getter(MapMatchingConfig::timestampAttributeName))
            .setter(setter(Builder::timestampAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampAttributeName").build())
            .build();

    private static final SdkField<String> X_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XAttributeName").getter(getter(MapMatchingConfig::xAttributeName))
            .setter(setter(Builder::xAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAttributeName").build()).build();

    private static final SdkField<String> Y_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("YAttributeName").getter(getter(MapMatchingConfig::yAttributeName))
            .setter(setter(Builder::yAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YAttributeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_ATTRIBUTE_NAME_FIELD,
            TIMESTAMP_ATTRIBUTE_NAME_FIELD, X_ATTRIBUTE_NAME_FIELD, Y_ATTRIBUTE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String idAttributeName;

    private final String timestampAttributeName;

    private final String xAttributeName;

    private final String yAttributeName;

    private MapMatchingConfig(BuilderImpl builder) {
        this.idAttributeName = builder.idAttributeName;
        this.timestampAttributeName = builder.timestampAttributeName;
        this.xAttributeName = builder.xAttributeName;
        this.yAttributeName = builder.yAttributeName;
    }

    /**
     * <p>
     * The field name for the data that describes the identifier representing a collection of GPS points belonging to an
     * individual trace.
     * </p>
     * 
     * @return The field name for the data that describes the identifier representing a collection of GPS points
     *         belonging to an individual trace.
     */
    public final String idAttributeName() {
        return idAttributeName;
    }

    /**
     * <p>
     * The name of the timestamp attribute.
     * </p>
     * 
     * @return The name of the timestamp attribute.
     */
    public final String timestampAttributeName() {
        return timestampAttributeName;
    }

    /**
     * <p>
     * The name of the X-attribute
     * </p>
     * 
     * @return The name of the X-attribute
     */
    public final String xAttributeName() {
        return xAttributeName;
    }

    /**
     * <p>
     * The name of the Y-attribute
     * </p>
     * 
     * @return The name of the Y-attribute
     */
    public final String yAttributeName() {
        return yAttributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(timestampAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(xAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(yAttributeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapMatchingConfig)) {
            return false;
        }
        MapMatchingConfig other = (MapMatchingConfig) obj;
        return Objects.equals(idAttributeName(), other.idAttributeName())
                && Objects.equals(timestampAttributeName(), other.timestampAttributeName())
                && Objects.equals(xAttributeName(), other.xAttributeName())
                && Objects.equals(yAttributeName(), other.yAttributeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MapMatchingConfig").add("IdAttributeName", idAttributeName())
                .add("TimestampAttributeName", timestampAttributeName()).add("XAttributeName", xAttributeName())
                .add("YAttributeName", yAttributeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdAttributeName":
            return Optional.ofNullable(clazz.cast(idAttributeName()));
        case "TimestampAttributeName":
            return Optional.ofNullable(clazz.cast(timestampAttributeName()));
        case "XAttributeName":
            return Optional.ofNullable(clazz.cast(xAttributeName()));
        case "YAttributeName":
            return Optional.ofNullable(clazz.cast(yAttributeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdAttributeName", ID_ATTRIBUTE_NAME_FIELD);
        map.put("TimestampAttributeName", TIMESTAMP_ATTRIBUTE_NAME_FIELD);
        map.put("XAttributeName", X_ATTRIBUTE_NAME_FIELD);
        map.put("YAttributeName", Y_ATTRIBUTE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MapMatchingConfig, T> g) {
        return obj -> g.apply((MapMatchingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MapMatchingConfig> {
        /**
         * <p>
         * The field name for the data that describes the identifier representing a collection of GPS points belonging
         * to an individual trace.
         * </p>
         * 
         * @param idAttributeName
         *        The field name for the data that describes the identifier representing a collection of GPS points
         *        belonging to an individual trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idAttributeName(String idAttributeName);

        /**
         * <p>
         * The name of the timestamp attribute.
         * </p>
         * 
         * @param timestampAttributeName
         *        The name of the timestamp attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampAttributeName(String timestampAttributeName);

        /**
         * <p>
         * The name of the X-attribute
         * </p>
         * 
         * @param xAttributeName
         *        The name of the X-attribute
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAttributeName(String xAttributeName);

        /**
         * <p>
         * The name of the Y-attribute
         * </p>
         * 
         * @param yAttributeName
         *        The name of the Y-attribute
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yAttributeName(String yAttributeName);
    }

    static final class BuilderImpl implements Builder {
        private String idAttributeName;

        private String timestampAttributeName;

        private String xAttributeName;

        private String yAttributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(MapMatchingConfig model) {
            idAttributeName(model.idAttributeName);
            timestampAttributeName(model.timestampAttributeName);
            xAttributeName(model.xAttributeName);
            yAttributeName(model.yAttributeName);
        }

        public final String getIdAttributeName() {
            return idAttributeName;
        }

        public final void setIdAttributeName(String idAttributeName) {
            this.idAttributeName = idAttributeName;
        }

        @Override
        public final Builder idAttributeName(String idAttributeName) {
            this.idAttributeName = idAttributeName;
            return this;
        }

        public final String getTimestampAttributeName() {
            return timestampAttributeName;
        }

        public final void setTimestampAttributeName(String timestampAttributeName) {
            this.timestampAttributeName = timestampAttributeName;
        }

        @Override
        public final Builder timestampAttributeName(String timestampAttributeName) {
            this.timestampAttributeName = timestampAttributeName;
            return this;
        }

        public final String getXAttributeName() {
            return xAttributeName;
        }

        public final void setXAttributeName(String xAttributeName) {
            this.xAttributeName = xAttributeName;
        }

        @Override
        public final Builder xAttributeName(String xAttributeName) {
            this.xAttributeName = xAttributeName;
            return this;
        }

        public final String getYAttributeName() {
            return yAttributeName;
        }

        public final void setYAttributeName(String yAttributeName) {
            this.yAttributeName = yAttributeName;
        }

        @Override
        public final Builder yAttributeName(String yAttributeName) {
            this.yAttributeName = yAttributeName;
            return this;
        }

        @Override
        public MapMatchingConfig build() {
            return new MapMatchingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
