/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input structure for Stacking Operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StackConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<StackConfigInput.Builder, StackConfigInput> {
    private static final SdkField<OutputResolutionStackInput> OUTPUT_RESOLUTION_FIELD = SdkField
            .<OutputResolutionStackInput> builder(MarshallingType.SDK_POJO).memberName("OutputResolution")
            .getter(getter(StackConfigInput::outputResolution)).setter(setter(Builder::outputResolution))
            .constructor(OutputResolutionStackInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputResolution").build()).build();

    private static final SdkField<List<String>> TARGET_BANDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetBands")
            .getter(getter(StackConfigInput::targetBands))
            .setter(setter(Builder::targetBands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_RESOLUTION_FIELD,
            TARGET_BANDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OutputResolutionStackInput outputResolution;

    private final List<String> targetBands;

    private StackConfigInput(BuilderImpl builder) {
        this.outputResolution = builder.outputResolution;
        this.targetBands = builder.targetBands;
    }

    /**
     * <p>
     * The structure representing output resolution (in target georeferenced units) of the result of stacking operation.
     * </p>
     * 
     * @return The structure representing output resolution (in target georeferenced units) of the result of stacking
     *         operation.
     */
    public final OutputResolutionStackInput outputResolution() {
        return outputResolution;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetBands property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetBands() {
        return targetBands != null && !(targetBands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of bands to be stacked in the specified order. When the parameter is not provided, all the available bands
     * in the data collection are stacked in the alphabetical order of their asset names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetBands} method.
     * </p>
     * 
     * @return A list of bands to be stacked in the specified order. When the parameter is not provided, all the
     *         available bands in the data collection are stacked in the alphabetical order of their asset names.
     */
    public final List<String> targetBands() {
        return targetBands;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputResolution());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetBands() ? targetBands() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackConfigInput)) {
            return false;
        }
        StackConfigInput other = (StackConfigInput) obj;
        return Objects.equals(outputResolution(), other.outputResolution()) && hasTargetBands() == other.hasTargetBands()
                && Objects.equals(targetBands(), other.targetBands());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StackConfigInput").add("OutputResolution", outputResolution())
                .add("TargetBands", hasTargetBands() ? targetBands() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputResolution":
            return Optional.ofNullable(clazz.cast(outputResolution()));
        case "TargetBands":
            return Optional.ofNullable(clazz.cast(targetBands()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutputResolution", OUTPUT_RESOLUTION_FIELD);
        map.put("TargetBands", TARGET_BANDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StackConfigInput, T> g) {
        return obj -> g.apply((StackConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StackConfigInput> {
        /**
         * <p>
         * The structure representing output resolution (in target georeferenced units) of the result of stacking
         * operation.
         * </p>
         * 
         * @param outputResolution
         *        The structure representing output resolution (in target georeferenced units) of the result of stacking
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputResolution(OutputResolutionStackInput outputResolution);

        /**
         * <p>
         * The structure representing output resolution (in target georeferenced units) of the result of stacking
         * operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputResolutionStackInput.Builder}
         * avoiding the need to create one manually via {@link OutputResolutionStackInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputResolutionStackInput.Builder#build()} is called immediately
         * and its result is passed to {@link #outputResolution(OutputResolutionStackInput)}.
         * 
         * @param outputResolution
         *        a consumer that will call methods on {@link OutputResolutionStackInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputResolution(OutputResolutionStackInput)
         */
        default Builder outputResolution(Consumer<OutputResolutionStackInput.Builder> outputResolution) {
            return outputResolution(OutputResolutionStackInput.builder().applyMutation(outputResolution).build());
        }

        /**
         * <p>
         * A list of bands to be stacked in the specified order. When the parameter is not provided, all the available
         * bands in the data collection are stacked in the alphabetical order of their asset names.
         * </p>
         * 
         * @param targetBands
         *        A list of bands to be stacked in the specified order. When the parameter is not provided, all the
         *        available bands in the data collection are stacked in the alphabetical order of their asset names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBands(Collection<String> targetBands);

        /**
         * <p>
         * A list of bands to be stacked in the specified order. When the parameter is not provided, all the available
         * bands in the data collection are stacked in the alphabetical order of their asset names.
         * </p>
         * 
         * @param targetBands
         *        A list of bands to be stacked in the specified order. When the parameter is not provided, all the
         *        available bands in the data collection are stacked in the alphabetical order of their asset names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBands(String... targetBands);
    }

    static final class BuilderImpl implements Builder {
        private OutputResolutionStackInput outputResolution;

        private List<String> targetBands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StackConfigInput model) {
            outputResolution(model.outputResolution);
            targetBands(model.targetBands);
        }

        public final OutputResolutionStackInput.Builder getOutputResolution() {
            return outputResolution != null ? outputResolution.toBuilder() : null;
        }

        public final void setOutputResolution(OutputResolutionStackInput.BuilderImpl outputResolution) {
            this.outputResolution = outputResolution != null ? outputResolution.build() : null;
        }

        @Override
        public final Builder outputResolution(OutputResolutionStackInput outputResolution) {
            this.outputResolution = outputResolution;
            return this;
        }

        public final Collection<String> getTargetBands() {
            if (targetBands instanceof SdkAutoConstructList) {
                return null;
            }
            return targetBands;
        }

        public final void setTargetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
        }

        @Override
        public final Builder targetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBands(String... targetBands) {
            targetBands(Arrays.asList(targetBands));
            return this;
        }

        @Override
        public StackConfigInput build() {
            return new StackConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
