/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartVectorEnrichmentJobRequest extends SageMakerGeospatialRequest implements
        ToCopyableBuilder<StartVectorEnrichmentJobRequest.Builder, StartVectorEnrichmentJobRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartVectorEnrichmentJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(StartVectorEnrichmentJobRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<VectorEnrichmentJobInputConfig> INPUT_CONFIG_FIELD = SdkField
            .<VectorEnrichmentJobInputConfig> builder(MarshallingType.SDK_POJO).memberName("InputConfig")
            .getter(getter(StartVectorEnrichmentJobRequest::inputConfig)).setter(setter(Builder::inputConfig))
            .constructor(VectorEnrichmentJobInputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final SdkField<VectorEnrichmentJobConfig> JOB_CONFIG_FIELD = SdkField
            .<VectorEnrichmentJobConfig> builder(MarshallingType.SDK_POJO).memberName("JobConfig")
            .getter(getter(StartVectorEnrichmentJobRequest::jobConfig)).setter(setter(Builder::jobConfig))
            .constructor(VectorEnrichmentJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(StartVectorEnrichmentJobRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartVectorEnrichmentJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(StartVectorEnrichmentJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            EXECUTION_ROLE_ARN_FIELD, INPUT_CONFIG_FIELD, JOB_CONFIG_FIELD, KMS_KEY_ID_FIELD, NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String executionRoleArn;

    private final VectorEnrichmentJobInputConfig inputConfig;

    private final VectorEnrichmentJobConfig jobConfig;

    private final String kmsKeyId;

    private final String name;

    private final Map<String, String> tags;

    private StartVectorEnrichmentJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.executionRoleArn = builder.executionRoleArn;
        this.inputConfig = builder.inputConfig;
        this.jobConfig = builder.jobConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique token that guarantees that the call to this API is idempotent.
     * </p>
     * 
     * @return A unique token that guarantees that the call to this API is idempotent.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * Input configuration information for the Vector Enrichment job.
     * </p>
     * 
     * @return Input configuration information for the Vector Enrichment job.
     */
    public final VectorEnrichmentJobInputConfig inputConfig() {
        return inputConfig;
    }

    /**
     * <p>
     * An object containing information about the job configuration.
     * </p>
     * 
     * @return An object containing information about the job configuration.
     */
    public final VectorEnrichmentJobConfig jobConfig() {
        return jobConfig;
    }

    /**
     * <p>
     * The Key Management Service key ID for server-side encryption.
     * </p>
     * 
     * @return The Key Management Service key ID for server-side encryption.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The name of the Vector Enrichment job.
     * </p>
     * 
     * @return The name of the Vector Enrichment job.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Each tag consists of a key and a value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Each tag consists of a key and a value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartVectorEnrichmentJobRequest)) {
            return false;
        }
        StartVectorEnrichmentJobRequest other = (StartVectorEnrichmentJobRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(inputConfig(), other.inputConfig()) && Objects.equals(jobConfig(), other.jobConfig())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartVectorEnrichmentJobRequest").add("ClientToken", clientToken())
                .add("ExecutionRoleArn", executionRoleArn()).add("InputConfig", inputConfig()).add("JobConfig", jobConfig())
                .add("KmsKeyId", kmsKeyId()).add("Name", name()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        case "JobConfig":
            return Optional.ofNullable(clazz.cast(jobConfig()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("InputConfig", INPUT_CONFIG_FIELD);
        map.put("JobConfig", JOB_CONFIG_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartVectorEnrichmentJobRequest, T> g) {
        return obj -> g.apply((StartVectorEnrichmentJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerGeospatialRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartVectorEnrichmentJobRequest> {
        /**
         * <p>
         * A unique token that guarantees that the call to this API is idempotent.
         * </p>
         * 
         * @param clientToken
         *        A unique token that guarantees that the call to this API is idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * Input configuration information for the Vector Enrichment job.
         * </p>
         * 
         * @param inputConfig
         *        Input configuration information for the Vector Enrichment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(VectorEnrichmentJobInputConfig inputConfig);

        /**
         * <p>
         * Input configuration information for the Vector Enrichment job.
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorEnrichmentJobInputConfig.Builder}
         * avoiding the need to create one manually via {@link VectorEnrichmentJobInputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorEnrichmentJobInputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputConfig(VectorEnrichmentJobInputConfig)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link VectorEnrichmentJobInputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(VectorEnrichmentJobInputConfig)
         */
        default Builder inputConfig(Consumer<VectorEnrichmentJobInputConfig.Builder> inputConfig) {
            return inputConfig(VectorEnrichmentJobInputConfig.builder().applyMutation(inputConfig).build());
        }

        /**
         * <p>
         * An object containing information about the job configuration.
         * </p>
         * 
         * @param jobConfig
         *        An object containing information about the job configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobConfig(VectorEnrichmentJobConfig jobConfig);

        /**
         * <p>
         * An object containing information about the job configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorEnrichmentJobConfig.Builder}
         * avoiding the need to create one manually via {@link VectorEnrichmentJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorEnrichmentJobConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #jobConfig(VectorEnrichmentJobConfig)}.
         * 
         * @param jobConfig
         *        a consumer that will call methods on {@link VectorEnrichmentJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobConfig(VectorEnrichmentJobConfig)
         */
        default Builder jobConfig(Consumer<VectorEnrichmentJobConfig.Builder> jobConfig) {
            return jobConfig(VectorEnrichmentJobConfig.builder().applyMutation(jobConfig).build());
        }

        /**
         * <p>
         * The Key Management Service key ID for server-side encryption.
         * </p>
         * 
         * @param kmsKeyId
         *        The Key Management Service key ID for server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The name of the Vector Enrichment job.
         * </p>
         * 
         * @param name
         *        The name of the Vector Enrichment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Each tag consists of a key and a value.
         * </p>
         * 
         * @param tags
         *        Each tag consists of a key and a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerGeospatialRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String executionRoleArn;

        private VectorEnrichmentJobInputConfig inputConfig;

        private VectorEnrichmentJobConfig jobConfig;

        private String kmsKeyId;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartVectorEnrichmentJobRequest model) {
            super(model);
            clientToken(model.clientToken);
            executionRoleArn(model.executionRoleArn);
            inputConfig(model.inputConfig);
            jobConfig(model.jobConfig);
            kmsKeyId(model.kmsKeyId);
            name(model.name);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final VectorEnrichmentJobInputConfig.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(VectorEnrichmentJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(VectorEnrichmentJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final VectorEnrichmentJobConfig.Builder getJobConfig() {
            return jobConfig != null ? jobConfig.toBuilder() : null;
        }

        public final void setJobConfig(VectorEnrichmentJobConfig.BuilderImpl jobConfig) {
            this.jobConfig = jobConfig != null ? jobConfig.build() : null;
        }

        @Override
        public final Builder jobConfig(VectorEnrichmentJobConfig jobConfig) {
            this.jobConfig = jobConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartVectorEnrichmentJobRequest build() {
            return new StartVectorEnrichmentJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
