/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input structure for specifying ViewSunElevation angle property filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewSunElevationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ViewSunElevationInput.Builder, ViewSunElevationInput> {
    private static final SdkField<Float> LOWER_BOUND_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("LowerBound").getter(getter(ViewSunElevationInput::lowerBound)).setter(setter(Builder::lowerBound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowerBound").build()).build();

    private static final SdkField<Float> UPPER_BOUND_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("UpperBound").getter(getter(ViewSunElevationInput::upperBound)).setter(setter(Builder::upperBound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpperBound").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOWER_BOUND_FIELD,
            UPPER_BOUND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float lowerBound;

    private final Float upperBound;

    private ViewSunElevationInput(BuilderImpl builder) {
        this.lowerBound = builder.lowerBound;
        this.upperBound = builder.upperBound;
    }

    /**
     * <p>
     * The lower bound to view the sun elevation.
     * </p>
     * 
     * @return The lower bound to view the sun elevation.
     */
    public final Float lowerBound() {
        return lowerBound;
    }

    /**
     * <p>
     * The upper bound to view the sun elevation.
     * </p>
     * 
     * @return The upper bound to view the sun elevation.
     */
    public final Float upperBound() {
        return upperBound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lowerBound());
        hashCode = 31 * hashCode + Objects.hashCode(upperBound());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewSunElevationInput)) {
            return false;
        }
        ViewSunElevationInput other = (ViewSunElevationInput) obj;
        return Objects.equals(lowerBound(), other.lowerBound()) && Objects.equals(upperBound(), other.upperBound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViewSunElevationInput").add("LowerBound", lowerBound()).add("UpperBound", upperBound()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LowerBound":
            return Optional.ofNullable(clazz.cast(lowerBound()));
        case "UpperBound":
            return Optional.ofNullable(clazz.cast(upperBound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LowerBound", LOWER_BOUND_FIELD);
        map.put("UpperBound", UPPER_BOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewSunElevationInput, T> g) {
        return obj -> g.apply((ViewSunElevationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViewSunElevationInput> {
        /**
         * <p>
         * The lower bound to view the sun elevation.
         * </p>
         * 
         * @param lowerBound
         *        The lower bound to view the sun elevation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowerBound(Float lowerBound);

        /**
         * <p>
         * The upper bound to view the sun elevation.
         * </p>
         * 
         * @param upperBound
         *        The upper bound to view the sun elevation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upperBound(Float upperBound);
    }

    static final class BuilderImpl implements Builder {
        private Float lowerBound;

        private Float upperBound;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewSunElevationInput model) {
            lowerBound(model.lowerBound);
            upperBound(model.upperBound);
        }

        public final Float getLowerBound() {
            return lowerBound;
        }

        public final void setLowerBound(Float lowerBound) {
            this.lowerBound = lowerBound;
        }

        @Override
        public final Builder lowerBound(Float lowerBound) {
            this.lowerBound = lowerBound;
            return this;
        }

        public final Float getUpperBound() {
            return upperBound;
        }

        public final void setUpperBound(Float upperBound) {
            this.upperBound = upperBound;
        }

        @Override
        public final Builder upperBound(Float upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        @Override
        public ViewSunElevationInput build() {
            return new ViewSunElevationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
