/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakermetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a query to retrieve training metrics from SageMaker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricQueryResult implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricQueryResult.Builder, MetricQueryResult> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MetricQueryResult::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(MetricQueryResult::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<List<Long>> X_AXIS_VALUES_FIELD = SdkField
            .<List<Long>> builder(MarshallingType.LIST)
            .memberName("XAxisValues")
            .getter(getter(MetricQueryResult::xAxisValues))
            .setter(setter(Builder::xAxisValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> METRIC_VALUES_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("MetricValues")
            .getter(getter(MetricQueryResult::metricValues))
            .setter(setter(Builder::metricValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, MESSAGE_FIELD,
            X_AXIS_VALUES_FIELD, METRIC_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String message;

    private final List<Long> xAxisValues;

    private final List<Double> metricValues;

    private MetricQueryResult(BuilderImpl builder) {
        this.status = builder.status;
        this.message = builder.message;
        this.xAxisValues = builder.xAxisValues;
        this.metricValues = builder.metricValues;
    }

    /**
     * <p>
     * The status of the metric query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MetricQueryResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the metric query.
     * @see MetricQueryResultStatus
     */
    public final MetricQueryResultStatus status() {
        return MetricQueryResultStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the metric query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MetricQueryResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the metric query.
     * @see MetricQueryResultStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message describing the status of the metric query.
     * </p>
     * 
     * @return A message describing the status of the metric query.
     */
    public final String message() {
        return message;
    }

    /**
     * For responses, this returns true if the service returned a value for the XAxisValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasXAxisValues() {
        return xAxisValues != null && !(xAxisValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values for the x-axis of the metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasXAxisValues} method.
     * </p>
     * 
     * @return The values for the x-axis of the metrics.
     */
    public final List<Long> xAxisValues() {
        return xAxisValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricValues() {
        return metricValues != null && !(metricValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metric values retrieved by the query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricValues} method.
     * </p>
     * 
     * @return The metric values retrieved by the query.
     */
    public final List<Double> metricValues() {
        return metricValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(hasXAxisValues() ? xAxisValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricValues() ? metricValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricQueryResult)) {
            return false;
        }
        MetricQueryResult other = (MetricQueryResult) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(message(), other.message())
                && hasXAxisValues() == other.hasXAxisValues() && Objects.equals(xAxisValues(), other.xAxisValues())
                && hasMetricValues() == other.hasMetricValues() && Objects.equals(metricValues(), other.metricValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricQueryResult").add("Status", statusAsString()).add("Message", message())
                .add("XAxisValues", hasXAxisValues() ? xAxisValues() : null)
                .add("MetricValues", hasMetricValues() ? metricValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "XAxisValues":
            return Optional.ofNullable(clazz.cast(xAxisValues()));
        case "MetricValues":
            return Optional.ofNullable(clazz.cast(metricValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricQueryResult, T> g) {
        return obj -> g.apply((MetricQueryResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricQueryResult> {
        /**
         * <p>
         * The status of the metric query.
         * </p>
         * 
         * @param status
         *        The status of the metric query.
         * @see MetricQueryResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricQueryResultStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the metric query.
         * </p>
         * 
         * @param status
         *        The status of the metric query.
         * @see MetricQueryResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricQueryResultStatus
         */
        Builder status(MetricQueryResultStatus status);

        /**
         * <p>
         * A message describing the status of the metric query.
         * </p>
         * 
         * @param message
         *        A message describing the status of the metric query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The values for the x-axis of the metrics.
         * </p>
         * 
         * @param xAxisValues
         *        The values for the x-axis of the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxisValues(Collection<Long> xAxisValues);

        /**
         * <p>
         * The values for the x-axis of the metrics.
         * </p>
         * 
         * @param xAxisValues
         *        The values for the x-axis of the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxisValues(Long... xAxisValues);

        /**
         * <p>
         * The metric values retrieved by the query.
         * </p>
         * 
         * @param metricValues
         *        The metric values retrieved by the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValues(Collection<Double> metricValues);

        /**
         * <p>
         * The metric values retrieved by the query.
         * </p>
         * 
         * @param metricValues
         *        The metric values retrieved by the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValues(Double... metricValues);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String message;

        private List<Long> xAxisValues = DefaultSdkAutoConstructList.getInstance();

        private List<Double> metricValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricQueryResult model) {
            status(model.status);
            message(model.message);
            xAxisValues(model.xAxisValues);
            metricValues(model.metricValues);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MetricQueryResultStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Collection<Long> getXAxisValues() {
            if (xAxisValues instanceof SdkAutoConstructList) {
                return null;
            }
            return xAxisValues;
        }

        public final void setXAxisValues(Collection<Long> xAxisValues) {
            this.xAxisValues = XAxisValuesCopier.copy(xAxisValues);
        }

        @Override
        public final Builder xAxisValues(Collection<Long> xAxisValues) {
            this.xAxisValues = XAxisValuesCopier.copy(xAxisValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xAxisValues(Long... xAxisValues) {
            xAxisValues(Arrays.asList(xAxisValues));
            return this;
        }

        public final Collection<Double> getMetricValues() {
            if (metricValues instanceof SdkAutoConstructList) {
                return null;
            }
            return metricValues;
        }

        public final void setMetricValues(Collection<Double> metricValues) {
            this.metricValues = MetricValuesCopier.copy(metricValues);
        }

        @Override
        public final Builder metricValues(Collection<Double> metricValues) {
            this.metricValues = MetricValuesCopier.copy(metricValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricValues(Double... metricValues) {
            metricValues(Arrays.asList(metricValues));
            return this;
        }

        @Override
        public MetricQueryResult build() {
            return new MetricQueryResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
