/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakermetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetMetricsRequest extends SageMakerMetricsRequest implements
        ToCopyableBuilder<BatchGetMetricsRequest.Builder, BatchGetMetricsRequest> {
    private static final SdkField<List<MetricQuery>> METRIC_QUERIES_FIELD = SdkField
            .<List<MetricQuery>> builder(MarshallingType.LIST)
            .memberName("MetricQueries")
            .getter(getter(BatchGetMetricsRequest::metricQueries))
            .setter(setter(Builder::metricQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricQueries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_QUERIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MetricQuery> metricQueries;

    private BatchGetMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.metricQueries = builder.metricQueries;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricQueries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricQueries() {
        return metricQueries != null && !(metricQueries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Queries made to retrieve training metrics from SageMaker.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricQueries} method.
     * </p>
     * 
     * @return Queries made to retrieve training metrics from SageMaker.
     */
    public final List<MetricQuery> metricQueries() {
        return metricQueries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricQueries() ? metricQueries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMetricsRequest)) {
            return false;
        }
        BatchGetMetricsRequest other = (BatchGetMetricsRequest) obj;
        return hasMetricQueries() == other.hasMetricQueries() && Objects.equals(metricQueries(), other.metricQueries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetMetricsRequest").add("MetricQueries", hasMetricQueries() ? metricQueries() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricQueries":
            return Optional.ofNullable(clazz.cast(metricQueries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricQueries", METRIC_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMetricsRequest, T> g) {
        return obj -> g.apply((BatchGetMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerMetricsRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetMetricsRequest> {
        /**
         * <p>
         * Queries made to retrieve training metrics from SageMaker.
         * </p>
         * 
         * @param metricQueries
         *        Queries made to retrieve training metrics from SageMaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricQueries(Collection<MetricQuery> metricQueries);

        /**
         * <p>
         * Queries made to retrieve training metrics from SageMaker.
         * </p>
         * 
         * @param metricQueries
         *        Queries made to retrieve training metrics from SageMaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricQueries(MetricQuery... metricQueries);

        /**
         * <p>
         * Queries made to retrieve training metrics from SageMaker.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakermetrics.model.MetricQuery.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemakermetrics.model.MetricQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakermetrics.model.MetricQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #metricQueries(List<MetricQuery>)}.
         * 
         * @param metricQueries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakermetrics.model.MetricQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricQueries(java.util.Collection<MetricQuery>)
         */
        Builder metricQueries(Consumer<MetricQuery.Builder>... metricQueries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerMetricsRequest.BuilderImpl implements Builder {
        private List<MetricQuery> metricQueries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMetricsRequest model) {
            super(model);
            metricQueries(model.metricQueries);
        }

        public final List<MetricQuery.Builder> getMetricQueries() {
            List<MetricQuery.Builder> result = MetricQueryListCopier.copyToBuilder(this.metricQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricQueries(Collection<MetricQuery.BuilderImpl> metricQueries) {
            this.metricQueries = MetricQueryListCopier.copyFromBuilder(metricQueries);
        }

        @Override
        public final Builder metricQueries(Collection<MetricQuery> metricQueries) {
            this.metricQueries = MetricQueryListCopier.copy(metricQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricQueries(MetricQuery... metricQueries) {
            metricQueries(Arrays.asList(metricQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricQueries(Consumer<MetricQuery.Builder>... metricQueries) {
            metricQueries(Stream.of(metricQueries).map(c -> MetricQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetMetricsRequest build() {
            return new BatchGetMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
