/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakermetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a query to retrieve training metrics from SageMaker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricQuery implements SdkPojo, Serializable, ToCopyableBuilder<MetricQuery.Builder, MetricQuery> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(MetricQuery::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(MetricQuery::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> METRIC_STAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricStat").getter(getter(MetricQuery::metricStatAsString)).setter(setter(Builder::metricStat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricStat").build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Period")
            .getter(getter(MetricQuery::periodAsString)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<String> X_AXIS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XAxisType").getter(getter(MetricQuery::xAxisTypeAsString)).setter(setter(Builder::xAxisType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisType").build()).build();

    private static final SdkField<Long> START_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Start")
            .getter(getter(MetricQuery::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final SdkField<Long> END_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("End")
            .getter(getter(MetricQuery::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            RESOURCE_ARN_FIELD, METRIC_STAT_FIELD, PERIOD_FIELD, X_AXIS_TYPE_FIELD, START_FIELD, END_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String resourceArn;

    private final String metricStat;

    private final String period;

    private final String xAxisType;

    private final Long start;

    private final Long end;

    private MetricQuery(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.resourceArn = builder.resourceArn;
        this.metricStat = builder.metricStat;
        this.period = builder.period;
        this.xAxisType = builder.xAxisType;
        this.start = builder.start;
        this.end = builder.end;
    }

    /**
     * <p>
     * The name of the metric to retrieve.
     * </p>
     * 
     * @return The name of the metric to retrieve.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The ARN of the SageMaker resource to retrieve metrics for.
     * </p>
     * 
     * @return The ARN of the SageMaker resource to retrieve metrics for.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The metrics stat type of metrics to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricStat} will
     * return {@link MetricStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricStatAsString}.
     * </p>
     * 
     * @return The metrics stat type of metrics to retrieve.
     * @see MetricStatistic
     */
    public final MetricStatistic metricStat() {
        return MetricStatistic.fromValue(metricStat);
    }

    /**
     * <p>
     * The metrics stat type of metrics to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricStat} will
     * return {@link MetricStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricStatAsString}.
     * </p>
     * 
     * @return The metrics stat type of metrics to retrieve.
     * @see MetricStatistic
     */
    public final String metricStatAsString() {
        return metricStat;
    }

    /**
     * <p>
     * The time period of metrics to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link Period#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The time period of metrics to retrieve.
     * @see Period
     */
    public final Period period() {
        return Period.fromValue(period);
    }

    /**
     * <p>
     * The time period of metrics to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link Period#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The time period of metrics to retrieve.
     * @see Period
     */
    public final String periodAsString() {
        return period;
    }

    /**
     * <p>
     * The x-axis type of metrics to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #xAxisType} will
     * return {@link XAxisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #xAxisTypeAsString}.
     * </p>
     * 
     * @return The x-axis type of metrics to retrieve.
     * @see XAxisType
     */
    public final XAxisType xAxisType() {
        return XAxisType.fromValue(xAxisType);
    }

    /**
     * <p>
     * The x-axis type of metrics to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #xAxisType} will
     * return {@link XAxisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #xAxisTypeAsString}.
     * </p>
     * 
     * @return The x-axis type of metrics to retrieve.
     * @see XAxisType
     */
    public final String xAxisTypeAsString() {
        return xAxisType;
    }

    /**
     * <p>
     * The start time of metrics to retrieve.
     * </p>
     * 
     * @return The start time of metrics to retrieve.
     */
    public final Long start() {
        return start;
    }

    /**
     * <p>
     * The end time of metrics to retrieve.
     * </p>
     * 
     * @return The end time of metrics to retrieve.
     */
    public final Long end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricStatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(xAxisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricQuery)) {
            return false;
        }
        MetricQuery other = (MetricQuery) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(metricStatAsString(), other.metricStatAsString())
                && Objects.equals(periodAsString(), other.periodAsString())
                && Objects.equals(xAxisTypeAsString(), other.xAxisTypeAsString()) && Objects.equals(start(), other.start())
                && Objects.equals(end(), other.end());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricQuery").add("MetricName", metricName()).add("ResourceArn", resourceArn())
                .add("MetricStat", metricStatAsString()).add("Period", periodAsString()).add("XAxisType", xAxisTypeAsString())
                .add("Start", start()).add("End", end()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "MetricStat":
            return Optional.ofNullable(clazz.cast(metricStatAsString()));
        case "Period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        case "XAxisType":
            return Optional.ofNullable(clazz.cast(xAxisTypeAsString()));
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("MetricStat", METRIC_STAT_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("XAxisType", X_AXIS_TYPE_FIELD);
        map.put("Start", START_FIELD);
        map.put("End", END_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricQuery, T> g) {
        return obj -> g.apply((MetricQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricQuery> {
        /**
         * <p>
         * The name of the metric to retrieve.
         * </p>
         * 
         * @param metricName
         *        The name of the metric to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The ARN of the SageMaker resource to retrieve metrics for.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the SageMaker resource to retrieve metrics for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The metrics stat type of metrics to retrieve.
         * </p>
         * 
         * @param metricStat
         *        The metrics stat type of metrics to retrieve.
         * @see MetricStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStatistic
         */
        Builder metricStat(String metricStat);

        /**
         * <p>
         * The metrics stat type of metrics to retrieve.
         * </p>
         * 
         * @param metricStat
         *        The metrics stat type of metrics to retrieve.
         * @see MetricStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStatistic
         */
        Builder metricStat(MetricStatistic metricStat);

        /**
         * <p>
         * The time period of metrics to retrieve.
         * </p>
         * 
         * @param period
         *        The time period of metrics to retrieve.
         * @see Period
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Period
         */
        Builder period(String period);

        /**
         * <p>
         * The time period of metrics to retrieve.
         * </p>
         * 
         * @param period
         *        The time period of metrics to retrieve.
         * @see Period
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Period
         */
        Builder period(Period period);

        /**
         * <p>
         * The x-axis type of metrics to retrieve.
         * </p>
         * 
         * @param xAxisType
         *        The x-axis type of metrics to retrieve.
         * @see XAxisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XAxisType
         */
        Builder xAxisType(String xAxisType);

        /**
         * <p>
         * The x-axis type of metrics to retrieve.
         * </p>
         * 
         * @param xAxisType
         *        The x-axis type of metrics to retrieve.
         * @see XAxisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XAxisType
         */
        Builder xAxisType(XAxisType xAxisType);

        /**
         * <p>
         * The start time of metrics to retrieve.
         * </p>
         * 
         * @param start
         *        The start time of metrics to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Long start);

        /**
         * <p>
         * The end time of metrics to retrieve.
         * </p>
         * 
         * @param end
         *        The end time of metrics to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Long end);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String resourceArn;

        private String metricStat;

        private String period;

        private String xAxisType;

        private Long start;

        private Long end;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricQuery model) {
            metricName(model.metricName);
            resourceArn(model.resourceArn);
            metricStat(model.metricStat);
            period(model.period);
            xAxisType(model.xAxisType);
            start(model.start);
            end(model.end);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getMetricStat() {
            return metricStat;
        }

        public final void setMetricStat(String metricStat) {
            this.metricStat = metricStat;
        }

        @Override
        public final Builder metricStat(String metricStat) {
            this.metricStat = metricStat;
            return this;
        }

        @Override
        public final Builder metricStat(MetricStatistic metricStat) {
            this.metricStat(metricStat == null ? null : metricStat.toString());
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(Period period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final String getXAxisType() {
            return xAxisType;
        }

        public final void setXAxisType(String xAxisType) {
            this.xAxisType = xAxisType;
        }

        @Override
        public final Builder xAxisType(String xAxisType) {
            this.xAxisType = xAxisType;
            return this;
        }

        @Override
        public final Builder xAxisType(XAxisType xAxisType) {
            this.xAxisType(xAxisType == null ? null : xAxisType.toString());
            return this;
        }

        public final Long getStart() {
            return start;
        }

        public final void setStart(Long start) {
            this.start = start;
        }

        @Override
        public final Builder start(Long start) {
            this.start = start;
            return this;
        }

        public final Long getEnd() {
            return end;
        }

        public final void setEnd(Long end) {
            this.end = end;
        }

        @Override
        public final Builder end(Long end) {
            this.end = end;
            return this;
        }

        @Override
        public MetricQuery build() {
            return new MetricQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
