/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakermetrics;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.sagemakermetrics.model.BatchGetMetricsRequest;
import software.amazon.awssdk.services.sagemakermetrics.model.BatchGetMetricsResponse;
import software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsRequest;
import software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsResponse;
import software.amazon.awssdk.services.sagemakermetrics.model.SageMakerMetricsException;

/**
 * Service client for accessing SageMaker Metrics. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Contains all data plane API operations and data types for Amazon SageMaker Metrics. Use these APIs to put and
 * retrieve (get) features related to your training run.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_metrics_BatchPutMetrics.html">BatchPutMetrics</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SageMakerMetricsClient extends AwsClient {
    String SERVICE_NAME = "sagemaker";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "metrics.sagemaker";

    /**
     * <p>
     * Used to retrieve training metrics from SageMaker.
     * </p>
     *
     * @param batchGetMetricsRequest
     * @return Result of the BatchGetMetrics operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerMetricsClient.BatchGetMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-metrics-2022-09-30/BatchGetMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetMetricsResponse batchGetMetrics(BatchGetMetricsRequest batchGetMetricsRequest) throws AwsServiceException,
            SdkClientException, SageMakerMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to retrieve training metrics from SageMaker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetMetricsRequest#builder()}
     * </p>
     *
     * @param batchGetMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakermetrics.model.BatchGetMetricsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetMetrics operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerMetricsClient.BatchGetMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-metrics-2022-09-30/BatchGetMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetMetricsResponse batchGetMetrics(Consumer<BatchGetMetricsRequest.Builder> batchGetMetricsRequest)
            throws AwsServiceException, SdkClientException, SageMakerMetricsException {
        return batchGetMetrics(BatchGetMetricsRequest.builder().applyMutation(batchGetMetricsRequest).build());
    }

    /**
     * <p>
     * Used to ingest training metrics into SageMaker. These metrics can be visualized in SageMaker Studio.
     * </p>
     *
     * @param batchPutMetricsRequest
     * @return Result of the BatchPutMetrics operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerMetricsClient.BatchPutMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-metrics-2022-09-30/BatchPutMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutMetricsResponse batchPutMetrics(BatchPutMetricsRequest batchPutMetricsRequest) throws AwsServiceException,
            SdkClientException, SageMakerMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to ingest training metrics into SageMaker. These metrics can be visualized in SageMaker Studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutMetricsRequest#builder()}
     * </p>
     *
     * @param batchPutMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchPutMetrics operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerMetricsClient.BatchPutMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-metrics-2022-09-30/BatchPutMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutMetricsResponse batchPutMetrics(Consumer<BatchPutMetricsRequest.Builder> batchPutMetricsRequest)
            throws AwsServiceException, SdkClientException, SageMakerMetricsException {
        return batchPutMetrics(BatchPutMetricsRequest.builder().applyMutation(batchPutMetricsRequest).build());
    }

    /**
     * Create a {@link SageMakerMetricsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SageMakerMetricsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SageMakerMetricsClient}.
     */
    static SageMakerMetricsClientBuilder builder() {
        return new DefaultSageMakerMetricsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SageMakerMetricsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
